// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model



/**
 * Container for the parameters to the ` <a>DescribeInstanceTypeLimits</a> ` operation.
 */
class DescribeInstanceTypeLimitsRequest private constructor(builder: Builder) {
    /**
     * The name of the domain you want to modify. Only include this value if you're querying OpenSearch ` <a>Limits</a> ` for an existing domain.
     */
    val domainName: kotlin.String? = builder.domainName
    /**
     * Version of OpenSearch for which ` <a>Limits</a> ` are needed.
     */
    val engineVersion: kotlin.String? = requireNotNull(builder.engineVersion) { "A non-null value must be provided for engineVersion" }
    /**
     * The instance type for an OpenSearch cluster for which OpenSearch ` <a>Limits</a> ` are needed.
     */
    val instanceType: aws.sdk.kotlin.services.opensearch.model.OpenSearchPartitionInstanceType? = requireNotNull(builder.instanceType) { "A non-null value must be provided for instanceType" }

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.DescribeInstanceTypeLimitsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeInstanceTypeLimitsRequest(")
        append("domainName=$domainName,")
        append("engineVersion=$engineVersion,")
        append("instanceType=$instanceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName?.hashCode() ?: 0
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeInstanceTypeLimitsRequest

        if (domainName != other.domainName) return false
        if (engineVersion != other.engineVersion) return false
        if (instanceType != other.instanceType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.DescribeInstanceTypeLimitsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the domain you want to modify. Only include this value if you're querying OpenSearch ` <a>Limits</a> ` for an existing domain.
         */
        var domainName: kotlin.String? = null
        /**
         * Version of OpenSearch for which ` <a>Limits</a> ` are needed.
         */
        var engineVersion: kotlin.String? = null
        /**
         * The instance type for an OpenSearch cluster for which OpenSearch ` <a>Limits</a> ` are needed.
         */
        var instanceType: aws.sdk.kotlin.services.opensearch.model.OpenSearchPartitionInstanceType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.DescribeInstanceTypeLimitsRequest) : this() {
            this.domainName = x.domainName
            this.engineVersion = x.engineVersion
            this.instanceType = x.instanceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.DescribeInstanceTypeLimitsRequest = DescribeInstanceTypeLimitsRequest(this)
    }
}
