// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model



/**
 * Options to configure the endpoint for the domain.
 */
class DomainEndpointOptions private constructor(builder: Builder) {
    /**
     * The fully qualified domain for your custom endpoint.
     */
    val customEndpoint: kotlin.String? = builder.customEndpoint
    /**
     * The ACM certificate ARN for your custom endpoint.
     */
    val customEndpointCertificateArn: kotlin.String? = builder.customEndpointCertificateArn
    /**
     * Whether to enable a custom endpoint for the domain.
     */
    val customEndpointEnabled: kotlin.Boolean? = builder.customEndpointEnabled
    /**
     * Whether only HTTPS endpoint should be enabled for the domain.
     */
    val enforceHttps: kotlin.Boolean? = builder.enforceHttps
    /**
     * Specify the TLS security policy to apply to the HTTPS endpoint of the domain.
     *  Can be one of the following values:
     * + **Policy-Min-TLS-1-0-2019-07:** TLS security policy which supports TLSv1.0 and higher.
     * + **Policy-Min-TLS-1-2-2019-07:** TLS security policy which supports only TLSv1.2
     */
    val tlsSecurityPolicy: aws.sdk.kotlin.services.opensearch.model.TlsSecurityPolicy? = builder.tlsSecurityPolicy

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainEndpointOptions(")
        append("customEndpoint=$customEndpoint,")
        append("customEndpointCertificateArn=$customEndpointCertificateArn,")
        append("customEndpointEnabled=$customEndpointEnabled,")
        append("enforceHttps=$enforceHttps,")
        append("tlsSecurityPolicy=$tlsSecurityPolicy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customEndpoint?.hashCode() ?: 0
        result = 31 * result + (customEndpointCertificateArn?.hashCode() ?: 0)
        result = 31 * result + (customEndpointEnabled?.hashCode() ?: 0)
        result = 31 * result + (enforceHttps?.hashCode() ?: 0)
        result = 31 * result + (tlsSecurityPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainEndpointOptions

        if (customEndpoint != other.customEndpoint) return false
        if (customEndpointCertificateArn != other.customEndpointCertificateArn) return false
        if (customEndpointEnabled != other.customEndpointEnabled) return false
        if (enforceHttps != other.enforceHttps) return false
        if (tlsSecurityPolicy != other.tlsSecurityPolicy) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptions = Builder(this).apply(block).build()

    class Builder {
        /**
         * The fully qualified domain for your custom endpoint.
         */
        var customEndpoint: kotlin.String? = null
        /**
         * The ACM certificate ARN for your custom endpoint.
         */
        var customEndpointCertificateArn: kotlin.String? = null
        /**
         * Whether to enable a custom endpoint for the domain.
         */
        var customEndpointEnabled: kotlin.Boolean? = null
        /**
         * Whether only HTTPS endpoint should be enabled for the domain.
         */
        var enforceHttps: kotlin.Boolean? = null
        /**
         * Specify the TLS security policy to apply to the HTTPS endpoint of the domain.
         *  Can be one of the following values:
         * + **Policy-Min-TLS-1-0-2019-07:** TLS security policy which supports TLSv1.0 and higher.
         * + **Policy-Min-TLS-1-2-2019-07:** TLS security policy which supports only TLSv1.2
         */
        var tlsSecurityPolicy: aws.sdk.kotlin.services.opensearch.model.TlsSecurityPolicy? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptions) : this() {
            this.customEndpoint = x.customEndpoint
            this.customEndpointCertificateArn = x.customEndpointCertificateArn
            this.customEndpointEnabled = x.customEndpointEnabled
            this.enforceHttps = x.enforceHttps
            this.tlsSecurityPolicy = x.tlsSecurityPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptions = DomainEndpointOptions(this)
    }
}
