// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information on a package associated with a domain.
 */
class DomainPackageDetails private constructor(builder: Builder) {
    /**
     * The name of the domain you've associated a package with.
     */
    val domainName: kotlin.String? = builder.domainName
    /**
     * State of the association. Values are ASSOCIATING, ASSOCIATION_FAILED, ACTIVE, DISSOCIATING, and DISSOCIATION_FAILED.
     */
    val domainPackageStatus: aws.sdk.kotlin.services.opensearch.model.DomainPackageStatus? = builder.domainPackageStatus
    /**
     * Additional information if the package is in an error state. Null otherwise.
     */
    val errorDetails: aws.sdk.kotlin.services.opensearch.model.ErrorDetails? = builder.errorDetails
    /**
     * The timestamp of the most recent update to the package association status.
     */
    val lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdated
    /**
     * The internal ID of the package.
     */
    val packageId: kotlin.String? = builder.packageId
    /**
     * User-specified name of the package.
     */
    val packageName: kotlin.String? = builder.packageName
    /**
     * Currently supports only TXT-DICTIONARY.
     */
    val packageType: aws.sdk.kotlin.services.opensearch.model.PackageType? = builder.packageType
    val packageVersion: kotlin.String? = builder.packageVersion
    /**
     * The relative path on Amazon OpenSearch Service nodes, which can be used as synonym_path when the package is a synonym file.
     */
    val referencePath: kotlin.String? = builder.referencePath

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.DomainPackageDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainPackageDetails(")
        append("domainName=$domainName,")
        append("domainPackageStatus=$domainPackageStatus,")
        append("errorDetails=$errorDetails,")
        append("lastUpdated=$lastUpdated,")
        append("packageId=$packageId,")
        append("packageName=$packageName,")
        append("packageType=$packageType,")
        append("packageVersion=$packageVersion,")
        append("referencePath=$referencePath)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName?.hashCode() ?: 0
        result = 31 * result + (domainPackageStatus?.hashCode() ?: 0)
        result = 31 * result + (errorDetails?.hashCode() ?: 0)
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (packageId?.hashCode() ?: 0)
        result = 31 * result + (packageName?.hashCode() ?: 0)
        result = 31 * result + (packageType?.hashCode() ?: 0)
        result = 31 * result + (packageVersion?.hashCode() ?: 0)
        result = 31 * result + (referencePath?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainPackageDetails

        if (domainName != other.domainName) return false
        if (domainPackageStatus != other.domainPackageStatus) return false
        if (errorDetails != other.errorDetails) return false
        if (lastUpdated != other.lastUpdated) return false
        if (packageId != other.packageId) return false
        if (packageName != other.packageName) return false
        if (packageType != other.packageType) return false
        if (packageVersion != other.packageVersion) return false
        if (referencePath != other.referencePath) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.DomainPackageDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the domain you've associated a package with.
         */
        var domainName: kotlin.String? = null
        /**
         * State of the association. Values are ASSOCIATING, ASSOCIATION_FAILED, ACTIVE, DISSOCIATING, and DISSOCIATION_FAILED.
         */
        var domainPackageStatus: aws.sdk.kotlin.services.opensearch.model.DomainPackageStatus? = null
        /**
         * Additional information if the package is in an error state. Null otherwise.
         */
        var errorDetails: aws.sdk.kotlin.services.opensearch.model.ErrorDetails? = null
        /**
         * The timestamp of the most recent update to the package association status.
         */
        var lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The internal ID of the package.
         */
        var packageId: kotlin.String? = null
        /**
         * User-specified name of the package.
         */
        var packageName: kotlin.String? = null
        /**
         * Currently supports only TXT-DICTIONARY.
         */
        var packageType: aws.sdk.kotlin.services.opensearch.model.PackageType? = null
        var packageVersion: kotlin.String? = null
        /**
         * The relative path on Amazon OpenSearch Service nodes, which can be used as synonym_path when the package is a synonym file.
         */
        var referencePath: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.DomainPackageDetails) : this() {
            this.domainName = x.domainName
            this.domainPackageStatus = x.domainPackageStatus
            this.errorDetails = x.errorDetails
            this.lastUpdated = x.lastUpdated
            this.packageId = x.packageId
            this.packageName = x.packageName
            this.packageType = x.packageType
            this.packageVersion = x.packageVersion
            this.referencePath = x.referencePath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.DomainPackageDetails = DomainPackageDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.ErrorDetails] inside the given [block]
         */
        fun errorDetails(block: aws.sdk.kotlin.services.opensearch.model.ErrorDetails.Builder.() -> kotlin.Unit) {
            this.errorDetails = aws.sdk.kotlin.services.opensearch.model.ErrorDetails.invoke(block)
        }
    }
}
