// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model



/**
 * The current status of a domain.
 */
class DomainStatus private constructor(builder: Builder) {
    /**
     * IAM access policy as a JSON-formatted string.
     */
    val accessPolicies: kotlin.String? = builder.accessPolicies
    /**
     * The status of the `AdvancedOptions`.
     */
    val advancedOptions: Map<String, String>? = builder.advancedOptions
    /**
     * The current status of the domain's advanced security options.
     */
    val advancedSecurityOptions: aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptions? = builder.advancedSecurityOptions
    /**
     * The Amazon Resource Name (ARN) of a domain. See [IAM identifiers ](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html) in the *AWS Identity and Access Management User Guide* for more information.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The current status of the domain's Auto-Tune options.
     */
    val autoTuneOptions: aws.sdk.kotlin.services.opensearch.model.AutoTuneOptionsOutput? = builder.autoTuneOptions
    /**
     * Specifies change details of the domain configuration change.
     */
    val changeProgressDetails: aws.sdk.kotlin.services.opensearch.model.ChangeProgressDetails? = builder.changeProgressDetails
    /**
     * The type and number of instances in the domain.
     */
    val clusterConfig: aws.sdk.kotlin.services.opensearch.model.ClusterConfig? = builder.clusterConfig
    /**
     * The `CognitoOptions` for the specified domain. For more information, see [Configuring Amazon Cognito authentication for OpenSearch Dashboards](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html).
     */
    val cognitoOptions: aws.sdk.kotlin.services.opensearch.model.CognitoOptions? = builder.cognitoOptions
    /**
     * The domain creation status. `True` if the creation of a domain is complete. ` False ` if domain creation is still in progress.
     */
    val created: kotlin.Boolean? = builder.created
    /**
     * The domain deletion status. `True` if a delete request has been received for the domain but resource cleanup is still in progress. `False` if the domain has not been deleted. Once domain deletion is complete, the status of the domain is no longer returned.
     */
    val deleted: kotlin.Boolean? = builder.deleted
    /**
     * The current status of the domain's endpoint options.
     */
    val domainEndpointOptions: aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptions? = builder.domainEndpointOptions
    /**
     * The unique identifier for the specified domain.
     */
    val domainId: kotlin.String? = builder.domainId
    /**
     * The name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
     */
    val domainName: kotlin.String? = builder.domainName
    /**
     * The `EBSOptions` for the specified domain.
     */
    val ebsOptions: aws.sdk.kotlin.services.opensearch.model.EbsOptions? = builder.ebsOptions
    /**
     * The status of the `EncryptionAtRestOptions`.
     */
    val encryptionAtRestOptions: aws.sdk.kotlin.services.opensearch.model.EncryptionAtRestOptions? = builder.encryptionAtRestOptions
    /**
     * The domain endpoint that you use to submit index and search requests.
     */
    val endpoint: kotlin.String? = builder.endpoint
    /**
     * Map containing the domain endpoints used to submit index and search requests. Example `key, value`: `'vpc','vpc-endpoint-h2dsd34efgyghrtguk5gt6j2foh4.us-east-1.es.amazonaws.com'`.
     */
    val endpoints: Map<String, String>? = builder.endpoints
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Log publishing options for the given domain.
     */
    val logPublishingOptions: Map<String, LogPublishingOption>? = builder.logPublishingOptions
    /**
     * The status of the `NodeToNodeEncryptionOptions`.
     */
    val nodeToNodeEncryptionOptions: aws.sdk.kotlin.services.opensearch.model.NodeToNodeEncryptionOptions? = builder.nodeToNodeEncryptionOptions
    /**
     * The status of the domain configuration. `True` if Amazon OpenSearch Service is processing configuration changes. `False` if the configuration is active.
     */
    val processing: kotlin.Boolean? = builder.processing
    /**
     * The current status of the domain's service software.
     */
    val serviceSoftwareOptions: aws.sdk.kotlin.services.opensearch.model.ServiceSoftwareOptions? = builder.serviceSoftwareOptions
    /**
     * The status of the `SnapshotOptions`.
     */
    val snapshotOptions: aws.sdk.kotlin.services.opensearch.model.SnapshotOptions? = builder.snapshotOptions
    /**
     * The status of a domain version upgrade. `True` if Amazon OpenSearch Service is undergoing a version upgrade. `False` if the configuration is active.
     */
    val upgradeProcessing: kotlin.Boolean? = builder.upgradeProcessing
    /**
     * The `VPCOptions` for the specified domain. For more information, see [ Launching your Amazon OpenSearch Service domains using a VPC](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html).
     */
    val vpcOptions: aws.sdk.kotlin.services.opensearch.model.VpcDerivedInfo? = builder.vpcOptions

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.DomainStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainStatus(")
        append("accessPolicies=$accessPolicies,")
        append("advancedOptions=$advancedOptions,")
        append("advancedSecurityOptions=$advancedSecurityOptions,")
        append("arn=$arn,")
        append("autoTuneOptions=$autoTuneOptions,")
        append("changeProgressDetails=$changeProgressDetails,")
        append("clusterConfig=$clusterConfig,")
        append("cognitoOptions=$cognitoOptions,")
        append("created=$created,")
        append("deleted=$deleted,")
        append("domainEndpointOptions=$domainEndpointOptions,")
        append("domainId=$domainId,")
        append("domainName=$domainName,")
        append("ebsOptions=$ebsOptions,")
        append("encryptionAtRestOptions=$encryptionAtRestOptions,")
        append("endpoint=$endpoint,")
        append("endpoints=$endpoints,")
        append("engineVersion=$engineVersion,")
        append("logPublishingOptions=$logPublishingOptions,")
        append("nodeToNodeEncryptionOptions=$nodeToNodeEncryptionOptions,")
        append("processing=$processing,")
        append("serviceSoftwareOptions=$serviceSoftwareOptions,")
        append("snapshotOptions=$snapshotOptions,")
        append("upgradeProcessing=$upgradeProcessing,")
        append("vpcOptions=$vpcOptions)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPolicies?.hashCode() ?: 0
        result = 31 * result + (advancedOptions?.hashCode() ?: 0)
        result = 31 * result + (advancedSecurityOptions?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (autoTuneOptions?.hashCode() ?: 0)
        result = 31 * result + (changeProgressDetails?.hashCode() ?: 0)
        result = 31 * result + (clusterConfig?.hashCode() ?: 0)
        result = 31 * result + (cognitoOptions?.hashCode() ?: 0)
        result = 31 * result + (created?.hashCode() ?: 0)
        result = 31 * result + (deleted?.hashCode() ?: 0)
        result = 31 * result + (domainEndpointOptions?.hashCode() ?: 0)
        result = 31 * result + (domainId?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (ebsOptions?.hashCode() ?: 0)
        result = 31 * result + (encryptionAtRestOptions?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (endpoints?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (logPublishingOptions?.hashCode() ?: 0)
        result = 31 * result + (nodeToNodeEncryptionOptions?.hashCode() ?: 0)
        result = 31 * result + (processing?.hashCode() ?: 0)
        result = 31 * result + (serviceSoftwareOptions?.hashCode() ?: 0)
        result = 31 * result + (snapshotOptions?.hashCode() ?: 0)
        result = 31 * result + (upgradeProcessing?.hashCode() ?: 0)
        result = 31 * result + (vpcOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainStatus

        if (accessPolicies != other.accessPolicies) return false
        if (advancedOptions != other.advancedOptions) return false
        if (advancedSecurityOptions != other.advancedSecurityOptions) return false
        if (arn != other.arn) return false
        if (autoTuneOptions != other.autoTuneOptions) return false
        if (changeProgressDetails != other.changeProgressDetails) return false
        if (clusterConfig != other.clusterConfig) return false
        if (cognitoOptions != other.cognitoOptions) return false
        if (created != other.created) return false
        if (deleted != other.deleted) return false
        if (domainEndpointOptions != other.domainEndpointOptions) return false
        if (domainId != other.domainId) return false
        if (domainName != other.domainName) return false
        if (ebsOptions != other.ebsOptions) return false
        if (encryptionAtRestOptions != other.encryptionAtRestOptions) return false
        if (endpoint != other.endpoint) return false
        if (endpoints != other.endpoints) return false
        if (engineVersion != other.engineVersion) return false
        if (logPublishingOptions != other.logPublishingOptions) return false
        if (nodeToNodeEncryptionOptions != other.nodeToNodeEncryptionOptions) return false
        if (processing != other.processing) return false
        if (serviceSoftwareOptions != other.serviceSoftwareOptions) return false
        if (snapshotOptions != other.snapshotOptions) return false
        if (upgradeProcessing != other.upgradeProcessing) return false
        if (vpcOptions != other.vpcOptions) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.DomainStatus = Builder(this).apply(block).build()

    class Builder {
        /**
         * IAM access policy as a JSON-formatted string.
         */
        var accessPolicies: kotlin.String? = null
        /**
         * The status of the `AdvancedOptions`.
         */
        var advancedOptions: Map<String, String>? = null
        /**
         * The current status of the domain's advanced security options.
         */
        var advancedSecurityOptions: aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptions? = null
        /**
         * The Amazon Resource Name (ARN) of a domain. See [IAM identifiers ](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html) in the *AWS Identity and Access Management User Guide* for more information.
         */
        var arn: kotlin.String? = null
        /**
         * The current status of the domain's Auto-Tune options.
         */
        var autoTuneOptions: aws.sdk.kotlin.services.opensearch.model.AutoTuneOptionsOutput? = null
        /**
         * Specifies change details of the domain configuration change.
         */
        var changeProgressDetails: aws.sdk.kotlin.services.opensearch.model.ChangeProgressDetails? = null
        /**
         * The type and number of instances in the domain.
         */
        var clusterConfig: aws.sdk.kotlin.services.opensearch.model.ClusterConfig? = null
        /**
         * The `CognitoOptions` for the specified domain. For more information, see [Configuring Amazon Cognito authentication for OpenSearch Dashboards](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html).
         */
        var cognitoOptions: aws.sdk.kotlin.services.opensearch.model.CognitoOptions? = null
        /**
         * The domain creation status. `True` if the creation of a domain is complete. ` False ` if domain creation is still in progress.
         */
        var created: kotlin.Boolean? = null
        /**
         * The domain deletion status. `True` if a delete request has been received for the domain but resource cleanup is still in progress. `False` if the domain has not been deleted. Once domain deletion is complete, the status of the domain is no longer returned.
         */
        var deleted: kotlin.Boolean? = null
        /**
         * The current status of the domain's endpoint options.
         */
        var domainEndpointOptions: aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptions? = null
        /**
         * The unique identifier for the specified domain.
         */
        var domainId: kotlin.String? = null
        /**
         * The name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
         */
        var domainName: kotlin.String? = null
        /**
         * The `EBSOptions` for the specified domain.
         */
        var ebsOptions: aws.sdk.kotlin.services.opensearch.model.EbsOptions? = null
        /**
         * The status of the `EncryptionAtRestOptions`.
         */
        var encryptionAtRestOptions: aws.sdk.kotlin.services.opensearch.model.EncryptionAtRestOptions? = null
        /**
         * The domain endpoint that you use to submit index and search requests.
         */
        var endpoint: kotlin.String? = null
        /**
         * Map containing the domain endpoints used to submit index and search requests. Example `key, value`: `'vpc','vpc-endpoint-h2dsd34efgyghrtguk5gt6j2foh4.us-east-1.es.amazonaws.com'`.
         */
        var endpoints: Map<String, String>? = null
        var engineVersion: kotlin.String? = null
        /**
         * Log publishing options for the given domain.
         */
        var logPublishingOptions: Map<String, LogPublishingOption>? = null
        /**
         * The status of the `NodeToNodeEncryptionOptions`.
         */
        var nodeToNodeEncryptionOptions: aws.sdk.kotlin.services.opensearch.model.NodeToNodeEncryptionOptions? = null
        /**
         * The status of the domain configuration. `True` if Amazon OpenSearch Service is processing configuration changes. `False` if the configuration is active.
         */
        var processing: kotlin.Boolean? = null
        /**
         * The current status of the domain's service software.
         */
        var serviceSoftwareOptions: aws.sdk.kotlin.services.opensearch.model.ServiceSoftwareOptions? = null
        /**
         * The status of the `SnapshotOptions`.
         */
        var snapshotOptions: aws.sdk.kotlin.services.opensearch.model.SnapshotOptions? = null
        /**
         * The status of a domain version upgrade. `True` if Amazon OpenSearch Service is undergoing a version upgrade. `False` if the configuration is active.
         */
        var upgradeProcessing: kotlin.Boolean? = null
        /**
         * The `VPCOptions` for the specified domain. For more information, see [ Launching your Amazon OpenSearch Service domains using a VPC](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html).
         */
        var vpcOptions: aws.sdk.kotlin.services.opensearch.model.VpcDerivedInfo? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.DomainStatus) : this() {
            this.accessPolicies = x.accessPolicies
            this.advancedOptions = x.advancedOptions
            this.advancedSecurityOptions = x.advancedSecurityOptions
            this.arn = x.arn
            this.autoTuneOptions = x.autoTuneOptions
            this.changeProgressDetails = x.changeProgressDetails
            this.clusterConfig = x.clusterConfig
            this.cognitoOptions = x.cognitoOptions
            this.created = x.created
            this.deleted = x.deleted
            this.domainEndpointOptions = x.domainEndpointOptions
            this.domainId = x.domainId
            this.domainName = x.domainName
            this.ebsOptions = x.ebsOptions
            this.encryptionAtRestOptions = x.encryptionAtRestOptions
            this.endpoint = x.endpoint
            this.endpoints = x.endpoints
            this.engineVersion = x.engineVersion
            this.logPublishingOptions = x.logPublishingOptions
            this.nodeToNodeEncryptionOptions = x.nodeToNodeEncryptionOptions
            this.processing = x.processing
            this.serviceSoftwareOptions = x.serviceSoftwareOptions
            this.snapshotOptions = x.snapshotOptions
            this.upgradeProcessing = x.upgradeProcessing
            this.vpcOptions = x.vpcOptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.DomainStatus = DomainStatus(this)

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptions] inside the given [block]
         */
        fun advancedSecurityOptions(block: aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptions.Builder.() -> kotlin.Unit) {
            this.advancedSecurityOptions = aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.AutoTuneOptionsOutput] inside the given [block]
         */
        fun autoTuneOptions(block: aws.sdk.kotlin.services.opensearch.model.AutoTuneOptionsOutput.Builder.() -> kotlin.Unit) {
            this.autoTuneOptions = aws.sdk.kotlin.services.opensearch.model.AutoTuneOptionsOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.ChangeProgressDetails] inside the given [block]
         */
        fun changeProgressDetails(block: aws.sdk.kotlin.services.opensearch.model.ChangeProgressDetails.Builder.() -> kotlin.Unit) {
            this.changeProgressDetails = aws.sdk.kotlin.services.opensearch.model.ChangeProgressDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.ClusterConfig] inside the given [block]
         */
        fun clusterConfig(block: aws.sdk.kotlin.services.opensearch.model.ClusterConfig.Builder.() -> kotlin.Unit) {
            this.clusterConfig = aws.sdk.kotlin.services.opensearch.model.ClusterConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.CognitoOptions] inside the given [block]
         */
        fun cognitoOptions(block: aws.sdk.kotlin.services.opensearch.model.CognitoOptions.Builder.() -> kotlin.Unit) {
            this.cognitoOptions = aws.sdk.kotlin.services.opensearch.model.CognitoOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptions] inside the given [block]
         */
        fun domainEndpointOptions(block: aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptions.Builder.() -> kotlin.Unit) {
            this.domainEndpointOptions = aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.EbsOptions] inside the given [block]
         */
        fun ebsOptions(block: aws.sdk.kotlin.services.opensearch.model.EbsOptions.Builder.() -> kotlin.Unit) {
            this.ebsOptions = aws.sdk.kotlin.services.opensearch.model.EbsOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.EncryptionAtRestOptions] inside the given [block]
         */
        fun encryptionAtRestOptions(block: aws.sdk.kotlin.services.opensearch.model.EncryptionAtRestOptions.Builder.() -> kotlin.Unit) {
            this.encryptionAtRestOptions = aws.sdk.kotlin.services.opensearch.model.EncryptionAtRestOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.NodeToNodeEncryptionOptions] inside the given [block]
         */
        fun nodeToNodeEncryptionOptions(block: aws.sdk.kotlin.services.opensearch.model.NodeToNodeEncryptionOptions.Builder.() -> kotlin.Unit) {
            this.nodeToNodeEncryptionOptions = aws.sdk.kotlin.services.opensearch.model.NodeToNodeEncryptionOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.ServiceSoftwareOptions] inside the given [block]
         */
        fun serviceSoftwareOptions(block: aws.sdk.kotlin.services.opensearch.model.ServiceSoftwareOptions.Builder.() -> kotlin.Unit) {
            this.serviceSoftwareOptions = aws.sdk.kotlin.services.opensearch.model.ServiceSoftwareOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.SnapshotOptions] inside the given [block]
         */
        fun snapshotOptions(block: aws.sdk.kotlin.services.opensearch.model.SnapshotOptions.Builder.() -> kotlin.Unit) {
            this.snapshotOptions = aws.sdk.kotlin.services.opensearch.model.SnapshotOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.VpcDerivedInfo] inside the given [block]
         */
        fun vpcOptions(block: aws.sdk.kotlin.services.opensearch.model.VpcDerivedInfo.Builder.() -> kotlin.Unit) {
            this.vpcOptions = aws.sdk.kotlin.services.opensearch.model.VpcDerivedInfo.invoke(block)
        }
    }
}
