// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model



/**
 * Container for the request parameters to the ` <a>GetUpgradeHistory</a> ` operation.
 */
class GetUpgradeHistoryRequest private constructor(builder: Builder) {
    /**
     * The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
     */
    val domainName: kotlin.String? = requireNotNull(builder.domainName) { "A non-null value must be provided for domainName" }
    /**
     * Set this value to limit the number of results returned.
     */
    val maxResults: kotlin.Int = builder.maxResults
    /**
     * Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.GetUpgradeHistoryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetUpgradeHistoryRequest(")
        append("domainName=$domainName,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName?.hashCode() ?: 0
        result = 31 * result + (maxResults)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetUpgradeHistoryRequest

        if (domainName != other.domainName) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.GetUpgradeHistoryRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
         */
        var domainName: kotlin.String? = null
        /**
         * Set this value to limit the number of results returned.
         */
        var maxResults: kotlin.Int = 0
        /**
         * Paginated APIs accept the NextToken input to return the next page of results and provide a NextToken output in the response, which you can use to retrieve more results.
         */
        var nextToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.GetUpgradeHistoryRequest) : this() {
            this.domainName = x.domainName
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.GetUpgradeHistoryRequest = GetUpgradeHistoryRequest(this)
    }
}
