// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Specifies details about the scheduled Auto-Tune action. See [ Auto-Tune for Amazon OpenSearch Service ](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html) for more information.
 */
class ScheduledAutoTuneDetails private constructor(builder: Builder) {
    /**
     * The Auto-Tune action description.
     */
    val action: kotlin.String? = builder.action
    /**
     * The Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and JVM_YOUNG_GEN_TUNING.
     */
    val actionType: aws.sdk.kotlin.services.opensearch.model.ScheduledAutoTuneActionType? = builder.actionType
    /**
     * The timestamp of the Auto-Tune action scheduled for the domain.
     */
    val date: aws.smithy.kotlin.runtime.time.Instant? = builder.date
    /**
     * The Auto-Tune action severity. Valid values are LOW, MEDIUM, and HIGH.
     */
    val severity: aws.sdk.kotlin.services.opensearch.model.ScheduledAutoTuneSeverityType? = builder.severity

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.ScheduledAutoTuneDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduledAutoTuneDetails(")
        append("action=$action,")
        append("actionType=$actionType,")
        append("date=$date,")
        append("severity=$severity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (actionType?.hashCode() ?: 0)
        result = 31 * result + (date?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScheduledAutoTuneDetails

        if (action != other.action) return false
        if (actionType != other.actionType) return false
        if (date != other.date) return false
        if (severity != other.severity) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.ScheduledAutoTuneDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Auto-Tune action description.
         */
        var action: kotlin.String? = null
        /**
         * The Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and JVM_YOUNG_GEN_TUNING.
         */
        var actionType: aws.sdk.kotlin.services.opensearch.model.ScheduledAutoTuneActionType? = null
        /**
         * The timestamp of the Auto-Tune action scheduled for the domain.
         */
        var date: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Auto-Tune action severity. Valid values are LOW, MEDIUM, and HIGH.
         */
        var severity: aws.sdk.kotlin.services.opensearch.model.ScheduledAutoTuneSeverityType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.ScheduledAutoTuneDetails) : this() {
            this.action = x.action
            this.actionType = x.actionType
            this.date = x.date
            this.severity = x.severity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.ScheduledAutoTuneDetails = ScheduledAutoTuneDetails(this)
    }
}
