// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model



/**
 * Container for the parameters to the ` <a>UpdateDomain</a> ` operation. Specifies the type and number of instances in the domain cluster.
 */
class UpdateDomainConfigRequest private constructor(builder: Builder) {
    /**
     * IAM access policy as a JSON-formatted string.
     */
    val accessPolicies: kotlin.String? = builder.accessPolicies
    /**
     * Modifies the advanced option to allow references to indices in an HTTP request body. Must be `false` when configuring access to individual sub-resources. By default, the value is `true`. See [Advanced options ](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options) for more information.
     */
    val advancedOptions: Map<String, String>? = builder.advancedOptions
    /**
     * Specifies advanced security options.
     */
    val advancedSecurityOptions: aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptionsInput? = builder.advancedSecurityOptions
    /**
     * Specifies Auto-Tune options.
     */
    val autoTuneOptions: aws.sdk.kotlin.services.opensearch.model.AutoTuneOptions? = builder.autoTuneOptions
    /**
     * The type and number of instances to instantiate for the domain cluster.
     */
    val clusterConfig: aws.sdk.kotlin.services.opensearch.model.ClusterConfig? = builder.clusterConfig
    /**
     * Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see [Configuring Amazon Cognito authentication for OpenSearch Dashboards](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html).
     */
    val cognitoOptions: aws.sdk.kotlin.services.opensearch.model.CognitoOptions? = builder.cognitoOptions
    /**
     * Options to specify configuration that will be applied to the domain endpoint.
     */
    val domainEndpointOptions: aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptions? = builder.domainEndpointOptions
    /**
     * The name of the domain you're updating.
     */
    val domainName: kotlin.String? = requireNotNull(builder.domainName) { "A non-null value must be provided for domainName" }
    /**
     * This flag, when set to True, specifies whether the `UpdateDomain` request should return the results of validation checks (DryRunResults) without actually applying the change.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * Specify the type and size of the EBS volume to use.
     */
    val ebsOptions: aws.sdk.kotlin.services.opensearch.model.EbsOptions? = builder.ebsOptions
    /**
     * Specifies encryption of data at rest options.
     */
    val encryptionAtRestOptions: aws.sdk.kotlin.services.opensearch.model.EncryptionAtRestOptions? = builder.encryptionAtRestOptions
    /**
     * Map of `LogType` and `LogPublishingOption`, each containing options to publish a given type of OpenSearch log.
     */
    val logPublishingOptions: Map<String, LogPublishingOption>? = builder.logPublishingOptions
    /**
     * Specifies node-to-node encryption options.
     */
    val nodeToNodeEncryptionOptions: aws.sdk.kotlin.services.opensearch.model.NodeToNodeEncryptionOptions? = builder.nodeToNodeEncryptionOptions
    /**
     * Option to set the time, in UTC format, for the daily automated snapshot. Default value is `0` hours.
     */
    val snapshotOptions: aws.sdk.kotlin.services.opensearch.model.SnapshotOptions? = builder.snapshotOptions
    /**
     * Options to specify the subnets and security groups for the VPC endpoint. For more information, see [Launching your Amazon OpenSearch Service domains using a VPC ](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html).
     */
    val vpcOptions: aws.sdk.kotlin.services.opensearch.model.VpcOptions? = builder.vpcOptions

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.UpdateDomainConfigRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDomainConfigRequest(")
        append("accessPolicies=$accessPolicies,")
        append("advancedOptions=$advancedOptions,")
        append("advancedSecurityOptions=$advancedSecurityOptions,")
        append("autoTuneOptions=$autoTuneOptions,")
        append("clusterConfig=$clusterConfig,")
        append("cognitoOptions=$cognitoOptions,")
        append("domainEndpointOptions=$domainEndpointOptions,")
        append("domainName=$domainName,")
        append("dryRun=$dryRun,")
        append("ebsOptions=$ebsOptions,")
        append("encryptionAtRestOptions=$encryptionAtRestOptions,")
        append("logPublishingOptions=$logPublishingOptions,")
        append("nodeToNodeEncryptionOptions=$nodeToNodeEncryptionOptions,")
        append("snapshotOptions=$snapshotOptions,")
        append("vpcOptions=$vpcOptions)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPolicies?.hashCode() ?: 0
        result = 31 * result + (advancedOptions?.hashCode() ?: 0)
        result = 31 * result + (advancedSecurityOptions?.hashCode() ?: 0)
        result = 31 * result + (autoTuneOptions?.hashCode() ?: 0)
        result = 31 * result + (clusterConfig?.hashCode() ?: 0)
        result = 31 * result + (cognitoOptions?.hashCode() ?: 0)
        result = 31 * result + (domainEndpointOptions?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (ebsOptions?.hashCode() ?: 0)
        result = 31 * result + (encryptionAtRestOptions?.hashCode() ?: 0)
        result = 31 * result + (logPublishingOptions?.hashCode() ?: 0)
        result = 31 * result + (nodeToNodeEncryptionOptions?.hashCode() ?: 0)
        result = 31 * result + (snapshotOptions?.hashCode() ?: 0)
        result = 31 * result + (vpcOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateDomainConfigRequest

        if (accessPolicies != other.accessPolicies) return false
        if (advancedOptions != other.advancedOptions) return false
        if (advancedSecurityOptions != other.advancedSecurityOptions) return false
        if (autoTuneOptions != other.autoTuneOptions) return false
        if (clusterConfig != other.clusterConfig) return false
        if (cognitoOptions != other.cognitoOptions) return false
        if (domainEndpointOptions != other.domainEndpointOptions) return false
        if (domainName != other.domainName) return false
        if (dryRun != other.dryRun) return false
        if (ebsOptions != other.ebsOptions) return false
        if (encryptionAtRestOptions != other.encryptionAtRestOptions) return false
        if (logPublishingOptions != other.logPublishingOptions) return false
        if (nodeToNodeEncryptionOptions != other.nodeToNodeEncryptionOptions) return false
        if (snapshotOptions != other.snapshotOptions) return false
        if (vpcOptions != other.vpcOptions) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.UpdateDomainConfigRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * IAM access policy as a JSON-formatted string.
         */
        var accessPolicies: kotlin.String? = null
        /**
         * Modifies the advanced option to allow references to indices in an HTTP request body. Must be `false` when configuring access to individual sub-resources. By default, the value is `true`. See [Advanced options ](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options) for more information.
         */
        var advancedOptions: Map<String, String>? = null
        /**
         * Specifies advanced security options.
         */
        var advancedSecurityOptions: aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptionsInput? = null
        /**
         * Specifies Auto-Tune options.
         */
        var autoTuneOptions: aws.sdk.kotlin.services.opensearch.model.AutoTuneOptions? = null
        /**
         * The type and number of instances to instantiate for the domain cluster.
         */
        var clusterConfig: aws.sdk.kotlin.services.opensearch.model.ClusterConfig? = null
        /**
         * Options to specify the Cognito user and identity pools for OpenSearch Dashboards authentication. For more information, see [Configuring Amazon Cognito authentication for OpenSearch Dashboards](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html).
         */
        var cognitoOptions: aws.sdk.kotlin.services.opensearch.model.CognitoOptions? = null
        /**
         * Options to specify configuration that will be applied to the domain endpoint.
         */
        var domainEndpointOptions: aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptions? = null
        /**
         * The name of the domain you're updating.
         */
        var domainName: kotlin.String? = null
        /**
         * This flag, when set to True, specifies whether the `UpdateDomain` request should return the results of validation checks (DryRunResults) without actually applying the change.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * Specify the type and size of the EBS volume to use.
         */
        var ebsOptions: aws.sdk.kotlin.services.opensearch.model.EbsOptions? = null
        /**
         * Specifies encryption of data at rest options.
         */
        var encryptionAtRestOptions: aws.sdk.kotlin.services.opensearch.model.EncryptionAtRestOptions? = null
        /**
         * Map of `LogType` and `LogPublishingOption`, each containing options to publish a given type of OpenSearch log.
         */
        var logPublishingOptions: Map<String, LogPublishingOption>? = null
        /**
         * Specifies node-to-node encryption options.
         */
        var nodeToNodeEncryptionOptions: aws.sdk.kotlin.services.opensearch.model.NodeToNodeEncryptionOptions? = null
        /**
         * Option to set the time, in UTC format, for the daily automated snapshot. Default value is `0` hours.
         */
        var snapshotOptions: aws.sdk.kotlin.services.opensearch.model.SnapshotOptions? = null
        /**
         * Options to specify the subnets and security groups for the VPC endpoint. For more information, see [Launching your Amazon OpenSearch Service domains using a VPC ](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html).
         */
        var vpcOptions: aws.sdk.kotlin.services.opensearch.model.VpcOptions? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.UpdateDomainConfigRequest) : this() {
            this.accessPolicies = x.accessPolicies
            this.advancedOptions = x.advancedOptions
            this.advancedSecurityOptions = x.advancedSecurityOptions
            this.autoTuneOptions = x.autoTuneOptions
            this.clusterConfig = x.clusterConfig
            this.cognitoOptions = x.cognitoOptions
            this.domainEndpointOptions = x.domainEndpointOptions
            this.domainName = x.domainName
            this.dryRun = x.dryRun
            this.ebsOptions = x.ebsOptions
            this.encryptionAtRestOptions = x.encryptionAtRestOptions
            this.logPublishingOptions = x.logPublishingOptions
            this.nodeToNodeEncryptionOptions = x.nodeToNodeEncryptionOptions
            this.snapshotOptions = x.snapshotOptions
            this.vpcOptions = x.vpcOptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.UpdateDomainConfigRequest = UpdateDomainConfigRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptionsInput] inside the given [block]
         */
        fun advancedSecurityOptions(block: aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptionsInput.Builder.() -> kotlin.Unit) {
            this.advancedSecurityOptions = aws.sdk.kotlin.services.opensearch.model.AdvancedSecurityOptionsInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.AutoTuneOptions] inside the given [block]
         */
        fun autoTuneOptions(block: aws.sdk.kotlin.services.opensearch.model.AutoTuneOptions.Builder.() -> kotlin.Unit) {
            this.autoTuneOptions = aws.sdk.kotlin.services.opensearch.model.AutoTuneOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.ClusterConfig] inside the given [block]
         */
        fun clusterConfig(block: aws.sdk.kotlin.services.opensearch.model.ClusterConfig.Builder.() -> kotlin.Unit) {
            this.clusterConfig = aws.sdk.kotlin.services.opensearch.model.ClusterConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.CognitoOptions] inside the given [block]
         */
        fun cognitoOptions(block: aws.sdk.kotlin.services.opensearch.model.CognitoOptions.Builder.() -> kotlin.Unit) {
            this.cognitoOptions = aws.sdk.kotlin.services.opensearch.model.CognitoOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptions] inside the given [block]
         */
        fun domainEndpointOptions(block: aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptions.Builder.() -> kotlin.Unit) {
            this.domainEndpointOptions = aws.sdk.kotlin.services.opensearch.model.DomainEndpointOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.EbsOptions] inside the given [block]
         */
        fun ebsOptions(block: aws.sdk.kotlin.services.opensearch.model.EbsOptions.Builder.() -> kotlin.Unit) {
            this.ebsOptions = aws.sdk.kotlin.services.opensearch.model.EbsOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.EncryptionAtRestOptions] inside the given [block]
         */
        fun encryptionAtRestOptions(block: aws.sdk.kotlin.services.opensearch.model.EncryptionAtRestOptions.Builder.() -> kotlin.Unit) {
            this.encryptionAtRestOptions = aws.sdk.kotlin.services.opensearch.model.EncryptionAtRestOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.NodeToNodeEncryptionOptions] inside the given [block]
         */
        fun nodeToNodeEncryptionOptions(block: aws.sdk.kotlin.services.opensearch.model.NodeToNodeEncryptionOptions.Builder.() -> kotlin.Unit) {
            this.nodeToNodeEncryptionOptions = aws.sdk.kotlin.services.opensearch.model.NodeToNodeEncryptionOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.SnapshotOptions] inside the given [block]
         */
        fun snapshotOptions(block: aws.sdk.kotlin.services.opensearch.model.SnapshotOptions.Builder.() -> kotlin.Unit) {
            this.snapshotOptions = aws.sdk.kotlin.services.opensearch.model.SnapshotOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opensearch.model.VpcOptions] inside the given [block]
         */
        fun vpcOptions(block: aws.sdk.kotlin.services.opensearch.model.VpcOptions.Builder.() -> kotlin.Unit) {
            this.vpcOptions = aws.sdk.kotlin.services.opensearch.model.VpcOptions.invoke(block)
        }
    }
}
