// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model



/**
 * Container for the request parameters to ` <a>UpgradeDomain</a> ` operation.
 */
class UpgradeDomainRequest private constructor(builder: Builder) {
    /**
     * Exposes select native OpenSearch configuration values from `opensearch.yml`. Currently, the following advanced options are available:
     * + Option to allow references to indices in an HTTP request body. Must be `false` when configuring access to individual sub-resources. By default, the value is `true`. See [Advanced cluster parameters ](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options) for more information.
     * + Option to specify the percentage of heap space allocated to field data. By default, this setting is unbounded.
     *
     * For more information, see [ Advanced cluster parameters](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options).
     */
    val advancedOptions: Map<String, String>? = builder.advancedOptions
    /**
     * The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
     */
    val domainName: kotlin.String? = builder.domainName
    /**
     * When true, indicates that an upgrade eligibility check needs to be performed. Does not actually perform the upgrade.
     */
    val performCheckOnly: kotlin.Boolean? = builder.performCheckOnly
    /**
     * The version of OpenSearch you intend to upgrade the domain to.
     */
    val targetVersion: kotlin.String? = builder.targetVersion

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.UpgradeDomainRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpgradeDomainRequest(")
        append("advancedOptions=$advancedOptions,")
        append("domainName=$domainName,")
        append("performCheckOnly=$performCheckOnly,")
        append("targetVersion=$targetVersion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = advancedOptions?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (performCheckOnly?.hashCode() ?: 0)
        result = 31 * result + (targetVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpgradeDomainRequest

        if (advancedOptions != other.advancedOptions) return false
        if (domainName != other.domainName) return false
        if (performCheckOnly != other.performCheckOnly) return false
        if (targetVersion != other.targetVersion) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.UpgradeDomainRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Exposes select native OpenSearch configuration values from `opensearch.yml`. Currently, the following advanced options are available:
         * + Option to allow references to indices in an HTTP request body. Must be `false` when configuring access to individual sub-resources. By default, the value is `true`. See [Advanced cluster parameters ](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options) for more information.
         * + Option to specify the percentage of heap space allocated to field data. By default, this setting is unbounded.
         *
         * For more information, see [ Advanced cluster parameters](http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options).
         */
        var advancedOptions: Map<String, String>? = null
        /**
         * The name of an domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
         */
        var domainName: kotlin.String? = null
        /**
         * When true, indicates that an upgrade eligibility check needs to be performed. Does not actually perform the upgrade.
         */
        var performCheckOnly: kotlin.Boolean? = null
        /**
         * The version of OpenSearch you intend to upgrade the domain to.
         */
        var targetVersion: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.UpgradeDomainRequest) : this() {
            this.advancedOptions = x.advancedOptions
            this.domainName = x.domainName
            this.performCheckOnly = x.performCheckOnly
            this.targetVersion = x.targetVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.UpgradeDomainRequest = UpgradeDomainRequest(this)
    }
}
