// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * History of the last 10 upgrades and upgrade eligibility checks.
 */
class UpgradeHistory private constructor(builder: Builder) {
    /**
     * UTC timestamp at which the upgrade API call was made in "yyyy-MM-ddTHH:mm:ssZ" format.
     */
    val startTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.startTimestamp
    /**
     * A list of ` <a>UpgradeStepItem</a> ` s representing information about each step performed as part of a specific upgrade or upgrade eligibility check.
     */
    val stepsList: List<UpgradeStepItem>? = builder.stepsList
    /**
     * A string that briefly describes the upgrade.
     */
    val upgradeName: kotlin.String? = builder.upgradeName
    /**
     * The current status of the upgrade. The status can take one of the following values:
     * + In Progress
     * + Succeeded
     * + Succeeded with Issues
     * + Failed
     */
    val upgradeStatus: aws.sdk.kotlin.services.opensearch.model.UpgradeStatus? = builder.upgradeStatus

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opensearch.model.UpgradeHistory = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpgradeHistory(")
        append("startTimestamp=$startTimestamp,")
        append("stepsList=$stepsList,")
        append("upgradeName=$upgradeName,")
        append("upgradeStatus=$upgradeStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = startTimestamp?.hashCode() ?: 0
        result = 31 * result + (stepsList?.hashCode() ?: 0)
        result = 31 * result + (upgradeName?.hashCode() ?: 0)
        result = 31 * result + (upgradeStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpgradeHistory

        if (startTimestamp != other.startTimestamp) return false
        if (stepsList != other.stepsList) return false
        if (upgradeName != other.upgradeName) return false
        if (upgradeStatus != other.upgradeStatus) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opensearch.model.UpgradeHistory = Builder(this).apply(block).build()

    class Builder {
        /**
         * UTC timestamp at which the upgrade API call was made in "yyyy-MM-ddTHH:mm:ssZ" format.
         */
        var startTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of ` <a>UpgradeStepItem</a> ` s representing information about each step performed as part of a specific upgrade or upgrade eligibility check.
         */
        var stepsList: List<UpgradeStepItem>? = null
        /**
         * A string that briefly describes the upgrade.
         */
        var upgradeName: kotlin.String? = null
        /**
         * The current status of the upgrade. The status can take one of the following values:
         * + In Progress
         * + Succeeded
         * + Succeeded with Issues
         * + Failed
         */
        var upgradeStatus: aws.sdk.kotlin.services.opensearch.model.UpgradeStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opensearch.model.UpgradeHistory) : this() {
            this.startTimestamp = x.startTimestamp
            this.stepsList = x.stepsList
            this.upgradeName = x.upgradeName
            this.upgradeStatus = x.upgradeStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opensearch.model.UpgradeHistory = UpgradeHistory(this)
    }
}
