// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.opensearch.model.CreateOutboundConnectionResponse
import aws.sdk.kotlin.services.opensearch.model.DomainInformationContainer
import aws.sdk.kotlin.services.opensearch.model.OpenSearchException
import aws.sdk.kotlin.services.opensearch.model.OutboundConnectionStatus
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateOutboundConnectionOperationDeserializer: HttpDeserialize<CreateOutboundConnectionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateOutboundConnectionResponse {
        if (!response.status.isSuccess()) {
            throwCreateOutboundConnectionError(context, response)
        }
        val builder = CreateOutboundConnectionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateOutboundConnectionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateOutboundConnectionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw OpenSearchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DisabledOperationException" -> DisabledOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> OpenSearchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateOutboundConnectionOperationBody(builder: CreateOutboundConnectionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONNECTIONALIAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConnectionAlias"))
    val CONNECTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConnectionId"))
    val CONNECTIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ConnectionStatus"))
    val LOCALDOMAININFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LocalDomainInfo"))
    val REMOTEDOMAININFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RemoteDomainInfo"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONNECTIONALIAS_DESCRIPTOR)
        field(CONNECTIONID_DESCRIPTOR)
        field(CONNECTIONSTATUS_DESCRIPTOR)
        field(LOCALDOMAININFO_DESCRIPTOR)
        field(REMOTEDOMAININFO_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONNECTIONALIAS_DESCRIPTOR.index -> builder.connectionAlias = deserializeString()
                CONNECTIONID_DESCRIPTOR.index -> builder.connectionId = deserializeString()
                CONNECTIONSTATUS_DESCRIPTOR.index -> builder.connectionStatus = deserializeOutboundConnectionStatusDocument(deserializer)
                LOCALDOMAININFO_DESCRIPTOR.index -> builder.localDomainInfo = deserializeDomainInformationContainerDocument(deserializer)
                REMOTEDOMAININFO_DESCRIPTOR.index -> builder.remoteDomainInfo = deserializeDomainInformationContainerDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
