// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearch.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.opensearch.model.CompatibleVersionsMap
import aws.sdk.kotlin.services.opensearch.model.GetCompatibleVersionsResponse
import aws.sdk.kotlin.services.opensearch.model.OpenSearchException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetCompatibleVersionsOperationDeserializer: HttpDeserialize<GetCompatibleVersionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetCompatibleVersionsResponse {
        if (!response.status.isSuccess()) {
            throwGetCompatibleVersionsError(context, response)
        }
        val builder = GetCompatibleVersionsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetCompatibleVersionsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetCompatibleVersionsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw OpenSearchException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BaseException" -> BaseExceptionDeserializer().deserialize(context, wrappedResponse)
        "DisabledOperationException" -> DisabledOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> OpenSearchException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetCompatibleVersionsOperationBody(builder: GetCompatibleVersionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPATIBLEVERSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CompatibleVersions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPATIBLEVERSIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPATIBLEVERSIONS_DESCRIPTOR.index -> builder.compatibleVersions =
                    deserializer.deserializeList(COMPATIBLEVERSIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<CompatibleVersionsMap>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCompatibleVersionsMapDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
