// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearchserverless

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.opensearchserverless.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.opensearchserverless.endpoints.EndpointProvider
import aws.sdk.kotlin.services.opensearchserverless.model.*
import aws.sdk.kotlin.services.opensearchserverless.model.BatchGetCollectionRequest
import aws.sdk.kotlin.services.opensearchserverless.model.BatchGetCollectionResponse
import aws.sdk.kotlin.services.opensearchserverless.model.BatchGetVpcEndpointRequest
import aws.sdk.kotlin.services.opensearchserverless.model.BatchGetVpcEndpointResponse
import aws.sdk.kotlin.services.opensearchserverless.model.CreateAccessPolicyRequest
import aws.sdk.kotlin.services.opensearchserverless.model.CreateAccessPolicyResponse
import aws.sdk.kotlin.services.opensearchserverless.model.CreateCollectionRequest
import aws.sdk.kotlin.services.opensearchserverless.model.CreateCollectionResponse
import aws.sdk.kotlin.services.opensearchserverless.model.CreateSecurityConfigRequest
import aws.sdk.kotlin.services.opensearchserverless.model.CreateSecurityConfigResponse
import aws.sdk.kotlin.services.opensearchserverless.model.CreateSecurityPolicyRequest
import aws.sdk.kotlin.services.opensearchserverless.model.CreateSecurityPolicyResponse
import aws.sdk.kotlin.services.opensearchserverless.model.CreateVpcEndpointRequest
import aws.sdk.kotlin.services.opensearchserverless.model.CreateVpcEndpointResponse
import aws.sdk.kotlin.services.opensearchserverless.model.DeleteAccessPolicyRequest
import aws.sdk.kotlin.services.opensearchserverless.model.DeleteAccessPolicyResponse
import aws.sdk.kotlin.services.opensearchserverless.model.DeleteCollectionRequest
import aws.sdk.kotlin.services.opensearchserverless.model.DeleteCollectionResponse
import aws.sdk.kotlin.services.opensearchserverless.model.DeleteSecurityConfigRequest
import aws.sdk.kotlin.services.opensearchserverless.model.DeleteSecurityConfigResponse
import aws.sdk.kotlin.services.opensearchserverless.model.DeleteSecurityPolicyRequest
import aws.sdk.kotlin.services.opensearchserverless.model.DeleteSecurityPolicyResponse
import aws.sdk.kotlin.services.opensearchserverless.model.DeleteVpcEndpointRequest
import aws.sdk.kotlin.services.opensearchserverless.model.DeleteVpcEndpointResponse
import aws.sdk.kotlin.services.opensearchserverless.model.GetAccessPolicyRequest
import aws.sdk.kotlin.services.opensearchserverless.model.GetAccessPolicyResponse
import aws.sdk.kotlin.services.opensearchserverless.model.GetAccountSettingsRequest
import aws.sdk.kotlin.services.opensearchserverless.model.GetAccountSettingsResponse
import aws.sdk.kotlin.services.opensearchserverless.model.GetPoliciesStatsRequest
import aws.sdk.kotlin.services.opensearchserverless.model.GetPoliciesStatsResponse
import aws.sdk.kotlin.services.opensearchserverless.model.GetSecurityConfigRequest
import aws.sdk.kotlin.services.opensearchserverless.model.GetSecurityConfigResponse
import aws.sdk.kotlin.services.opensearchserverless.model.GetSecurityPolicyRequest
import aws.sdk.kotlin.services.opensearchserverless.model.GetSecurityPolicyResponse
import aws.sdk.kotlin.services.opensearchserverless.model.ListAccessPoliciesRequest
import aws.sdk.kotlin.services.opensearchserverless.model.ListAccessPoliciesResponse
import aws.sdk.kotlin.services.opensearchserverless.model.ListCollectionsRequest
import aws.sdk.kotlin.services.opensearchserverless.model.ListCollectionsResponse
import aws.sdk.kotlin.services.opensearchserverless.model.ListSecurityConfigsRequest
import aws.sdk.kotlin.services.opensearchserverless.model.ListSecurityConfigsResponse
import aws.sdk.kotlin.services.opensearchserverless.model.ListSecurityPoliciesRequest
import aws.sdk.kotlin.services.opensearchserverless.model.ListSecurityPoliciesResponse
import aws.sdk.kotlin.services.opensearchserverless.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.opensearchserverless.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.opensearchserverless.model.ListVpcEndpointsRequest
import aws.sdk.kotlin.services.opensearchserverless.model.ListVpcEndpointsResponse
import aws.sdk.kotlin.services.opensearchserverless.model.TagResourceRequest
import aws.sdk.kotlin.services.opensearchserverless.model.TagResourceResponse
import aws.sdk.kotlin.services.opensearchserverless.model.UntagResourceRequest
import aws.sdk.kotlin.services.opensearchserverless.model.UntagResourceResponse
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateAccessPolicyRequest
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateAccessPolicyResponse
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateAccountSettingsRequest
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateAccountSettingsResponse
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateCollectionRequest
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateCollectionResponse
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateSecurityConfigRequest
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateSecurityConfigResponse
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateSecurityPolicyRequest
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateSecurityPolicyResponse
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateVpcEndpointRequest
import aws.sdk.kotlin.services.opensearchserverless.model.UpdateVpcEndpointResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig

/**
 * Use the Amazon OpenSearch Serverless API to create, configure, and manage OpenSearch Serverless collections and security policies.
 *
 * OpenSearch Serverless is an on-demand, pre-provisioned serverless configuration for Amazon OpenSearch Service. OpenSearch Serverless removes the operational complexities of provisioning, configuring, and tuning your OpenSearch clusters. It enables you to easily search and analyze petabytes of data without having to worry about the underlying infrastructure and data management.
 *
 *  To learn more about OpenSearch Serverless, see [What is Amazon OpenSearch Serverless?](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-overview.html)
 */
public interface OpenSearchServerlessClient : SdkClient {

    override val serviceName: String
        get() = "OpenSearchServerless"
    /**
     * OpenSearchServerlessClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): OpenSearchServerlessClient {
            val config = Config.Builder().apply(block).build()
            return DefaultOpenSearchServerlessClient(config)
        }

        public operator fun invoke(config: Config): OpenSearchServerlessClient = DefaultOpenSearchServerlessClient(config)

        /**
         * Construct a [OpenSearchServerlessClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): OpenSearchServerlessClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultOpenSearchServerlessClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "OpenSearchServerless")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null
            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null
            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null
            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false
            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Returns attributes for one or more collections, including the collection endpoint and the OpenSearch Dashboards endpoint. For more information, see [Creating and managing Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
     */
    public suspend fun batchGetCollection(input: BatchGetCollectionRequest = BatchGetCollectionRequest {}): BatchGetCollectionResponse

    /**
     * Returns attributes for one or more VPC endpoints associated with the current account. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
     */
    public suspend fun batchGetVpcEndpoint(input: BatchGetVpcEndpointRequest): BatchGetVpcEndpointResponse

    /**
     * Creates a data access policy for OpenSearch Serverless. Access policies limit access to collections and the resources within them, and allow a user to access that data irrespective of the access mechanism or network source. For more information, see [Data access control for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
     */
    public suspend fun createAccessPolicy(input: CreateAccessPolicyRequest): CreateAccessPolicyResponse

    /**
     * Creates a new OpenSearch Serverless collection. For more information, see [Creating and managing Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
     */
    public suspend fun createCollection(input: CreateCollectionRequest): CreateCollectionResponse

    /**
     * Specifies a security configuration for OpenSearch Serverless. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
     */
    public suspend fun createSecurityConfig(input: CreateSecurityConfigRequest): CreateSecurityConfigResponse

    /**
     * Creates a security policy to be used by one or more OpenSearch Serverless collections. Security policies provide access to a collection and its OpenSearch Dashboards endpoint from public networks or specific VPC endpoints. They also allow you to secure a collection with a KMS encryption key. For more information, see [Network access for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html) and [Encryption at rest for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html).
     */
    public suspend fun createSecurityPolicy(input: CreateSecurityPolicyRequest): CreateSecurityPolicyResponse

    /**
     * Creates an OpenSearch Serverless-managed interface VPC endpoint. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
     */
    public suspend fun createVpcEndpoint(input: CreateVpcEndpointRequest): CreateVpcEndpointResponse

    /**
     * Deletes an OpenSearch Serverless access policy. For more information, see [Data access control for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
     */
    public suspend fun deleteAccessPolicy(input: DeleteAccessPolicyRequest): DeleteAccessPolicyResponse

    /**
     * Deletes an OpenSearch Serverless collection. For more information, see [Creating and managing Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
     */
    public suspend fun deleteCollection(input: DeleteCollectionRequest): DeleteCollectionResponse

    /**
     * Deletes a security configuration for OpenSearch Serverless. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
     */
    public suspend fun deleteSecurityConfig(input: DeleteSecurityConfigRequest): DeleteSecurityConfigResponse

    /**
     * Deletes an OpenSearch Serverless security policy.
     */
    public suspend fun deleteSecurityPolicy(input: DeleteSecurityPolicyRequest): DeleteSecurityPolicyResponse

    /**
     * Deletes an OpenSearch Serverless-managed interface endpoint. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
     */
    public suspend fun deleteVpcEndpoint(input: DeleteVpcEndpointRequest): DeleteVpcEndpointResponse

    /**
     * Returns an OpenSearch Serverless access policy. For more information, see [Data access control for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
     */
    public suspend fun getAccessPolicy(input: GetAccessPolicyRequest): GetAccessPolicyResponse

    /**
     * Returns account-level settings related to OpenSearch Serverless.
     */
    public suspend fun getAccountSettings(input: GetAccountSettingsRequest = GetAccountSettingsRequest {}): GetAccountSettingsResponse

    /**
     * Returns statistical information about your OpenSearch Serverless access policies, security configurations, and security policies.
     */
    public suspend fun getPoliciesStats(input: GetPoliciesStatsRequest = GetPoliciesStatsRequest {}): GetPoliciesStatsResponse

    /**
     * Returns information about an OpenSearch Serverless security configuration. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
     */
    public suspend fun getSecurityConfig(input: GetSecurityConfigRequest): GetSecurityConfigResponse

    /**
     * Returns information about a configured OpenSearch Serverless security policy. For more information, see [Network access for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html) and [Encryption at rest for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html).
     */
    public suspend fun getSecurityPolicy(input: GetSecurityPolicyRequest): GetSecurityPolicyResponse

    /**
     * Returns information about a list of OpenSearch Serverless access policies.
     */
    public suspend fun listAccessPolicies(input: ListAccessPoliciesRequest): ListAccessPoliciesResponse

    /**
     * Lists all OpenSearch Serverless collections. For more information, see [Creating and managing Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
     *
     * Make sure to include an empty request body {} if you don't include any collection filters in the request.
     */
    public suspend fun listCollections(input: ListCollectionsRequest = ListCollectionsRequest {}): ListCollectionsResponse

    /**
     * Returns information about configured OpenSearch Serverless security configurations. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
     */
    public suspend fun listSecurityConfigs(input: ListSecurityConfigsRequest): ListSecurityConfigsResponse

    /**
     * Returns information about configured OpenSearch Serverless security policies.
     */
    public suspend fun listSecurityPolicies(input: ListSecurityPoliciesRequest): ListSecurityPoliciesResponse

    /**
     * Returns the tags for an OpenSearch Serverless resource. For more information, see [Tagging Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html).
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns the OpenSearch Serverless-managed interface VPC endpoints associated with the current account. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
     */
    public suspend fun listVpcEndpoints(input: ListVpcEndpointsRequest = ListVpcEndpointsRequest {}): ListVpcEndpointsResponse

    /**
     * Associates tags with an OpenSearch Serverless resource. For more information, see [Tagging Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html).
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag or set of tags from an OpenSearch Serverless resource. For more information, see [Tagging Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html).
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an OpenSearch Serverless access policy. For more information, see [Data access control for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
     */
    public suspend fun updateAccessPolicy(input: UpdateAccessPolicyRequest): UpdateAccessPolicyResponse

    /**
     * Update the OpenSearch Serverless settings for the current Amazon Web Services account. For more information, see [Autoscaling](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-overview.html#serverless-scaling).
     */
    public suspend fun updateAccountSettings(input: UpdateAccountSettingsRequest = UpdateAccountSettingsRequest {}): UpdateAccountSettingsResponse

    /**
     * Updates an OpenSearch Serverless collection.
     */
    public suspend fun updateCollection(input: UpdateCollectionRequest): UpdateCollectionResponse

    /**
     * Updates a security configuration for OpenSearch Serverless. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
     */
    public suspend fun updateSecurityConfig(input: UpdateSecurityConfigRequest): UpdateSecurityConfigResponse

    /**
     * Updates an OpenSearch Serverless security policy. For more information, see [Network access for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html) and [Encryption at rest for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html).
     */
    public suspend fun updateSecurityPolicy(input: UpdateSecurityPolicyRequest): UpdateSecurityPolicyResponse

    /**
     * Updates an OpenSearch Serverless-managed interface endpoint. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
     */
    public suspend fun updateVpcEndpoint(input: UpdateVpcEndpointRequest): UpdateVpcEndpointResponse
}

/**
 * Returns attributes for one or more collections, including the collection endpoint and the OpenSearch Dashboards endpoint. For more information, see [Creating and managing Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
 */
public suspend inline fun OpenSearchServerlessClient.batchGetCollection(crossinline block: BatchGetCollectionRequest.Builder.() -> Unit): BatchGetCollectionResponse = batchGetCollection(BatchGetCollectionRequest.Builder().apply(block).build())

/**
 * Returns attributes for one or more VPC endpoints associated with the current account. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
 */
public suspend inline fun OpenSearchServerlessClient.batchGetVpcEndpoint(crossinline block: BatchGetVpcEndpointRequest.Builder.() -> Unit): BatchGetVpcEndpointResponse = batchGetVpcEndpoint(BatchGetVpcEndpointRequest.Builder().apply(block).build())

/**
 * Creates a data access policy for OpenSearch Serverless. Access policies limit access to collections and the resources within them, and allow a user to access that data irrespective of the access mechanism or network source. For more information, see [Data access control for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
 */
public suspend inline fun OpenSearchServerlessClient.createAccessPolicy(crossinline block: CreateAccessPolicyRequest.Builder.() -> Unit): CreateAccessPolicyResponse = createAccessPolicy(CreateAccessPolicyRequest.Builder().apply(block).build())

/**
 * Creates a new OpenSearch Serverless collection. For more information, see [Creating and managing Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
 */
public suspend inline fun OpenSearchServerlessClient.createCollection(crossinline block: CreateCollectionRequest.Builder.() -> Unit): CreateCollectionResponse = createCollection(CreateCollectionRequest.Builder().apply(block).build())

/**
 * Specifies a security configuration for OpenSearch Serverless. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
 */
public suspend inline fun OpenSearchServerlessClient.createSecurityConfig(crossinline block: CreateSecurityConfigRequest.Builder.() -> Unit): CreateSecurityConfigResponse = createSecurityConfig(CreateSecurityConfigRequest.Builder().apply(block).build())

/**
 * Creates a security policy to be used by one or more OpenSearch Serverless collections. Security policies provide access to a collection and its OpenSearch Dashboards endpoint from public networks or specific VPC endpoints. They also allow you to secure a collection with a KMS encryption key. For more information, see [Network access for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html) and [Encryption at rest for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html).
 */
public suspend inline fun OpenSearchServerlessClient.createSecurityPolicy(crossinline block: CreateSecurityPolicyRequest.Builder.() -> Unit): CreateSecurityPolicyResponse = createSecurityPolicy(CreateSecurityPolicyRequest.Builder().apply(block).build())

/**
 * Creates an OpenSearch Serverless-managed interface VPC endpoint. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
 */
public suspend inline fun OpenSearchServerlessClient.createVpcEndpoint(crossinline block: CreateVpcEndpointRequest.Builder.() -> Unit): CreateVpcEndpointResponse = createVpcEndpoint(CreateVpcEndpointRequest.Builder().apply(block).build())

/**
 * Deletes an OpenSearch Serverless access policy. For more information, see [Data access control for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
 */
public suspend inline fun OpenSearchServerlessClient.deleteAccessPolicy(crossinline block: DeleteAccessPolicyRequest.Builder.() -> Unit): DeleteAccessPolicyResponse = deleteAccessPolicy(DeleteAccessPolicyRequest.Builder().apply(block).build())

/**
 * Deletes an OpenSearch Serverless collection. For more information, see [Creating and managing Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
 */
public suspend inline fun OpenSearchServerlessClient.deleteCollection(crossinline block: DeleteCollectionRequest.Builder.() -> Unit): DeleteCollectionResponse = deleteCollection(DeleteCollectionRequest.Builder().apply(block).build())

/**
 * Deletes a security configuration for OpenSearch Serverless. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
 */
public suspend inline fun OpenSearchServerlessClient.deleteSecurityConfig(crossinline block: DeleteSecurityConfigRequest.Builder.() -> Unit): DeleteSecurityConfigResponse = deleteSecurityConfig(DeleteSecurityConfigRequest.Builder().apply(block).build())

/**
 * Deletes an OpenSearch Serverless security policy.
 */
public suspend inline fun OpenSearchServerlessClient.deleteSecurityPolicy(crossinline block: DeleteSecurityPolicyRequest.Builder.() -> Unit): DeleteSecurityPolicyResponse = deleteSecurityPolicy(DeleteSecurityPolicyRequest.Builder().apply(block).build())

/**
 * Deletes an OpenSearch Serverless-managed interface endpoint. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
 */
public suspend inline fun OpenSearchServerlessClient.deleteVpcEndpoint(crossinline block: DeleteVpcEndpointRequest.Builder.() -> Unit): DeleteVpcEndpointResponse = deleteVpcEndpoint(DeleteVpcEndpointRequest.Builder().apply(block).build())

/**
 * Returns an OpenSearch Serverless access policy. For more information, see [Data access control for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
 */
public suspend inline fun OpenSearchServerlessClient.getAccessPolicy(crossinline block: GetAccessPolicyRequest.Builder.() -> Unit): GetAccessPolicyResponse = getAccessPolicy(GetAccessPolicyRequest.Builder().apply(block).build())

/**
 * Returns account-level settings related to OpenSearch Serverless.
 */
public suspend inline fun OpenSearchServerlessClient.getAccountSettings(crossinline block: GetAccountSettingsRequest.Builder.() -> Unit): GetAccountSettingsResponse = getAccountSettings(GetAccountSettingsRequest.Builder().apply(block).build())

/**
 * Returns statistical information about your OpenSearch Serverless access policies, security configurations, and security policies.
 */
public suspend inline fun OpenSearchServerlessClient.getPoliciesStats(crossinline block: GetPoliciesStatsRequest.Builder.() -> Unit): GetPoliciesStatsResponse = getPoliciesStats(GetPoliciesStatsRequest.Builder().apply(block).build())

/**
 * Returns information about an OpenSearch Serverless security configuration. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
 */
public suspend inline fun OpenSearchServerlessClient.getSecurityConfig(crossinline block: GetSecurityConfigRequest.Builder.() -> Unit): GetSecurityConfigResponse = getSecurityConfig(GetSecurityConfigRequest.Builder().apply(block).build())

/**
 * Returns information about a configured OpenSearch Serverless security policy. For more information, see [Network access for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html) and [Encryption at rest for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html).
 */
public suspend inline fun OpenSearchServerlessClient.getSecurityPolicy(crossinline block: GetSecurityPolicyRequest.Builder.() -> Unit): GetSecurityPolicyResponse = getSecurityPolicy(GetSecurityPolicyRequest.Builder().apply(block).build())

/**
 * Returns information about a list of OpenSearch Serverless access policies.
 */
public suspend inline fun OpenSearchServerlessClient.listAccessPolicies(crossinline block: ListAccessPoliciesRequest.Builder.() -> Unit): ListAccessPoliciesResponse = listAccessPolicies(ListAccessPoliciesRequest.Builder().apply(block).build())

/**
 * Lists all OpenSearch Serverless collections. For more information, see [Creating and managing Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
 *
 * Make sure to include an empty request body {} if you don't include any collection filters in the request.
 */
public suspend inline fun OpenSearchServerlessClient.listCollections(crossinline block: ListCollectionsRequest.Builder.() -> Unit): ListCollectionsResponse = listCollections(ListCollectionsRequest.Builder().apply(block).build())

/**
 * Returns information about configured OpenSearch Serverless security configurations. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
 */
public suspend inline fun OpenSearchServerlessClient.listSecurityConfigs(crossinline block: ListSecurityConfigsRequest.Builder.() -> Unit): ListSecurityConfigsResponse = listSecurityConfigs(ListSecurityConfigsRequest.Builder().apply(block).build())

/**
 * Returns information about configured OpenSearch Serverless security policies.
 */
public suspend inline fun OpenSearchServerlessClient.listSecurityPolicies(crossinline block: ListSecurityPoliciesRequest.Builder.() -> Unit): ListSecurityPoliciesResponse = listSecurityPolicies(ListSecurityPoliciesRequest.Builder().apply(block).build())

/**
 * Returns the tags for an OpenSearch Serverless resource. For more information, see [Tagging Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html).
 */
public suspend inline fun OpenSearchServerlessClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Returns the OpenSearch Serverless-managed interface VPC endpoints associated with the current account. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
 */
public suspend inline fun OpenSearchServerlessClient.listVpcEndpoints(crossinline block: ListVpcEndpointsRequest.Builder.() -> Unit): ListVpcEndpointsResponse = listVpcEndpoints(ListVpcEndpointsRequest.Builder().apply(block).build())

/**
 * Associates tags with an OpenSearch Serverless resource. For more information, see [Tagging Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html).
 */
public suspend inline fun OpenSearchServerlessClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag or set of tags from an OpenSearch Serverless resource. For more information, see [Tagging Amazon OpenSearch Serverless collections](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html).
 */
public suspend inline fun OpenSearchServerlessClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an OpenSearch Serverless access policy. For more information, see [Data access control for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
 */
public suspend inline fun OpenSearchServerlessClient.updateAccessPolicy(crossinline block: UpdateAccessPolicyRequest.Builder.() -> Unit): UpdateAccessPolicyResponse = updateAccessPolicy(UpdateAccessPolicyRequest.Builder().apply(block).build())

/**
 * Update the OpenSearch Serverless settings for the current Amazon Web Services account. For more information, see [Autoscaling](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-overview.html#serverless-scaling).
 */
public suspend inline fun OpenSearchServerlessClient.updateAccountSettings(crossinline block: UpdateAccountSettingsRequest.Builder.() -> Unit): UpdateAccountSettingsResponse = updateAccountSettings(UpdateAccountSettingsRequest.Builder().apply(block).build())

/**
 * Updates an OpenSearch Serverless collection.
 */
public suspend inline fun OpenSearchServerlessClient.updateCollection(crossinline block: UpdateCollectionRequest.Builder.() -> Unit): UpdateCollectionResponse = updateCollection(UpdateCollectionRequest.Builder().apply(block).build())

/**
 * Updates a security configuration for OpenSearch Serverless. For more information, see [SAML authentication for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
 */
public suspend inline fun OpenSearchServerlessClient.updateSecurityConfig(crossinline block: UpdateSecurityConfigRequest.Builder.() -> Unit): UpdateSecurityConfigResponse = updateSecurityConfig(UpdateSecurityConfigRequest.Builder().apply(block).build())

/**
 * Updates an OpenSearch Serverless security policy. For more information, see [Network access for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html) and [Encryption at rest for Amazon OpenSearch Serverless](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html).
 */
public suspend inline fun OpenSearchServerlessClient.updateSecurityPolicy(crossinline block: UpdateSecurityPolicyRequest.Builder.() -> Unit): UpdateSecurityPolicyResponse = updateSecurityPolicy(UpdateSecurityPolicyRequest.Builder().apply(block).build())

/**
 * Updates an OpenSearch Serverless-managed interface endpoint. For more information, see [Access Amazon OpenSearch Serverless using an interface endpoint](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
 */
public suspend inline fun OpenSearchServerlessClient.updateVpcEndpoint(crossinline block: UpdateVpcEndpointRequest.Builder.() -> Unit): UpdateVpcEndpointResponse = updateVpcEndpoint(UpdateVpcEndpointRequest.Builder().apply(block).build())
