// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearchserverless.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.opensearchserverless.model.BatchGetVpcEndpointResponse
import aws.sdk.kotlin.services.opensearchserverless.model.OpenSearchServerlessException
import aws.sdk.kotlin.services.opensearchserverless.model.VpcEndpointDetail
import aws.sdk.kotlin.services.opensearchserverless.model.VpcEndpointErrorDetail
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchGetVpcEndpointOperationDeserializer: HttpDeserialize<BatchGetVpcEndpointResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchGetVpcEndpointResponse {
        if (!response.status.isSuccess()) {
            throwBatchGetVpcEndpointError(context, response)
        }
        val builder = BatchGetVpcEndpointResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchGetVpcEndpointOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchGetVpcEndpointError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw OpenSearchServerlessException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> OpenSearchServerlessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetVpcEndpointOperationBody(builder: BatchGetVpcEndpointResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val VPCENDPOINTDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("vpcEndpointDetails"))
    val VPCENDPOINTERRORDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("vpcEndpointErrorDetails"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(VPCENDPOINTDETAILS_DESCRIPTOR)
        field(VPCENDPOINTERRORDETAILS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                VPCENDPOINTDETAILS_DESCRIPTOR.index -> builder.vpcEndpointDetails =
                    deserializer.deserializeList(VPCENDPOINTDETAILS_DESCRIPTOR) {
                        val col0 = mutableListOf<VpcEndpointDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeVpcEndpointDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VPCENDPOINTERRORDETAILS_DESCRIPTOR.index -> builder.vpcEndpointErrorDetails =
                    deserializer.deserializeList(VPCENDPOINTERRORDETAILS_DESCRIPTOR) {
                        val col0 = mutableListOf<VpcEndpointErrorDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeVpcEndpointErrorDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
