// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opensearchserverless.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.opensearchserverless.model.CreateSecurityPolicyResponse
import aws.sdk.kotlin.services.opensearchserverless.model.OpenSearchServerlessException
import aws.sdk.kotlin.services.opensearchserverless.model.SecurityPolicyDetail
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateSecurityPolicyOperationDeserializer: HttpDeserialize<CreateSecurityPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateSecurityPolicyResponse {
        if (!response.status.isSuccess()) {
            throwCreateSecurityPolicyError(context, response)
        }
        val builder = CreateSecurityPolicyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateSecurityPolicyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateSecurityPolicyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw OpenSearchServerlessException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> OpenSearchServerlessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateSecurityPolicyOperationBody(builder: CreateSecurityPolicyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SECURITYPOLICYDETAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("securityPolicyDetail"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SECURITYPOLICYDETAIL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SECURITYPOLICYDETAIL_DESCRIPTOR.index -> builder.securityPolicyDetail = deserializeSecurityPolicyDetailDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
