// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.opsworks.model.*
import aws.sdk.kotlin.services.opsworks.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "OpsWorks"
const val ServiceApiVersion: String = "2013-02-18"
const val SdkVersion: String = "0.16.0"

internal class DefaultOpsWorksClient(override val config: OpsWorksClient.Config) : OpsWorksClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Assign a registered instance to a layer.
     * + You can assign registered on-premises instances to any layer type.
     * + You can assign registered Amazon EC2 instances only to custom layers.
     * + You cannot use this action with instances that were created with AWS OpsWorks Stacks.
     *
     * **Required Permissions**: To use this action, an AWS Identity and Access Management (IAM) user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun assignInstance(input: AssignInstanceRequest): AssignInstanceResponse {
        val op = SdkHttpOperation.build<AssignInstanceRequest, AssignInstanceResponse> {
            serializer = AssignInstanceOperationSerializer()
            deserializer = AssignInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssignInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Assigns one of the stack's registered Amazon EBS volumes to a specified instance. The volume must first be registered with the stack by calling RegisterVolume. After you register the volume, you must call UpdateVolume to specify a mount point before calling `AssignVolume`. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun assignVolume(input: AssignVolumeRequest): AssignVolumeResponse {
        val op = SdkHttpOperation.build<AssignVolumeRequest, AssignVolumeResponse> {
            serializer = AssignVolumeOperationSerializer()
            deserializer = AssignVolumeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssignVolume"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates one of the stack's registered Elastic IP addresses with a specified instance. The address must first be registered with the stack by calling RegisterElasticIp. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun associateElasticIp(input: AssociateElasticIpRequest): AssociateElasticIpResponse {
        val op = SdkHttpOperation.build<AssociateElasticIpRequest, AssociateElasticIpResponse> {
            serializer = AssociateElasticIpOperationSerializer()
            deserializer = AssociateElasticIpOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateElasticIp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attaches an Elastic Load Balancing load balancer to a specified layer. AWS OpsWorks Stacks does not support Application Load Balancer. You can only use Classic Load Balancer with AWS OpsWorks Stacks. For more information, see [Elastic Load Balancing](https://docs.aws.amazon.com/opsworks/latest/userguide/layers-elb.html).
     *
     * You must create the Elastic Load Balancing instance separately, by using the Elastic Load Balancing console, API, or CLI. For more information, see [ Elastic Load Balancing Developer Guide](https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/Welcome.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun attachElasticLoadBalancer(input: AttachElasticLoadBalancerRequest): AttachElasticLoadBalancerResponse {
        val op = SdkHttpOperation.build<AttachElasticLoadBalancerRequest, AttachElasticLoadBalancerResponse> {
            serializer = AttachElasticLoadBalancerOperationSerializer()
            deserializer = AttachElasticLoadBalancerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AttachElasticLoadBalancer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a clone of a specified stack. For more information, see [Clone a Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-cloning.html). By default, all parameters are set to the values used by the parent stack.
     *
     * **Required Permissions**: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun cloneStack(input: CloneStackRequest): CloneStackResponse {
        val op = SdkHttpOperation.build<CloneStackRequest, CloneStackResponse> {
            serializer = CloneStackOperationSerializer()
            deserializer = CloneStackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CloneStack"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an app for a specified stack. For more information, see [Creating Apps](https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun createApp(input: CreateAppRequest): CreateAppResponse {
        val op = SdkHttpOperation.build<CreateAppRequest, CreateAppResponse> {
            serializer = CreateAppOperationSerializer()
            deserializer = CreateAppOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateApp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Runs deployment or stack commands. For more information, see [Deploying Apps](https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-deploying.html) and [Run Stack Commands](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-commands.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Deploy or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun createDeployment(input: CreateDeploymentRequest): CreateDeploymentResponse {
        val op = SdkHttpOperation.build<CreateDeploymentRequest, CreateDeploymentResponse> {
            serializer = CreateDeploymentOperationSerializer()
            deserializer = CreateDeploymentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDeployment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an instance in a specified stack. For more information, see [Adding an Instance to a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun createInstance(input: CreateInstanceRequest): CreateInstanceResponse {
        val op = SdkHttpOperation.build<CreateInstanceRequest, CreateInstanceResponse> {
            serializer = CreateInstanceOperationSerializer()
            deserializer = CreateInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a layer. For more information, see [How to Create a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-create.html).
     *
     * You should use **CreateLayer** for noncustom layer types such as PHP App Server only if the stack does not have an existing layer of that type. A stack can have at most one instance of each noncustom layer; if you attempt to create a second instance, **CreateLayer** fails. A stack can have an arbitrary number of custom layers, so you can call **CreateLayer** as many times as you like for that layer type.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun createLayer(input: CreateLayerRequest): CreateLayerResponse {
        val op = SdkHttpOperation.build<CreateLayerRequest, CreateLayerResponse> {
            serializer = CreateLayerOperationSerializer()
            deserializer = CreateLayerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLayer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new stack. For more information, see [Create a New Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-edit.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun createStack(input: CreateStackRequest): CreateStackResponse {
        val op = SdkHttpOperation.build<CreateStackRequest, CreateStackResponse> {
            serializer = CreateStackOperationSerializer()
            deserializer = CreateStackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateStack"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new user profile.
     *
     * **Required Permissions**: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun createUserProfile(input: CreateUserProfileRequest): CreateUserProfileResponse {
        val op = SdkHttpOperation.build<CreateUserProfileRequest, CreateUserProfileResponse> {
            serializer = CreateUserProfileOperationSerializer()
            deserializer = CreateUserProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateUserProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a specified app.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun deleteApp(input: DeleteAppRequest): DeleteAppResponse {
        val op = SdkHttpOperation.build<DeleteAppRequest, DeleteAppResponse> {
            serializer = DeleteAppOperationSerializer()
            deserializer = DeleteAppOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a specified instance, which terminates the associated Amazon EC2 instance. You must stop an instance before you can delete it.
     *
     * For more information, see [Deleting Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-delete.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun deleteInstance(input: DeleteInstanceRequest): DeleteInstanceResponse {
        val op = SdkHttpOperation.build<DeleteInstanceRequest, DeleteInstanceResponse> {
            serializer = DeleteInstanceOperationSerializer()
            deserializer = DeleteInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a specified layer. You must first stop and then delete all associated instances or unassign registered instances. For more information, see [How to Delete a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-delete.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun deleteLayer(input: DeleteLayerRequest): DeleteLayerResponse {
        val op = SdkHttpOperation.build<DeleteLayerRequest, DeleteLayerResponse> {
            serializer = DeleteLayerOperationSerializer()
            deserializer = DeleteLayerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteLayer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a specified stack. You must first delete all instances, layers, and apps or deregister registered instances. For more information, see [Shut Down a Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-shutting.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun deleteStack(input: DeleteStackRequest): DeleteStackResponse {
        val op = SdkHttpOperation.build<DeleteStackRequest, DeleteStackResponse> {
            serializer = DeleteStackOperationSerializer()
            deserializer = DeleteStackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteStack"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a user profile.
     *
     * **Required Permissions**: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun deleteUserProfile(input: DeleteUserProfileRequest): DeleteUserProfileResponse {
        val op = SdkHttpOperation.build<DeleteUserProfileRequest, DeleteUserProfileResponse> {
            serializer = DeleteUserProfileOperationSerializer()
            deserializer = DeleteUserProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteUserProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deregisters a specified Amazon ECS cluster from a stack. For more information, see [ Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-ecscluster.html#workinglayers-ecscluster-delete).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see [https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun deregisterEcsCluster(input: DeregisterEcsClusterRequest): DeregisterEcsClusterResponse {
        val op = SdkHttpOperation.build<DeregisterEcsClusterRequest, DeregisterEcsClusterResponse> {
            serializer = DeregisterEcsClusterOperationSerializer()
            deserializer = DeregisterEcsClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterEcsCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deregisters a specified Elastic IP address. The address can then be registered by another stack. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun deregisterElasticIp(input: DeregisterElasticIpRequest): DeregisterElasticIpResponse {
        val op = SdkHttpOperation.build<DeregisterElasticIpRequest, DeregisterElasticIpResponse> {
            serializer = DeregisterElasticIpOperationSerializer()
            deserializer = DeregisterElasticIpOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterElasticIp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deregister a registered Amazon EC2 or on-premises instance. This action removes the instance from the stack and returns it to your control. This action cannot be used with instances that were created with AWS OpsWorks Stacks.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun deregisterInstance(input: DeregisterInstanceRequest): DeregisterInstanceResponse {
        val op = SdkHttpOperation.build<DeregisterInstanceRequest, DeregisterInstanceResponse> {
            serializer = DeregisterInstanceOperationSerializer()
            deserializer = DeregisterInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deregisters an Amazon RDS instance.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun deregisterRdsDbInstance(input: DeregisterRdsDbInstanceRequest): DeregisterRdsDbInstanceResponse {
        val op = SdkHttpOperation.build<DeregisterRdsDbInstanceRequest, DeregisterRdsDbInstanceResponse> {
            serializer = DeregisterRdsDbInstanceOperationSerializer()
            deserializer = DeregisterRdsDbInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterRdsDbInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deregisters an Amazon EBS volume. The volume can then be registered by another stack. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun deregisterVolume(input: DeregisterVolumeRequest): DeregisterVolumeResponse {
        val op = SdkHttpOperation.build<DeregisterVolumeRequest, DeregisterVolumeResponse> {
            serializer = DeregisterVolumeOperationSerializer()
            deserializer = DeregisterVolumeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterVolume"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the available AWS OpsWorks Stacks agent versions. You must specify a stack ID or a configuration manager. `DescribeAgentVersions` returns a list of available agent versions for the specified stack or configuration manager.
     */
    override suspend fun describeAgentVersions(input: DescribeAgentVersionsRequest): DescribeAgentVersionsResponse {
        val op = SdkHttpOperation.build<DescribeAgentVersionsRequest, DescribeAgentVersionsResponse> {
            serializer = DescribeAgentVersionsOperationSerializer()
            deserializer = DescribeAgentVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAgentVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Requests a description of a specified set of apps.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun describeApps(input: DescribeAppsRequest): DescribeAppsResponse {
        val op = SdkHttpOperation.build<DescribeAppsRequest, DescribeAppsResponse> {
            serializer = DescribeAppsOperationSerializer()
            deserializer = DescribeAppsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeApps"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the results of specified commands.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun describeCommands(input: DescribeCommandsRequest): DescribeCommandsResponse {
        val op = SdkHttpOperation.build<DescribeCommandsRequest, DescribeCommandsResponse> {
            serializer = DescribeCommandsOperationSerializer()
            deserializer = DescribeCommandsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCommands"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Requests a description of a specified set of deployments.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun describeDeployments(input: DescribeDeploymentsRequest): DescribeDeploymentsResponse {
        val op = SdkHttpOperation.build<DescribeDeploymentsRequest, DescribeDeploymentsResponse> {
            serializer = DescribeDeploymentsOperationSerializer()
            deserializer = DescribeDeploymentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDeployments"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes Amazon ECS clusters that are registered with a stack. If you specify only a stack ID, you can use the `MaxResults` and `NextToken` parameters to paginate the response. However, AWS OpsWorks Stacks currently supports only one cluster per layer, so the result set has a maximum of one element.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack or an attached policy that explicitly grants permission. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     *
     * This call accepts only one resource-identifying parameter.
     */
    override suspend fun describeEcsClusters(input: DescribeEcsClustersRequest): DescribeEcsClustersResponse {
        val op = SdkHttpOperation.build<DescribeEcsClustersRequest, DescribeEcsClustersResponse> {
            serializer = DescribeEcsClustersOperationSerializer()
            deserializer = DescribeEcsClustersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEcsClusters"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes [Elastic IP addresses](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html).
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun describeElasticIps(input: DescribeElasticIpsRequest): DescribeElasticIpsResponse {
        val op = SdkHttpOperation.build<DescribeElasticIpsRequest, DescribeElasticIpsResponse> {
            serializer = DescribeElasticIpsOperationSerializer()
            deserializer = DescribeElasticIpsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeElasticIps"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a stack's Elastic Load Balancing instances.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun describeElasticLoadBalancers(input: DescribeElasticLoadBalancersRequest): DescribeElasticLoadBalancersResponse {
        val op = SdkHttpOperation.build<DescribeElasticLoadBalancersRequest, DescribeElasticLoadBalancersResponse> {
            serializer = DescribeElasticLoadBalancersOperationSerializer()
            deserializer = DescribeElasticLoadBalancersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeElasticLoadBalancers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Requests a description of a set of instances.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun describeInstances(input: DescribeInstancesRequest): DescribeInstancesResponse {
        val op = SdkHttpOperation.build<DescribeInstancesRequest, DescribeInstancesResponse> {
            serializer = DescribeInstancesOperationSerializer()
            deserializer = DescribeInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Requests a description of one or more layers in a specified stack.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun describeLayers(input: DescribeLayersRequest): DescribeLayersResponse {
        val op = SdkHttpOperation.build<DescribeLayersRequest, DescribeLayersResponse> {
            serializer = DescribeLayersOperationSerializer()
            deserializer = DescribeLayersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLayers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes load-based auto scaling configurations for specified layers.
     *
     * You must specify at least one of the parameters.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun describeLoadBasedAutoScaling(input: DescribeLoadBasedAutoScalingRequest): DescribeLoadBasedAutoScalingResponse {
        val op = SdkHttpOperation.build<DescribeLoadBasedAutoScalingRequest, DescribeLoadBasedAutoScalingResponse> {
            serializer = DescribeLoadBasedAutoScalingOperationSerializer()
            deserializer = DescribeLoadBasedAutoScalingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLoadBasedAutoScaling"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a user's SSH information.
     *
     * **Required Permissions**: To use this action, an IAM user must have self-management enabled or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun describeMyUserProfile(input: DescribeMyUserProfileRequest): DescribeMyUserProfileResponse {
        val op = SdkHttpOperation.build<DescribeMyUserProfileRequest, DescribeMyUserProfileResponse> {
            serializer = DescribeMyUserProfileOperationSerializer()
            deserializer = DescribeMyUserProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeMyUserProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the operating systems that are supported by AWS OpsWorks Stacks.
     */
    override suspend fun describeOperatingSystems(input: DescribeOperatingSystemsRequest): DescribeOperatingSystemsResponse {
        val op = SdkHttpOperation.build<DescribeOperatingSystemsRequest, DescribeOperatingSystemsResponse> {
            serializer = DescribeOperatingSystemsOperationSerializer()
            deserializer = DescribeOperatingSystemsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeOperatingSystems"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the permissions for a specified stack.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun describePermissions(input: DescribePermissionsRequest): DescribePermissionsResponse {
        val op = SdkHttpOperation.build<DescribePermissionsRequest, DescribePermissionsResponse> {
            serializer = DescribePermissionsOperationSerializer()
            deserializer = DescribePermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describe an instance's RAID arrays.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun describeRaidArrays(input: DescribeRaidArraysRequest): DescribeRaidArraysResponse {
        val op = SdkHttpOperation.build<DescribeRaidArraysRequest, DescribeRaidArraysResponse> {
            serializer = DescribeRaidArraysOperationSerializer()
            deserializer = DescribeRaidArraysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRaidArrays"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes Amazon RDS instances.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     *
     * This call accepts only one resource-identifying parameter.
     */
    override suspend fun describeRdsDbInstances(input: DescribeRdsDbInstancesRequest): DescribeRdsDbInstancesResponse {
        val op = SdkHttpOperation.build<DescribeRdsDbInstancesRequest, DescribeRdsDbInstancesResponse> {
            serializer = DescribeRdsDbInstancesOperationSerializer()
            deserializer = DescribeRdsDbInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRdsDbInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes AWS OpsWorks Stacks service errors.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     *
     * This call accepts only one resource-identifying parameter.
     */
    override suspend fun describeServiceErrors(input: DescribeServiceErrorsRequest): DescribeServiceErrorsResponse {
        val op = SdkHttpOperation.build<DescribeServiceErrorsRequest, DescribeServiceErrorsResponse> {
            serializer = DescribeServiceErrorsOperationSerializer()
            deserializer = DescribeServiceErrorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeServiceErrors"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Requests a description of a stack's provisioning parameters.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun describeStackProvisioningParameters(input: DescribeStackProvisioningParametersRequest): DescribeStackProvisioningParametersResponse {
        val op = SdkHttpOperation.build<DescribeStackProvisioningParametersRequest, DescribeStackProvisioningParametersResponse> {
            serializer = DescribeStackProvisioningParametersOperationSerializer()
            deserializer = DescribeStackProvisioningParametersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStackProvisioningParameters"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the number of layers and apps in a specified stack, and the number of instances in each state, such as `running_setup` or `online`.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun describeStackSummary(input: DescribeStackSummaryRequest): DescribeStackSummaryResponse {
        val op = SdkHttpOperation.build<DescribeStackSummaryRequest, DescribeStackSummaryResponse> {
            serializer = DescribeStackSummaryOperationSerializer()
            deserializer = DescribeStackSummaryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStackSummary"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Requests a description of one or more stacks.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun describeStacks(input: DescribeStacksRequest): DescribeStacksResponse {
        val op = SdkHttpOperation.build<DescribeStacksRequest, DescribeStacksResponse> {
            serializer = DescribeStacksOperationSerializer()
            deserializer = DescribeStacksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStacks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes time-based auto scaling configurations for specified instances.
     *
     * You must specify at least one of the parameters.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun describeTimeBasedAutoScaling(input: DescribeTimeBasedAutoScalingRequest): DescribeTimeBasedAutoScalingResponse {
        val op = SdkHttpOperation.build<DescribeTimeBasedAutoScalingRequest, DescribeTimeBasedAutoScalingResponse> {
            serializer = DescribeTimeBasedAutoScalingOperationSerializer()
            deserializer = DescribeTimeBasedAutoScalingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTimeBasedAutoScaling"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describe specified users.
     *
     * **Required Permissions**: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun describeUserProfiles(input: DescribeUserProfilesRequest): DescribeUserProfilesResponse {
        val op = SdkHttpOperation.build<DescribeUserProfilesRequest, DescribeUserProfilesResponse> {
            serializer = DescribeUserProfilesOperationSerializer()
            deserializer = DescribeUserProfilesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeUserProfiles"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes an instance's Amazon EBS volumes.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun describeVolumes(input: DescribeVolumesRequest): DescribeVolumesResponse {
        val op = SdkHttpOperation.build<DescribeVolumesRequest, DescribeVolumesResponse> {
            serializer = DescribeVolumesOperationSerializer()
            deserializer = DescribeVolumesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeVolumes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Detaches a specified Elastic Load Balancing instance from its layer.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun detachElasticLoadBalancer(input: DetachElasticLoadBalancerRequest): DetachElasticLoadBalancerResponse {
        val op = SdkHttpOperation.build<DetachElasticLoadBalancerRequest, DetachElasticLoadBalancerResponse> {
            serializer = DetachElasticLoadBalancerOperationSerializer()
            deserializer = DetachElasticLoadBalancerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetachElasticLoadBalancer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates an Elastic IP address from its instance. The address remains registered with the stack. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun disassociateElasticIp(input: DisassociateElasticIpRequest): DisassociateElasticIpResponse {
        val op = SdkHttpOperation.build<DisassociateElasticIpRequest, DisassociateElasticIpResponse> {
            serializer = DisassociateElasticIpOperationSerializer()
            deserializer = DisassociateElasticIpOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateElasticIp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a generated host name for the specified layer, based on the current host name theme.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun getHostnameSuggestion(input: GetHostnameSuggestionRequest): GetHostnameSuggestionResponse {
        val op = SdkHttpOperation.build<GetHostnameSuggestionRequest, GetHostnameSuggestionResponse> {
            serializer = GetHostnameSuggestionOperationSerializer()
            deserializer = GetHostnameSuggestionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetHostnameSuggestion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This action can be used only with Windows stacks.
     *
     * Grants RDP access to a Windows instance for a specified time period.
     */
    override suspend fun grantAccess(input: GrantAccessRequest): GrantAccessResponse {
        val op = SdkHttpOperation.build<GrantAccessRequest, GrantAccessResponse> {
            serializer = GrantAccessOperationSerializer()
            deserializer = GrantAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GrantAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of tags that are applied to the specified stack or layer.
     */
    override suspend fun listTags(input: ListTagsRequest): ListTagsResponse {
        val op = SdkHttpOperation.build<ListTagsRequest, ListTagsResponse> {
            serializer = ListTagsOperationSerializer()
            deserializer = ListTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Reboots a specified instance. For more information, see [Starting, Stopping, and Rebooting Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun rebootInstance(input: RebootInstanceRequest): RebootInstanceResponse {
        val op = SdkHttpOperation.build<RebootInstanceRequest, RebootInstanceResponse> {
            serializer = RebootInstanceOperationSerializer()
            deserializer = RebootInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RebootInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Registers a specified Amazon ECS cluster with a stack. You can register only one cluster with a stack. A cluster can be registered with only one stack. For more information, see [ Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-ecscluster.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see [ Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun registerEcsCluster(input: RegisterEcsClusterRequest): RegisterEcsClusterResponse {
        val op = SdkHttpOperation.build<RegisterEcsClusterRequest, RegisterEcsClusterResponse> {
            serializer = RegisterEcsClusterOperationSerializer()
            deserializer = RegisterEcsClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterEcsCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Registers an Elastic IP address with a specified stack. An address can be registered with only one stack at a time. If the address is already registered, you must first deregister it by calling DeregisterElasticIp. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun registerElasticIp(input: RegisterElasticIpRequest): RegisterElasticIpResponse {
        val op = SdkHttpOperation.build<RegisterElasticIpRequest, RegisterElasticIpResponse> {
            serializer = RegisterElasticIpOperationSerializer()
            deserializer = RegisterElasticIpOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterElasticIp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Registers instances that were created outside of AWS OpsWorks Stacks with a specified stack.
     *
     * We do not recommend using this action to register instances. The complete registration operation includes two tasks: installing the AWS OpsWorks Stacks agent on the instance, and registering the instance with the stack. `RegisterInstance` handles only the second step. You should instead use the AWS CLI `register` command, which performs the entire registration operation. For more information, see [ Registering an Instance with an AWS OpsWorks Stacks Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/registered-instances-register.html).
     *
     * Registered instances have the same requirements as instances that are created by using the CreateInstance API. For example, registered instances must be running a supported Linux-based operating system, and they must have a supported instance type. For more information about requirements for instances that you want to register, see [ Preparing the Instance](https://docs.aws.amazon.com/opsworks/latest/userguide/registered-instances-register-registering-preparer.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun registerInstance(input: RegisterInstanceRequest): RegisterInstanceResponse {
        val op = SdkHttpOperation.build<RegisterInstanceRequest, RegisterInstanceResponse> {
            serializer = RegisterInstanceOperationSerializer()
            deserializer = RegisterInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Registers an Amazon RDS instance with a stack.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun registerRdsDbInstance(input: RegisterRdsDbInstanceRequest): RegisterRdsDbInstanceResponse {
        val op = SdkHttpOperation.build<RegisterRdsDbInstanceRequest, RegisterRdsDbInstanceResponse> {
            serializer = RegisterRdsDbInstanceOperationSerializer()
            deserializer = RegisterRdsDbInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterRdsDbInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Registers an Amazon EBS volume with a specified stack. A volume can be registered with only one stack at a time. If the volume is already registered, you must first deregister it by calling DeregisterVolume. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun registerVolume(input: RegisterVolumeRequest): RegisterVolumeResponse {
        val op = SdkHttpOperation.build<RegisterVolumeRequest, RegisterVolumeResponse> {
            serializer = RegisterVolumeOperationSerializer()
            deserializer = RegisterVolumeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterVolume"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Specify the load-based auto scaling configuration for a specified layer. For more information, see [Managing Load with Time-based and Load-based Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-autoscaling.html).
     *
     * To use load-based auto scaling, you must create a set of load-based auto scaling instances. Load-based auto scaling operates only on the instances from that set, so you must ensure that you have created enough instances to handle the maximum anticipated load.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun setLoadBasedAutoScaling(input: SetLoadBasedAutoScalingRequest): SetLoadBasedAutoScalingResponse {
        val op = SdkHttpOperation.build<SetLoadBasedAutoScalingRequest, SetLoadBasedAutoScalingResponse> {
            serializer = SetLoadBasedAutoScalingOperationSerializer()
            deserializer = SetLoadBasedAutoScalingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetLoadBasedAutoScaling"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Specifies a user's permissions. For more information, see [Security and Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/workingsecurity.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun setPermission(input: SetPermissionRequest): SetPermissionResponse {
        val op = SdkHttpOperation.build<SetPermissionRequest, SetPermissionResponse> {
            serializer = SetPermissionOperationSerializer()
            deserializer = SetPermissionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetPermission"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Specify the time-based auto scaling configuration for a specified instance. For more information, see [Managing Load with Time-based and Load-based Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-autoscaling.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun setTimeBasedAutoScaling(input: SetTimeBasedAutoScalingRequest): SetTimeBasedAutoScalingResponse {
        val op = SdkHttpOperation.build<SetTimeBasedAutoScalingRequest, SetTimeBasedAutoScalingResponse> {
            serializer = SetTimeBasedAutoScalingOperationSerializer()
            deserializer = SetTimeBasedAutoScalingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetTimeBasedAutoScaling"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a specified instance. For more information, see [Starting, Stopping, and Rebooting Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun startInstance(input: StartInstanceRequest): StartInstanceResponse {
        val op = SdkHttpOperation.build<StartInstanceRequest, StartInstanceResponse> {
            serializer = StartInstanceOperationSerializer()
            deserializer = StartInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a stack's instances.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun startStack(input: StartStackRequest): StartStackResponse {
        val op = SdkHttpOperation.build<StartStackRequest, StartStackResponse> {
            serializer = StartStackOperationSerializer()
            deserializer = StartStackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartStack"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a specified instance. When you stop a standard instance, the data disappears and must be reinstalled when you restart the instance. You can stop an Amazon EBS-backed instance without losing data. For more information, see [Starting, Stopping, and Rebooting Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun stopInstance(input: StopInstanceRequest): StopInstanceResponse {
        val op = SdkHttpOperation.build<StopInstanceRequest, StopInstanceResponse> {
            serializer = StopInstanceOperationSerializer()
            deserializer = StopInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a specified stack.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun stopStack(input: StopStackRequest): StopStackResponse {
        val op = SdkHttpOperation.build<StopStackRequest, StopStackResponse> {
            serializer = StopStackOperationSerializer()
            deserializer = StopStackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopStack"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Apply cost-allocation tags to a specified stack or layer in AWS OpsWorks Stacks. For more information about how tagging works, see [Tags](https://docs.aws.amazon.com/opsworks/latest/userguide/tagging.html) in the AWS OpsWorks User Guide.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Unassigns a registered instance from all layers that are using the instance. The instance remains in the stack as an unassigned instance, and can be assigned to another layer as needed. You cannot use this action with instances that were created with AWS OpsWorks Stacks.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun unassignInstance(input: UnassignInstanceRequest): UnassignInstanceResponse {
        val op = SdkHttpOperation.build<UnassignInstanceRequest, UnassignInstanceResponse> {
            serializer = UnassignInstanceOperationSerializer()
            deserializer = UnassignInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UnassignInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Unassigns an assigned Amazon EBS volume. The volume remains registered with the stack. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun unassignVolume(input: UnassignVolumeRequest): UnassignVolumeResponse {
        val op = SdkHttpOperation.build<UnassignVolumeRequest, UnassignVolumeResponse> {
            serializer = UnassignVolumeOperationSerializer()
            deserializer = UnassignVolumeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UnassignVolume"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes tags from a specified stack or layer.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a specified app.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Deploy or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun updateApp(input: UpdateAppRequest): UpdateAppResponse {
        val op = SdkHttpOperation.build<UpdateAppRequest, UpdateAppResponse> {
            serializer = UpdateAppOperationSerializer()
            deserializer = UpdateAppOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a registered Elastic IP address's name. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun updateElasticIp(input: UpdateElasticIpRequest): UpdateElasticIpResponse {
        val op = SdkHttpOperation.build<UpdateElasticIpRequest, UpdateElasticIpResponse> {
            serializer = UpdateElasticIpOperationSerializer()
            deserializer = UpdateElasticIpOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateElasticIp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a specified instance.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun updateInstance(input: UpdateInstanceRequest): UpdateInstanceResponse {
        val op = SdkHttpOperation.build<UpdateInstanceRequest, UpdateInstanceResponse> {
            serializer = UpdateInstanceOperationSerializer()
            deserializer = UpdateInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a specified layer.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun updateLayer(input: UpdateLayerRequest): UpdateLayerResponse {
        val op = SdkHttpOperation.build<UpdateLayerRequest, UpdateLayerResponse> {
            serializer = UpdateLayerOperationSerializer()
            deserializer = UpdateLayerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateLayer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a user's SSH public key.
     *
     * **Required Permissions**: To use this action, an IAM user must have self-management enabled or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun updateMyUserProfile(input: UpdateMyUserProfileRequest): UpdateMyUserProfileResponse {
        val op = SdkHttpOperation.build<UpdateMyUserProfileRequest, UpdateMyUserProfileResponse> {
            serializer = UpdateMyUserProfileOperationSerializer()
            deserializer = UpdateMyUserProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateMyUserProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an Amazon RDS instance.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun updateRdsDbInstance(input: UpdateRdsDbInstanceRequest): UpdateRdsDbInstanceResponse {
        val op = SdkHttpOperation.build<UpdateRdsDbInstanceRequest, UpdateRdsDbInstanceResponse> {
            serializer = UpdateRdsDbInstanceOperationSerializer()
            deserializer = UpdateRdsDbInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRdsDbInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a specified stack.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun updateStack(input: UpdateStackRequest): UpdateStackResponse {
        val op = SdkHttpOperation.build<UpdateStackRequest, UpdateStackResponse> {
            serializer = UpdateStackOperationSerializer()
            deserializer = UpdateStackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateStack"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a specified user profile.
     *
     * **Required Permissions**: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun updateUserProfile(input: UpdateUserProfileRequest): UpdateUserProfileResponse {
        val op = SdkHttpOperation.build<UpdateUserProfileRequest, UpdateUserProfileResponse> {
            serializer = UpdateUserProfileOperationSerializer()
            deserializer = UpdateUserProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateUserProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an Amazon EBS volume's name or mount point. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    override suspend fun updateVolume(input: UpdateVolumeRequest): UpdateVolumeResponse {
        val op = SdkHttpOperation.build<UpdateVolumeRequest, UpdateVolumeResponse> {
            serializer = UpdateVolumeOperationSerializer()
            deserializer = UpdateVolumeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateVolume"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("OpsWorks_20130218", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "opsworks"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "opsworks")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
