// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.opsworks.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.opsworks.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.crt.CrtAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # AWS OpsWorks
 * Welcome to the *AWS OpsWorks Stacks API Reference*. This guide provides descriptions, syntax, and usage examples for AWS OpsWorks Stacks actions and data types, including common parameters and error codes.
 *
 * AWS OpsWorks Stacks is an application management service that provides an integrated experience for overseeing the complete application lifecycle. For information about this product, go to the [AWS OpsWorks](http://aws.amazon.com/opsworks/) details page.
 *
 * **SDKs and CLI**
 *
 * The most common way to use the AWS OpsWorks Stacks API is by using the AWS Command Line Interface (CLI) or by using one of the AWS SDKs to implement applications in your preferred language. For more information, see:
 * + [AWS CLI](https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-welcome.html)
 * + [AWS SDK for Java](https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/opsworks/AWSOpsWorksClient.html)
 * + [AWS SDK for .NET](https://docs.aws.amazon.com/sdkfornet/latest/apidocs/html/N_Amazon_OpsWorks.htm)
 * + [AWS SDK for PHP 2](https://docs.aws.amazon.com/aws-sdk-php-2/latest/class-Aws.OpsWorks.OpsWorksClient.html)
 * + [AWS SDK for Ruby](http://docs.aws.amazon.com/sdkforruby/api/)
 * + [AWS SDK for Node.js](http://aws.amazon.com/documentation/sdkforjavascript/)
 * + [AWS SDK for Python(Boto)](http://docs.pythonboto.org/en/latest/ref/opsworks.html)
 *
 * **Endpoints**
 *
 * AWS OpsWorks Stacks supports the following endpoints, all HTTPS. You must connect to one of the following endpoints. Stacks can only be accessed or managed within the endpoint in which they are created.
 * + opsworks.us-east-1.amazonaws.com
 * + opsworks.us-east-2.amazonaws.com
 * + opsworks.us-west-1.amazonaws.com
 * + opsworks.us-west-2.amazonaws.com
 * + opsworks.ca-central-1.amazonaws.com (API only; not available in the AWS console)
 * + opsworks.eu-west-1.amazonaws.com
 * + opsworks.eu-west-2.amazonaws.com
 * + opsworks.eu-west-3.amazonaws.com
 * + opsworks.eu-central-1.amazonaws.com
 * + opsworks.ap-northeast-1.amazonaws.com
 * + opsworks.ap-northeast-2.amazonaws.com
 * + opsworks.ap-south-1.amazonaws.com
 * + opsworks.ap-southeast-1.amazonaws.com
 * + opsworks.ap-southeast-2.amazonaws.com
 * + opsworks.sa-east-1.amazonaws.com
 *
 * **Chef Versions**
 *
 * When you call CreateStack, CloneStack, or UpdateStack we recommend you use the `ConfigurationManager` parameter to specify the Chef version. The recommended and default value for Linux stacks is currently 12. Windows stacks use Chef 12.2. For more information, see [Chef Versions](https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-chef11.html).
 *
 * You can specify Chef 12, 11.10, or 11.4 for your Linux stack. We recommend migrating your existing Linux stacks to Chef 12 as soon as possible.
 */
interface OpsWorksClient : SdkClient {

    override val serviceName: String
        get() = "OpsWorks"
    /**
     * OpsWorksClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): OpsWorksClient {
            val config = Config.Builder().apply(block).build()
            return DefaultOpsWorksClient(config)
        }

        operator fun invoke(config: Config): OpsWorksClient = DefaultOpsWorksClient(config)

        /**
         * Construct a [OpsWorksClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): OpsWorksClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultOpsWorksClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: CrtAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Assign a registered instance to a layer.
     * + You can assign registered on-premises instances to any layer type.
     * + You can assign registered Amazon EC2 instances only to custom layers.
     * + You cannot use this action with instances that were created with AWS OpsWorks Stacks.
     *
     * **Required Permissions**: To use this action, an AWS Identity and Access Management (IAM) user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun assignInstance(input: AssignInstanceRequest): AssignInstanceResponse

    /**
     * Assign a registered instance to a layer.
     * + You can assign registered on-premises instances to any layer type.
     * + You can assign registered Amazon EC2 instances only to custom layers.
     * + You cannot use this action with instances that were created with AWS OpsWorks Stacks.
     *
     * **Required Permissions**: To use this action, an AWS Identity and Access Management (IAM) user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun assignInstance(block: AssignInstanceRequest.Builder.() -> Unit) = assignInstance(AssignInstanceRequest.Builder().apply(block).build())

    /**
     * Assigns one of the stack's registered Amazon EBS volumes to a specified instance. The volume must first be registered with the stack by calling RegisterVolume. After you register the volume, you must call UpdateVolume to specify a mount point before calling `AssignVolume`. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun assignVolume(input: AssignVolumeRequest): AssignVolumeResponse

    /**
     * Assigns one of the stack's registered Amazon EBS volumes to a specified instance. The volume must first be registered with the stack by calling RegisterVolume. After you register the volume, you must call UpdateVolume to specify a mount point before calling `AssignVolume`. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun assignVolume(block: AssignVolumeRequest.Builder.() -> Unit) = assignVolume(AssignVolumeRequest.Builder().apply(block).build())

    /**
     * Associates one of the stack's registered Elastic IP addresses with a specified instance. The address must first be registered with the stack by calling RegisterElasticIp. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun associateElasticIp(input: AssociateElasticIpRequest): AssociateElasticIpResponse

    /**
     * Associates one of the stack's registered Elastic IP addresses with a specified instance. The address must first be registered with the stack by calling RegisterElasticIp. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun associateElasticIp(block: AssociateElasticIpRequest.Builder.() -> Unit) = associateElasticIp(AssociateElasticIpRequest.Builder().apply(block).build())

    /**
     * Attaches an Elastic Load Balancing load balancer to a specified layer. AWS OpsWorks Stacks does not support Application Load Balancer. You can only use Classic Load Balancer with AWS OpsWorks Stacks. For more information, see [Elastic Load Balancing](https://docs.aws.amazon.com/opsworks/latest/userguide/layers-elb.html).
     *
     * You must create the Elastic Load Balancing instance separately, by using the Elastic Load Balancing console, API, or CLI. For more information, see [ Elastic Load Balancing Developer Guide](https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/Welcome.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun attachElasticLoadBalancer(input: AttachElasticLoadBalancerRequest): AttachElasticLoadBalancerResponse

    /**
     * Attaches an Elastic Load Balancing load balancer to a specified layer. AWS OpsWorks Stacks does not support Application Load Balancer. You can only use Classic Load Balancer with AWS OpsWorks Stacks. For more information, see [Elastic Load Balancing](https://docs.aws.amazon.com/opsworks/latest/userguide/layers-elb.html).
     *
     * You must create the Elastic Load Balancing instance separately, by using the Elastic Load Balancing console, API, or CLI. For more information, see [ Elastic Load Balancing Developer Guide](https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/Welcome.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun attachElasticLoadBalancer(block: AttachElasticLoadBalancerRequest.Builder.() -> Unit) = attachElasticLoadBalancer(AttachElasticLoadBalancerRequest.Builder().apply(block).build())

    /**
     * Creates a clone of a specified stack. For more information, see [Clone a Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-cloning.html). By default, all parameters are set to the values used by the parent stack.
     *
     * **Required Permissions**: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun cloneStack(input: CloneStackRequest): CloneStackResponse

    /**
     * Creates a clone of a specified stack. For more information, see [Clone a Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-cloning.html). By default, all parameters are set to the values used by the parent stack.
     *
     * **Required Permissions**: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun cloneStack(block: CloneStackRequest.Builder.() -> Unit) = cloneStack(CloneStackRequest.Builder().apply(block).build())

    /**
     * Creates an app for a specified stack. For more information, see [Creating Apps](https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun createApp(input: CreateAppRequest): CreateAppResponse

    /**
     * Creates an app for a specified stack. For more information, see [Creating Apps](https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun createApp(block: CreateAppRequest.Builder.() -> Unit) = createApp(CreateAppRequest.Builder().apply(block).build())

    /**
     * Runs deployment or stack commands. For more information, see [Deploying Apps](https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-deploying.html) and [Run Stack Commands](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-commands.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Deploy or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun createDeployment(input: CreateDeploymentRequest): CreateDeploymentResponse

    /**
     * Runs deployment or stack commands. For more information, see [Deploying Apps](https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-deploying.html) and [Run Stack Commands](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-commands.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Deploy or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun createDeployment(block: CreateDeploymentRequest.Builder.() -> Unit) = createDeployment(CreateDeploymentRequest.Builder().apply(block).build())

    /**
     * Creates an instance in a specified stack. For more information, see [Adding an Instance to a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun createInstance(input: CreateInstanceRequest): CreateInstanceResponse

    /**
     * Creates an instance in a specified stack. For more information, see [Adding an Instance to a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun createInstance(block: CreateInstanceRequest.Builder.() -> Unit) = createInstance(CreateInstanceRequest.Builder().apply(block).build())

    /**
     * Creates a layer. For more information, see [How to Create a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-create.html).
     *
     * You should use **CreateLayer** for noncustom layer types such as PHP App Server only if the stack does not have an existing layer of that type. A stack can have at most one instance of each noncustom layer; if you attempt to create a second instance, **CreateLayer** fails. A stack can have an arbitrary number of custom layers, so you can call **CreateLayer** as many times as you like for that layer type.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun createLayer(input: CreateLayerRequest): CreateLayerResponse

    /**
     * Creates a layer. For more information, see [How to Create a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-create.html).
     *
     * You should use **CreateLayer** for noncustom layer types such as PHP App Server only if the stack does not have an existing layer of that type. A stack can have at most one instance of each noncustom layer; if you attempt to create a second instance, **CreateLayer** fails. A stack can have an arbitrary number of custom layers, so you can call **CreateLayer** as many times as you like for that layer type.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun createLayer(block: CreateLayerRequest.Builder.() -> Unit) = createLayer(CreateLayerRequest.Builder().apply(block).build())

    /**
     * Creates a new stack. For more information, see [Create a New Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-edit.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun createStack(input: CreateStackRequest): CreateStackResponse

    /**
     * Creates a new stack. For more information, see [Create a New Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-edit.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun createStack(block: CreateStackRequest.Builder.() -> Unit) = createStack(CreateStackRequest.Builder().apply(block).build())

    /**
     * Creates a new user profile.
     *
     * **Required Permissions**: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun createUserProfile(input: CreateUserProfileRequest): CreateUserProfileResponse

    /**
     * Creates a new user profile.
     *
     * **Required Permissions**: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun createUserProfile(block: CreateUserProfileRequest.Builder.() -> Unit) = createUserProfile(CreateUserProfileRequest.Builder().apply(block).build())

    /**
     * Deletes a specified app.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun deleteApp(input: DeleteAppRequest): DeleteAppResponse

    /**
     * Deletes a specified app.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun deleteApp(block: DeleteAppRequest.Builder.() -> Unit) = deleteApp(DeleteAppRequest.Builder().apply(block).build())

    /**
     * Deletes a specified instance, which terminates the associated Amazon EC2 instance. You must stop an instance before you can delete it.
     *
     * For more information, see [Deleting Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-delete.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun deleteInstance(input: DeleteInstanceRequest): DeleteInstanceResponse

    /**
     * Deletes a specified instance, which terminates the associated Amazon EC2 instance. You must stop an instance before you can delete it.
     *
     * For more information, see [Deleting Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-delete.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun deleteInstance(block: DeleteInstanceRequest.Builder.() -> Unit) = deleteInstance(DeleteInstanceRequest.Builder().apply(block).build())

    /**
     * Deletes a specified layer. You must first stop and then delete all associated instances or unassign registered instances. For more information, see [How to Delete a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-delete.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun deleteLayer(input: DeleteLayerRequest): DeleteLayerResponse

    /**
     * Deletes a specified layer. You must first stop and then delete all associated instances or unassign registered instances. For more information, see [How to Delete a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-delete.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun deleteLayer(block: DeleteLayerRequest.Builder.() -> Unit) = deleteLayer(DeleteLayerRequest.Builder().apply(block).build())

    /**
     * Deletes a specified stack. You must first delete all instances, layers, and apps or deregister registered instances. For more information, see [Shut Down a Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-shutting.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun deleteStack(input: DeleteStackRequest): DeleteStackResponse

    /**
     * Deletes a specified stack. You must first delete all instances, layers, and apps or deregister registered instances. For more information, see [Shut Down a Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-shutting.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun deleteStack(block: DeleteStackRequest.Builder.() -> Unit) = deleteStack(DeleteStackRequest.Builder().apply(block).build())

    /**
     * Deletes a user profile.
     *
     * **Required Permissions**: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun deleteUserProfile(input: DeleteUserProfileRequest): DeleteUserProfileResponse

    /**
     * Deletes a user profile.
     *
     * **Required Permissions**: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun deleteUserProfile(block: DeleteUserProfileRequest.Builder.() -> Unit) = deleteUserProfile(DeleteUserProfileRequest.Builder().apply(block).build())

    /**
     * Deregisters a specified Amazon ECS cluster from a stack. For more information, see [ Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-ecscluster.html#workinglayers-ecscluster-delete).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see [https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun deregisterEcsCluster(input: DeregisterEcsClusterRequest): DeregisterEcsClusterResponse

    /**
     * Deregisters a specified Amazon ECS cluster from a stack. For more information, see [ Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-ecscluster.html#workinglayers-ecscluster-delete).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see [https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun deregisterEcsCluster(block: DeregisterEcsClusterRequest.Builder.() -> Unit) = deregisterEcsCluster(DeregisterEcsClusterRequest.Builder().apply(block).build())

    /**
     * Deregisters a specified Elastic IP address. The address can then be registered by another stack. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun deregisterElasticIp(input: DeregisterElasticIpRequest): DeregisterElasticIpResponse

    /**
     * Deregisters a specified Elastic IP address. The address can then be registered by another stack. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun deregisterElasticIp(block: DeregisterElasticIpRequest.Builder.() -> Unit) = deregisterElasticIp(DeregisterElasticIpRequest.Builder().apply(block).build())

    /**
     * Deregister a registered Amazon EC2 or on-premises instance. This action removes the instance from the stack and returns it to your control. This action cannot be used with instances that were created with AWS OpsWorks Stacks.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun deregisterInstance(input: DeregisterInstanceRequest): DeregisterInstanceResponse

    /**
     * Deregister a registered Amazon EC2 or on-premises instance. This action removes the instance from the stack and returns it to your control. This action cannot be used with instances that were created with AWS OpsWorks Stacks.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun deregisterInstance(block: DeregisterInstanceRequest.Builder.() -> Unit) = deregisterInstance(DeregisterInstanceRequest.Builder().apply(block).build())

    /**
     * Deregisters an Amazon RDS instance.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun deregisterRdsDbInstance(input: DeregisterRdsDbInstanceRequest): DeregisterRdsDbInstanceResponse

    /**
     * Deregisters an Amazon RDS instance.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun deregisterRdsDbInstance(block: DeregisterRdsDbInstanceRequest.Builder.() -> Unit) = deregisterRdsDbInstance(DeregisterRdsDbInstanceRequest.Builder().apply(block).build())

    /**
     * Deregisters an Amazon EBS volume. The volume can then be registered by another stack. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun deregisterVolume(input: DeregisterVolumeRequest): DeregisterVolumeResponse

    /**
     * Deregisters an Amazon EBS volume. The volume can then be registered by another stack. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun deregisterVolume(block: DeregisterVolumeRequest.Builder.() -> Unit) = deregisterVolume(DeregisterVolumeRequest.Builder().apply(block).build())

    /**
     * Describes the available AWS OpsWorks Stacks agent versions. You must specify a stack ID or a configuration manager. `DescribeAgentVersions` returns a list of available agent versions for the specified stack or configuration manager.
     */
    suspend fun describeAgentVersions(input: DescribeAgentVersionsRequest = DescribeAgentVersionsRequest {}): DescribeAgentVersionsResponse

    /**
     * Describes the available AWS OpsWorks Stacks agent versions. You must specify a stack ID or a configuration manager. `DescribeAgentVersions` returns a list of available agent versions for the specified stack or configuration manager.
     */
    suspend fun describeAgentVersions(block: DescribeAgentVersionsRequest.Builder.() -> Unit) = describeAgentVersions(DescribeAgentVersionsRequest.Builder().apply(block).build())

    /**
     * Requests a description of a specified set of apps.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeApps(input: DescribeAppsRequest = DescribeAppsRequest {}): DescribeAppsResponse

    /**
     * Requests a description of a specified set of apps.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeApps(block: DescribeAppsRequest.Builder.() -> Unit) = describeApps(DescribeAppsRequest.Builder().apply(block).build())

    /**
     * Describes the results of specified commands.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeCommands(input: DescribeCommandsRequest = DescribeCommandsRequest {}): DescribeCommandsResponse

    /**
     * Describes the results of specified commands.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeCommands(block: DescribeCommandsRequest.Builder.() -> Unit) = describeCommands(DescribeCommandsRequest.Builder().apply(block).build())

    /**
     * Requests a description of a specified set of deployments.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeDeployments(input: DescribeDeploymentsRequest = DescribeDeploymentsRequest {}): DescribeDeploymentsResponse

    /**
     * Requests a description of a specified set of deployments.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeDeployments(block: DescribeDeploymentsRequest.Builder.() -> Unit) = describeDeployments(DescribeDeploymentsRequest.Builder().apply(block).build())

    /**
     * Describes Amazon ECS clusters that are registered with a stack. If you specify only a stack ID, you can use the `MaxResults` and `NextToken` parameters to paginate the response. However, AWS OpsWorks Stacks currently supports only one cluster per layer, so the result set has a maximum of one element.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack or an attached policy that explicitly grants permission. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     *
     * This call accepts only one resource-identifying parameter.
     */
    suspend fun describeEcsClusters(input: DescribeEcsClustersRequest = DescribeEcsClustersRequest {}): DescribeEcsClustersResponse

    /**
     * Describes Amazon ECS clusters that are registered with a stack. If you specify only a stack ID, you can use the `MaxResults` and `NextToken` parameters to paginate the response. However, AWS OpsWorks Stacks currently supports only one cluster per layer, so the result set has a maximum of one element.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack or an attached policy that explicitly grants permission. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     *
     * This call accepts only one resource-identifying parameter.
     */
    suspend fun describeEcsClusters(block: DescribeEcsClustersRequest.Builder.() -> Unit) = describeEcsClusters(DescribeEcsClustersRequest.Builder().apply(block).build())

    /**
     * Describes [Elastic IP addresses](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html).
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeElasticIps(input: DescribeElasticIpsRequest = DescribeElasticIpsRequest {}): DescribeElasticIpsResponse

    /**
     * Describes [Elastic IP addresses](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html).
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeElasticIps(block: DescribeElasticIpsRequest.Builder.() -> Unit) = describeElasticIps(DescribeElasticIpsRequest.Builder().apply(block).build())

    /**
     * Describes a stack's Elastic Load Balancing instances.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeElasticLoadBalancers(input: DescribeElasticLoadBalancersRequest = DescribeElasticLoadBalancersRequest {}): DescribeElasticLoadBalancersResponse

    /**
     * Describes a stack's Elastic Load Balancing instances.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeElasticLoadBalancers(block: DescribeElasticLoadBalancersRequest.Builder.() -> Unit) = describeElasticLoadBalancers(DescribeElasticLoadBalancersRequest.Builder().apply(block).build())

    /**
     * Requests a description of a set of instances.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeInstances(input: DescribeInstancesRequest = DescribeInstancesRequest {}): DescribeInstancesResponse

    /**
     * Requests a description of a set of instances.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeInstances(block: DescribeInstancesRequest.Builder.() -> Unit) = describeInstances(DescribeInstancesRequest.Builder().apply(block).build())

    /**
     * Requests a description of one or more layers in a specified stack.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeLayers(input: DescribeLayersRequest = DescribeLayersRequest {}): DescribeLayersResponse

    /**
     * Requests a description of one or more layers in a specified stack.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeLayers(block: DescribeLayersRequest.Builder.() -> Unit) = describeLayers(DescribeLayersRequest.Builder().apply(block).build())

    /**
     * Describes load-based auto scaling configurations for specified layers.
     *
     * You must specify at least one of the parameters.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeLoadBasedAutoScaling(input: DescribeLoadBasedAutoScalingRequest): DescribeLoadBasedAutoScalingResponse

    /**
     * Describes load-based auto scaling configurations for specified layers.
     *
     * You must specify at least one of the parameters.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeLoadBasedAutoScaling(block: DescribeLoadBasedAutoScalingRequest.Builder.() -> Unit) = describeLoadBasedAutoScaling(DescribeLoadBasedAutoScalingRequest.Builder().apply(block).build())

    /**
     * Describes a user's SSH information.
     *
     * **Required Permissions**: To use this action, an IAM user must have self-management enabled or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeMyUserProfile(input: DescribeMyUserProfileRequest = DescribeMyUserProfileRequest {}): DescribeMyUserProfileResponse

    /**
     * Describes a user's SSH information.
     *
     * **Required Permissions**: To use this action, an IAM user must have self-management enabled or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeMyUserProfile(block: DescribeMyUserProfileRequest.Builder.() -> Unit) = describeMyUserProfile(DescribeMyUserProfileRequest.Builder().apply(block).build())

    /**
     * Describes the operating systems that are supported by AWS OpsWorks Stacks.
     */
    suspend fun describeOperatingSystems(input: DescribeOperatingSystemsRequest = DescribeOperatingSystemsRequest {}): DescribeOperatingSystemsResponse

    /**
     * Describes the operating systems that are supported by AWS OpsWorks Stacks.
     */
    suspend fun describeOperatingSystems(block: DescribeOperatingSystemsRequest.Builder.() -> Unit) = describeOperatingSystems(DescribeOperatingSystemsRequest.Builder().apply(block).build())

    /**
     * Describes the permissions for a specified stack.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describePermissions(input: DescribePermissionsRequest = DescribePermissionsRequest {}): DescribePermissionsResponse

    /**
     * Describes the permissions for a specified stack.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describePermissions(block: DescribePermissionsRequest.Builder.() -> Unit) = describePermissions(DescribePermissionsRequest.Builder().apply(block).build())

    /**
     * Describe an instance's RAID arrays.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeRaidArrays(input: DescribeRaidArraysRequest = DescribeRaidArraysRequest {}): DescribeRaidArraysResponse

    /**
     * Describe an instance's RAID arrays.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeRaidArrays(block: DescribeRaidArraysRequest.Builder.() -> Unit) = describeRaidArrays(DescribeRaidArraysRequest.Builder().apply(block).build())

    /**
     * Describes Amazon RDS instances.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     *
     * This call accepts only one resource-identifying parameter.
     */
    suspend fun describeRdsDbInstances(input: DescribeRdsDbInstancesRequest): DescribeRdsDbInstancesResponse

    /**
     * Describes Amazon RDS instances.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     *
     * This call accepts only one resource-identifying parameter.
     */
    suspend fun describeRdsDbInstances(block: DescribeRdsDbInstancesRequest.Builder.() -> Unit) = describeRdsDbInstances(DescribeRdsDbInstancesRequest.Builder().apply(block).build())

    /**
     * Describes AWS OpsWorks Stacks service errors.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     *
     * This call accepts only one resource-identifying parameter.
     */
    suspend fun describeServiceErrors(input: DescribeServiceErrorsRequest = DescribeServiceErrorsRequest {}): DescribeServiceErrorsResponse

    /**
     * Describes AWS OpsWorks Stacks service errors.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     *
     * This call accepts only one resource-identifying parameter.
     */
    suspend fun describeServiceErrors(block: DescribeServiceErrorsRequest.Builder.() -> Unit) = describeServiceErrors(DescribeServiceErrorsRequest.Builder().apply(block).build())

    /**
     * Requests a description of a stack's provisioning parameters.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeStackProvisioningParameters(input: DescribeStackProvisioningParametersRequest): DescribeStackProvisioningParametersResponse

    /**
     * Requests a description of a stack's provisioning parameters.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeStackProvisioningParameters(block: DescribeStackProvisioningParametersRequest.Builder.() -> Unit) = describeStackProvisioningParameters(DescribeStackProvisioningParametersRequest.Builder().apply(block).build())

    /**
     * Describes the number of layers and apps in a specified stack, and the number of instances in each state, such as `running_setup` or `online`.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeStackSummary(input: DescribeStackSummaryRequest): DescribeStackSummaryResponse

    /**
     * Describes the number of layers and apps in a specified stack, and the number of instances in each state, such as `running_setup` or `online`.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeStackSummary(block: DescribeStackSummaryRequest.Builder.() -> Unit) = describeStackSummary(DescribeStackSummaryRequest.Builder().apply(block).build())

    /**
     * Requests a description of one or more stacks.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeStacks(input: DescribeStacksRequest = DescribeStacksRequest {}): DescribeStacksResponse

    /**
     * Requests a description of one or more stacks.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeStacks(block: DescribeStacksRequest.Builder.() -> Unit) = describeStacks(DescribeStacksRequest.Builder().apply(block).build())

    /**
     * Describes time-based auto scaling configurations for specified instances.
     *
     * You must specify at least one of the parameters.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeTimeBasedAutoScaling(input: DescribeTimeBasedAutoScalingRequest): DescribeTimeBasedAutoScalingResponse

    /**
     * Describes time-based auto scaling configurations for specified instances.
     *
     * You must specify at least one of the parameters.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeTimeBasedAutoScaling(block: DescribeTimeBasedAutoScalingRequest.Builder.() -> Unit) = describeTimeBasedAutoScaling(DescribeTimeBasedAutoScalingRequest.Builder().apply(block).build())

    /**
     * Describe specified users.
     *
     * **Required Permissions**: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeUserProfiles(input: DescribeUserProfilesRequest = DescribeUserProfilesRequest {}): DescribeUserProfilesResponse

    /**
     * Describe specified users.
     *
     * **Required Permissions**: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeUserProfiles(block: DescribeUserProfilesRequest.Builder.() -> Unit) = describeUserProfiles(DescribeUserProfilesRequest.Builder().apply(block).build())

    /**
     * Describes an instance's Amazon EBS volumes.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeVolumes(input: DescribeVolumesRequest = DescribeVolumesRequest {}): DescribeVolumesResponse

    /**
     * Describes an instance's Amazon EBS volumes.
     *
     * This call accepts only one resource-identifying parameter.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun describeVolumes(block: DescribeVolumesRequest.Builder.() -> Unit) = describeVolumes(DescribeVolumesRequest.Builder().apply(block).build())

    /**
     * Detaches a specified Elastic Load Balancing instance from its layer.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun detachElasticLoadBalancer(input: DetachElasticLoadBalancerRequest): DetachElasticLoadBalancerResponse

    /**
     * Detaches a specified Elastic Load Balancing instance from its layer.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun detachElasticLoadBalancer(block: DetachElasticLoadBalancerRequest.Builder.() -> Unit) = detachElasticLoadBalancer(DetachElasticLoadBalancerRequest.Builder().apply(block).build())

    /**
     * Disassociates an Elastic IP address from its instance. The address remains registered with the stack. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun disassociateElasticIp(input: DisassociateElasticIpRequest): DisassociateElasticIpResponse

    /**
     * Disassociates an Elastic IP address from its instance. The address remains registered with the stack. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun disassociateElasticIp(block: DisassociateElasticIpRequest.Builder.() -> Unit) = disassociateElasticIp(DisassociateElasticIpRequest.Builder().apply(block).build())

    /**
     * Gets a generated host name for the specified layer, based on the current host name theme.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun getHostnameSuggestion(input: GetHostnameSuggestionRequest): GetHostnameSuggestionResponse

    /**
     * Gets a generated host name for the specified layer, based on the current host name theme.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun getHostnameSuggestion(block: GetHostnameSuggestionRequest.Builder.() -> Unit) = getHostnameSuggestion(GetHostnameSuggestionRequest.Builder().apply(block).build())

    /**
     * This action can be used only with Windows stacks.
     *
     * Grants RDP access to a Windows instance for a specified time period.
     */
    suspend fun grantAccess(input: GrantAccessRequest): GrantAccessResponse

    /**
     * This action can be used only with Windows stacks.
     *
     * Grants RDP access to a Windows instance for a specified time period.
     */
    suspend fun grantAccess(block: GrantAccessRequest.Builder.() -> Unit) = grantAccess(GrantAccessRequest.Builder().apply(block).build())

    /**
     * Returns a list of tags that are applied to the specified stack or layer.
     */
    suspend fun listTags(input: ListTagsRequest): ListTagsResponse

    /**
     * Returns a list of tags that are applied to the specified stack or layer.
     */
    suspend fun listTags(block: ListTagsRequest.Builder.() -> Unit) = listTags(ListTagsRequest.Builder().apply(block).build())

    /**
     * Reboots a specified instance. For more information, see [Starting, Stopping, and Rebooting Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun rebootInstance(input: RebootInstanceRequest): RebootInstanceResponse

    /**
     * Reboots a specified instance. For more information, see [Starting, Stopping, and Rebooting Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun rebootInstance(block: RebootInstanceRequest.Builder.() -> Unit) = rebootInstance(RebootInstanceRequest.Builder().apply(block).build())

    /**
     * Registers a specified Amazon ECS cluster with a stack. You can register only one cluster with a stack. A cluster can be registered with only one stack. For more information, see [ Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-ecscluster.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see [ Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun registerEcsCluster(input: RegisterEcsClusterRequest): RegisterEcsClusterResponse

    /**
     * Registers a specified Amazon ECS cluster with a stack. You can register only one cluster with a stack. A cluster can be registered with only one stack. For more information, see [ Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-ecscluster.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see [ Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun registerEcsCluster(block: RegisterEcsClusterRequest.Builder.() -> Unit) = registerEcsCluster(RegisterEcsClusterRequest.Builder().apply(block).build())

    /**
     * Registers an Elastic IP address with a specified stack. An address can be registered with only one stack at a time. If the address is already registered, you must first deregister it by calling DeregisterElasticIp. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun registerElasticIp(input: RegisterElasticIpRequest): RegisterElasticIpResponse

    /**
     * Registers an Elastic IP address with a specified stack. An address can be registered with only one stack at a time. If the address is already registered, you must first deregister it by calling DeregisterElasticIp. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun registerElasticIp(block: RegisterElasticIpRequest.Builder.() -> Unit) = registerElasticIp(RegisterElasticIpRequest.Builder().apply(block).build())

    /**
     * Registers instances that were created outside of AWS OpsWorks Stacks with a specified stack.
     *
     * We do not recommend using this action to register instances. The complete registration operation includes two tasks: installing the AWS OpsWorks Stacks agent on the instance, and registering the instance with the stack. `RegisterInstance` handles only the second step. You should instead use the AWS CLI `register` command, which performs the entire registration operation. For more information, see [ Registering an Instance with an AWS OpsWorks Stacks Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/registered-instances-register.html).
     *
     * Registered instances have the same requirements as instances that are created by using the CreateInstance API. For example, registered instances must be running a supported Linux-based operating system, and they must have a supported instance type. For more information about requirements for instances that you want to register, see [ Preparing the Instance](https://docs.aws.amazon.com/opsworks/latest/userguide/registered-instances-register-registering-preparer.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun registerInstance(input: RegisterInstanceRequest): RegisterInstanceResponse

    /**
     * Registers instances that were created outside of AWS OpsWorks Stacks with a specified stack.
     *
     * We do not recommend using this action to register instances. The complete registration operation includes two tasks: installing the AWS OpsWorks Stacks agent on the instance, and registering the instance with the stack. `RegisterInstance` handles only the second step. You should instead use the AWS CLI `register` command, which performs the entire registration operation. For more information, see [ Registering an Instance with an AWS OpsWorks Stacks Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/registered-instances-register.html).
     *
     * Registered instances have the same requirements as instances that are created by using the CreateInstance API. For example, registered instances must be running a supported Linux-based operating system, and they must have a supported instance type. For more information about requirements for instances that you want to register, see [ Preparing the Instance](https://docs.aws.amazon.com/opsworks/latest/userguide/registered-instances-register-registering-preparer.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun registerInstance(block: RegisterInstanceRequest.Builder.() -> Unit) = registerInstance(RegisterInstanceRequest.Builder().apply(block).build())

    /**
     * Registers an Amazon RDS instance with a stack.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun registerRdsDbInstance(input: RegisterRdsDbInstanceRequest): RegisterRdsDbInstanceResponse

    /**
     * Registers an Amazon RDS instance with a stack.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun registerRdsDbInstance(block: RegisterRdsDbInstanceRequest.Builder.() -> Unit) = registerRdsDbInstance(RegisterRdsDbInstanceRequest.Builder().apply(block).build())

    /**
     * Registers an Amazon EBS volume with a specified stack. A volume can be registered with only one stack at a time. If the volume is already registered, you must first deregister it by calling DeregisterVolume. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun registerVolume(input: RegisterVolumeRequest): RegisterVolumeResponse

    /**
     * Registers an Amazon EBS volume with a specified stack. A volume can be registered with only one stack at a time. If the volume is already registered, you must first deregister it by calling DeregisterVolume. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun registerVolume(block: RegisterVolumeRequest.Builder.() -> Unit) = registerVolume(RegisterVolumeRequest.Builder().apply(block).build())

    /**
     * Specify the load-based auto scaling configuration for a specified layer. For more information, see [Managing Load with Time-based and Load-based Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-autoscaling.html).
     *
     * To use load-based auto scaling, you must create a set of load-based auto scaling instances. Load-based auto scaling operates only on the instances from that set, so you must ensure that you have created enough instances to handle the maximum anticipated load.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun setLoadBasedAutoScaling(input: SetLoadBasedAutoScalingRequest): SetLoadBasedAutoScalingResponse

    /**
     * Specify the load-based auto scaling configuration for a specified layer. For more information, see [Managing Load with Time-based and Load-based Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-autoscaling.html).
     *
     * To use load-based auto scaling, you must create a set of load-based auto scaling instances. Load-based auto scaling operates only on the instances from that set, so you must ensure that you have created enough instances to handle the maximum anticipated load.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun setLoadBasedAutoScaling(block: SetLoadBasedAutoScalingRequest.Builder.() -> Unit) = setLoadBasedAutoScaling(SetLoadBasedAutoScalingRequest.Builder().apply(block).build())

    /**
     * Specifies a user's permissions. For more information, see [Security and Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/workingsecurity.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun setPermission(input: SetPermissionRequest): SetPermissionResponse

    /**
     * Specifies a user's permissions. For more information, see [Security and Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/workingsecurity.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun setPermission(block: SetPermissionRequest.Builder.() -> Unit) = setPermission(SetPermissionRequest.Builder().apply(block).build())

    /**
     * Specify the time-based auto scaling configuration for a specified instance. For more information, see [Managing Load with Time-based and Load-based Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-autoscaling.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun setTimeBasedAutoScaling(input: SetTimeBasedAutoScalingRequest): SetTimeBasedAutoScalingResponse

    /**
     * Specify the time-based auto scaling configuration for a specified instance. For more information, see [Managing Load with Time-based and Load-based Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-autoscaling.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun setTimeBasedAutoScaling(block: SetTimeBasedAutoScalingRequest.Builder.() -> Unit) = setTimeBasedAutoScaling(SetTimeBasedAutoScalingRequest.Builder().apply(block).build())

    /**
     * Starts a specified instance. For more information, see [Starting, Stopping, and Rebooting Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun startInstance(input: StartInstanceRequest): StartInstanceResponse

    /**
     * Starts a specified instance. For more information, see [Starting, Stopping, and Rebooting Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun startInstance(block: StartInstanceRequest.Builder.() -> Unit) = startInstance(StartInstanceRequest.Builder().apply(block).build())

    /**
     * Starts a stack's instances.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun startStack(input: StartStackRequest): StartStackResponse

    /**
     * Starts a stack's instances.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun startStack(block: StartStackRequest.Builder.() -> Unit) = startStack(StartStackRequest.Builder().apply(block).build())

    /**
     * Stops a specified instance. When you stop a standard instance, the data disappears and must be reinstalled when you restart the instance. You can stop an Amazon EBS-backed instance without losing data. For more information, see [Starting, Stopping, and Rebooting Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun stopInstance(input: StopInstanceRequest): StopInstanceResponse

    /**
     * Stops a specified instance. When you stop a standard instance, the data disappears and must be reinstalled when you restart the instance. You can stop an Amazon EBS-backed instance without losing data. For more information, see [Starting, Stopping, and Rebooting Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun stopInstance(block: StopInstanceRequest.Builder.() -> Unit) = stopInstance(StopInstanceRequest.Builder().apply(block).build())

    /**
     * Stops a specified stack.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun stopStack(input: StopStackRequest): StopStackResponse

    /**
     * Stops a specified stack.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun stopStack(block: StopStackRequest.Builder.() -> Unit) = stopStack(StopStackRequest.Builder().apply(block).build())

    /**
     * Apply cost-allocation tags to a specified stack or layer in AWS OpsWorks Stacks. For more information about how tagging works, see [Tags](https://docs.aws.amazon.com/opsworks/latest/userguide/tagging.html) in the AWS OpsWorks User Guide.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Apply cost-allocation tags to a specified stack or layer in AWS OpsWorks Stacks. For more information about how tagging works, see [Tags](https://docs.aws.amazon.com/opsworks/latest/userguide/tagging.html) in the AWS OpsWorks User Guide.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Unassigns a registered instance from all layers that are using the instance. The instance remains in the stack as an unassigned instance, and can be assigned to another layer as needed. You cannot use this action with instances that were created with AWS OpsWorks Stacks.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun unassignInstance(input: UnassignInstanceRequest): UnassignInstanceResponse

    /**
     * Unassigns a registered instance from all layers that are using the instance. The instance remains in the stack as an unassigned instance, and can be assigned to another layer as needed. You cannot use this action with instances that were created with AWS OpsWorks Stacks.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun unassignInstance(block: UnassignInstanceRequest.Builder.() -> Unit) = unassignInstance(UnassignInstanceRequest.Builder().apply(block).build())

    /**
     * Unassigns an assigned Amazon EBS volume. The volume remains registered with the stack. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun unassignVolume(input: UnassignVolumeRequest): UnassignVolumeResponse

    /**
     * Unassigns an assigned Amazon EBS volume. The volume remains registered with the stack. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun unassignVolume(block: UnassignVolumeRequest.Builder.() -> Unit) = unassignVolume(UnassignVolumeRequest.Builder().apply(block).build())

    /**
     * Removes tags from a specified stack or layer.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes tags from a specified stack or layer.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates a specified app.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Deploy or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun updateApp(input: UpdateAppRequest): UpdateAppResponse

    /**
     * Updates a specified app.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Deploy or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun updateApp(block: UpdateAppRequest.Builder.() -> Unit) = updateApp(UpdateAppRequest.Builder().apply(block).build())

    /**
     * Updates a registered Elastic IP address's name. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun updateElasticIp(input: UpdateElasticIpRequest): UpdateElasticIpResponse

    /**
     * Updates a registered Elastic IP address's name. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun updateElasticIp(block: UpdateElasticIpRequest.Builder.() -> Unit) = updateElasticIp(UpdateElasticIpRequest.Builder().apply(block).build())

    /**
     * Updates a specified instance.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun updateInstance(input: UpdateInstanceRequest): UpdateInstanceResponse

    /**
     * Updates a specified instance.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun updateInstance(block: UpdateInstanceRequest.Builder.() -> Unit) = updateInstance(UpdateInstanceRequest.Builder().apply(block).build())

    /**
     * Updates a specified layer.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun updateLayer(input: UpdateLayerRequest): UpdateLayerResponse

    /**
     * Updates a specified layer.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun updateLayer(block: UpdateLayerRequest.Builder.() -> Unit) = updateLayer(UpdateLayerRequest.Builder().apply(block).build())

    /**
     * Updates a user's SSH public key.
     *
     * **Required Permissions**: To use this action, an IAM user must have self-management enabled or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun updateMyUserProfile(input: UpdateMyUserProfileRequest = UpdateMyUserProfileRequest {}): UpdateMyUserProfileResponse

    /**
     * Updates a user's SSH public key.
     *
     * **Required Permissions**: To use this action, an IAM user must have self-management enabled or an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun updateMyUserProfile(block: UpdateMyUserProfileRequest.Builder.() -> Unit) = updateMyUserProfile(UpdateMyUserProfileRequest.Builder().apply(block).build())

    /**
     * Updates an Amazon RDS instance.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun updateRdsDbInstance(input: UpdateRdsDbInstanceRequest): UpdateRdsDbInstanceResponse

    /**
     * Updates an Amazon RDS instance.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun updateRdsDbInstance(block: UpdateRdsDbInstanceRequest.Builder.() -> Unit) = updateRdsDbInstance(UpdateRdsDbInstanceRequest.Builder().apply(block).build())

    /**
     * Updates a specified stack.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun updateStack(input: UpdateStackRequest): UpdateStackResponse

    /**
     * Updates a specified stack.
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun updateStack(block: UpdateStackRequest.Builder.() -> Unit) = updateStack(UpdateStackRequest.Builder().apply(block).build())

    /**
     * Updates a specified user profile.
     *
     * **Required Permissions**: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun updateUserProfile(input: UpdateUserProfileRequest): UpdateUserProfileResponse

    /**
     * Updates a specified user profile.
     *
     * **Required Permissions**: To use this action, an IAM user must have an attached policy that explicitly grants permissions. For more information about user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun updateUserProfile(block: UpdateUserProfileRequest.Builder.() -> Unit) = updateUserProfile(UpdateUserProfileRequest.Builder().apply(block).build())

    /**
     * Updates an Amazon EBS volume's name or mount point. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun updateVolume(input: UpdateVolumeRequest): UpdateVolumeResponse

    /**
     * Updates an Amazon EBS volume's name or mount point. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
     *
     * **Required Permissions**: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see [Managing User Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
     */
    suspend fun updateVolume(block: UpdateVolumeRequest.Builder.() -> Unit) = updateVolume(UpdateVolumeRequest.Builder().apply(block).build())
}
