// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



/**
 * Describes a load-based auto scaling upscaling or downscaling threshold configuration, which specifies when AWS OpsWorks Stacks starts or stops load-based instances.
 */
class AutoScalingThresholds private constructor(builder: Builder) {
    /**
     * Custom Cloudwatch auto scaling alarms, to be used as thresholds. This parameter takes a list of up to five alarm names, which are case sensitive and must be in the same region as the stack.
     *
     * To use custom alarms, you must update your service role to allow `cloudwatch:DescribeAlarms`. You can either have AWS OpsWorks Stacks update the role for you when you first use this feature or you can edit the role manually. For more information, see [Allowing AWS OpsWorks Stacks to Act on Your Behalf](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-servicerole.html).
     */
    val alarms: List<String>? = builder.alarms
    /**
     * The CPU utilization threshold, as a percent of the available CPU. A value of -1 disables the threshold.
     */
    val cpuThreshold: kotlin.Double? = builder.cpuThreshold
    /**
     * The amount of time (in minutes) after a scaling event occurs that AWS OpsWorks Stacks should ignore metrics and suppress additional scaling events. For example, AWS OpsWorks Stacks adds new instances following an upscaling event but the instances won't start reducing the load until they have been booted and configured. There is no point in raising additional scaling events during that operation, which typically takes several minutes. `IgnoreMetricsTime` allows you to direct AWS OpsWorks Stacks to suppress scaling events long enough to get the new instances online.
     */
    val ignoreMetricsTime: kotlin.Int? = builder.ignoreMetricsTime
    /**
     * The number of instances to add or remove when the load exceeds a threshold.
     */
    val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * The load threshold. A value of -1 disables the threshold. For more information about how load is computed, see [Load (computing)](http://en.wikipedia.org/wiki/Load_%28computing%29).
     */
    val loadThreshold: kotlin.Double? = builder.loadThreshold
    /**
     * The memory utilization threshold, as a percent of the available memory. A value of -1 disables the threshold.
     */
    val memoryThreshold: kotlin.Double? = builder.memoryThreshold
    /**
     * The amount of time, in minutes, that the load must exceed a threshold before more instances are added or removed.
     */
    val thresholdsWaitTime: kotlin.Int? = builder.thresholdsWaitTime

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.AutoScalingThresholds = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoScalingThresholds(")
        append("alarms=$alarms,")
        append("cpuThreshold=$cpuThreshold,")
        append("ignoreMetricsTime=$ignoreMetricsTime,")
        append("instanceCount=$instanceCount,")
        append("loadThreshold=$loadThreshold,")
        append("memoryThreshold=$memoryThreshold,")
        append("thresholdsWaitTime=$thresholdsWaitTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarms?.hashCode() ?: 0
        result = 31 * result + (cpuThreshold?.hashCode() ?: 0)
        result = 31 * result + (ignoreMetricsTime ?: 0)
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (loadThreshold?.hashCode() ?: 0)
        result = 31 * result + (memoryThreshold?.hashCode() ?: 0)
        result = 31 * result + (thresholdsWaitTime ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoScalingThresholds

        if (alarms != other.alarms) return false
        if (cpuThreshold != other.cpuThreshold) return false
        if (ignoreMetricsTime != other.ignoreMetricsTime) return false
        if (instanceCount != other.instanceCount) return false
        if (loadThreshold != other.loadThreshold) return false
        if (memoryThreshold != other.memoryThreshold) return false
        if (thresholdsWaitTime != other.thresholdsWaitTime) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.AutoScalingThresholds = Builder(this).apply(block).build()

    class Builder {
        /**
         * Custom Cloudwatch auto scaling alarms, to be used as thresholds. This parameter takes a list of up to five alarm names, which are case sensitive and must be in the same region as the stack.
         *
         * To use custom alarms, you must update your service role to allow `cloudwatch:DescribeAlarms`. You can either have AWS OpsWorks Stacks update the role for you when you first use this feature or you can edit the role manually. For more information, see [Allowing AWS OpsWorks Stacks to Act on Your Behalf](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-servicerole.html).
         */
        var alarms: List<String>? = null
        /**
         * The CPU utilization threshold, as a percent of the available CPU. A value of -1 disables the threshold.
         */
        var cpuThreshold: kotlin.Double? = null
        /**
         * The amount of time (in minutes) after a scaling event occurs that AWS OpsWorks Stacks should ignore metrics and suppress additional scaling events. For example, AWS OpsWorks Stacks adds new instances following an upscaling event but the instances won't start reducing the load until they have been booted and configured. There is no point in raising additional scaling events during that operation, which typically takes several minutes. `IgnoreMetricsTime` allows you to direct AWS OpsWorks Stacks to suppress scaling events long enough to get the new instances online.
         */
        var ignoreMetricsTime: kotlin.Int? = null
        /**
         * The number of instances to add or remove when the load exceeds a threshold.
         */
        var instanceCount: kotlin.Int? = null
        /**
         * The load threshold. A value of -1 disables the threshold. For more information about how load is computed, see [Load (computing)](http://en.wikipedia.org/wiki/Load_%28computing%29).
         */
        var loadThreshold: kotlin.Double? = null
        /**
         * The memory utilization threshold, as a percent of the available memory. A value of -1 disables the threshold.
         */
        var memoryThreshold: kotlin.Double? = null
        /**
         * The amount of time, in minutes, that the load must exceed a threshold before more instances are added or removed.
         */
        var thresholdsWaitTime: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.AutoScalingThresholds) : this() {
            this.alarms = x.alarms
            this.cpuThreshold = x.cpuThreshold
            this.ignoreMetricsTime = x.ignoreMetricsTime
            this.instanceCount = x.instanceCount
            this.loadThreshold = x.loadThreshold
            this.memoryThreshold = x.memoryThreshold
            this.thresholdsWaitTime = x.thresholdsWaitTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.AutoScalingThresholds = AutoScalingThresholds(this)
    }
}
