// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



/**
 * Describes a block device mapping. This data type maps directly to the Amazon EC2 [BlockDeviceMapping](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html) data type.
 */
class BlockDeviceMapping private constructor(builder: Builder) {
    /**
     * The device name that is exposed to the instance, such as `/dev/sdh`. For the root device, you can use the explicit device name or you can set this parameter to `ROOT_DEVICE` and AWS OpsWorks Stacks will provide the correct device name.
     */
    val deviceName: kotlin.String? = builder.deviceName
    /**
     * An `EBSBlockDevice` that defines how to configure an Amazon EBS volume when the instance is launched.
     */
    val ebs: aws.sdk.kotlin.services.opsworks.model.EbsBlockDevice? = builder.ebs
    /**
     * Suppresses the specified device included in the AMI's block device mapping.
     */
    val noDevice: kotlin.String? = builder.noDevice
    /**
     * The virtual device name. For more information, see [BlockDeviceMapping](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html).
     */
    val virtualName: kotlin.String? = builder.virtualName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.BlockDeviceMapping = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BlockDeviceMapping(")
        append("deviceName=$deviceName,")
        append("ebs=$ebs,")
        append("noDevice=$noDevice,")
        append("virtualName=$virtualName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deviceName?.hashCode() ?: 0
        result = 31 * result + (ebs?.hashCode() ?: 0)
        result = 31 * result + (noDevice?.hashCode() ?: 0)
        result = 31 * result + (virtualName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BlockDeviceMapping

        if (deviceName != other.deviceName) return false
        if (ebs != other.ebs) return false
        if (noDevice != other.noDevice) return false
        if (virtualName != other.virtualName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.BlockDeviceMapping = Builder(this).apply(block).build()

    class Builder {
        /**
         * The device name that is exposed to the instance, such as `/dev/sdh`. For the root device, you can use the explicit device name or you can set this parameter to `ROOT_DEVICE` and AWS OpsWorks Stacks will provide the correct device name.
         */
        var deviceName: kotlin.String? = null
        /**
         * An `EBSBlockDevice` that defines how to configure an Amazon EBS volume when the instance is launched.
         */
        var ebs: aws.sdk.kotlin.services.opsworks.model.EbsBlockDevice? = null
        /**
         * Suppresses the specified device included in the AMI's block device mapping.
         */
        var noDevice: kotlin.String? = null
        /**
         * The virtual device name. For more information, see [BlockDeviceMapping](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html).
         */
        var virtualName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.BlockDeviceMapping) : this() {
            this.deviceName = x.deviceName
            this.ebs = x.ebs
            this.noDevice = x.noDevice
            this.virtualName = x.virtualName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.BlockDeviceMapping = BlockDeviceMapping(this)

        /**
         * construct an [aws.sdk.kotlin.services.opsworks.model.EbsBlockDevice] inside the given [block]
         */
        fun ebs(block: aws.sdk.kotlin.services.opsworks.model.EbsBlockDevice.Builder.() -> kotlin.Unit) {
            this.ebs = aws.sdk.kotlin.services.opsworks.model.EbsBlockDevice.invoke(block)
        }
    }
}
