// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



class CloneStackRequest private constructor(builder: Builder) {
    /**
     * The default AWS OpsWorks Stacks agent version. You have the following options:
     * + Auto-update - Set this parameter to `LATEST`. AWS OpsWorks Stacks automatically installs new agent versions on the stack's instances as soon as they are available.
     * + Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the stack's instances.
     *
     * The default setting is `LATEST`. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call DescribeAgentVersions. AgentVersion cannot be set to Chef 12.2.
     *
     * You can also specify an agent version when you create or update an instance, which overrides the stack's default setting.
     */
    val agentVersion: kotlin.String? = builder.agentVersion
    /**
     * A list of stack attributes and values as key/value pairs to be added to the cloned stack.
     */
    val attributes: Map<String, String>? = builder.attributes
    /**
     * A `ChefConfiguration` object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see [Create a New Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
     */
    val chefConfiguration: aws.sdk.kotlin.services.opsworks.model.ChefConfiguration? = builder.chefConfiguration
    /**
     * A list of source stack app IDs to be included in the cloned stack.
     */
    val cloneAppIds: List<String>? = builder.cloneAppIds
    /**
     * Whether to clone the source stack's permissions.
     */
    val clonePermissions: kotlin.Boolean? = builder.clonePermissions
    /**
     * The configuration manager. When you clone a stack we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12.
     */
    val configurationManager: aws.sdk.kotlin.services.opsworks.model.StackConfigurationManager? = builder.configurationManager
    /**
     * Contains the information required to retrieve an app or cookbook from a repository. For more information, see [Adding Apps](https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html) or [Cookbooks and Recipes](https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html).
     */
    val customCookbooksSource: aws.sdk.kotlin.services.opsworks.model.Source? = builder.customCookbooksSource
    /**
     * A string that contains user-defined, custom JSON. It is used to override the corresponding default stack configuration JSON values. The string should be in the following format:
     *
     * `"{\"key1\": \"value1\", \"key2\": \"value2\",...}"`
     *
     * For more information about custom JSON, see [Use Custom JSON to Modify the Stack Configuration Attributes](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html)
     */
    val customJson: kotlin.String? = builder.customJson
    /**
     * The cloned stack's default Availability Zone, which must be in the specified region. For more information, see [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html). If you also specify a value for `DefaultSubnetId`, the subnet must be in the same zone. For more information, see the `VpcId` parameter description.
     */
    val defaultAvailabilityZone: kotlin.String? = builder.defaultAvailabilityZone
    /**
     * The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2 instances. For more information about IAM ARNs, see [Using Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
     */
    val defaultInstanceProfileArn: kotlin.String? = builder.defaultInstanceProfileArn
    /**
     * The stack's operating system, which must be set to one of the following.
     * + A supported Linux operating system: An Amazon Linux version, such as `Amazon Linux 2018.03`, `Amazon Linux 2017.09`, `Amazon Linux 2017.03`, `Amazon Linux 2016.09`, `Amazon Linux 2016.03`, `Amazon Linux 2015.09`, or `Amazon Linux 2015.03`.
     * + A supported Ubuntu operating system, such as `Ubuntu 16.04 LTS`, `Ubuntu 14.04 LTS`, or `Ubuntu 12.04 LTS`.
     * + `CentOS Linux 7`
     * + `Red Hat Enterprise Linux 7`
     * + `Microsoft Windows Server 2012 R2 Base`, `Microsoft Windows Server 2012 R2 with SQL Server Express`, `Microsoft Windows Server 2012 R2 with SQL Server Standard`, or `Microsoft Windows Server 2012 R2 with SQL Server Web`.
     * + A custom AMI: `Custom`. You specify the custom AMI you want to use when you create instances. For more information about how to use custom AMIs with OpsWorks, see [Using Custom AMIs](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
     *
     * The default option is the parent stack's operating system. For more information about supported operating systems, see [AWS OpsWorks Stacks Operating Systems](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
     *
     * You can specify a different Linux operating system for the cloned stack, but you cannot change from Linux to Windows or Windows to Linux.
     */
    val defaultOs: kotlin.String? = builder.defaultOs
    /**
     * The default root device type. This value is used by default for all instances in the cloned stack, but you can override it when you create an instance. For more information, see [Storage for the Root Device](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
     */
    val defaultRootDeviceType: aws.sdk.kotlin.services.opsworks.model.RootDeviceType? = builder.defaultRootDeviceType
    /**
     * A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS OpsWorks installs the public key on the instance and you can use the private key with an SSH client to log in to the instance. For more information, see [ Using SSH to Communicate with an Instance](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html) and [ Managing SSH Access](https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html). You can override this setting by specifying a different key pair, or no key pair, when you [ create an instance](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html).
     */
    val defaultSshKeyName: kotlin.String? = builder.defaultSshKeyName
    /**
     * The stack's default VPC subnet ID. This parameter is required if you specify a value for the `VpcId` parameter. All instances are launched into this subnet unless you specify otherwise when you create the instance. If you also specify a value for `DefaultAvailabilityZone`, the subnet must be in that zone. For information on default values and when this parameter is required, see the `VpcId` parameter description.
     */
    val defaultSubnetId: kotlin.String? = builder.defaultSubnetId
    /**
     * The stack's host name theme, with spaces are replaced by underscores. The theme is used to generate host names for the stack's instances. By default, `HostnameTheme` is set to `Layer_Dependent`, which creates host names by appending integers to the layer's short name. The other themes are:
     * + `Baked_Goods`
     * + `Clouds`
     * + `Europe_Cities`
     * + `Fruits`
     * + `Greek_Deities_and_Titans`
     * + `Legendary_creatures_from_Japan`
     * + `Planets_and_Moons`
     * + `Roman_Deities`
     * + `Scottish_Islands`
     * + `US_Cities`
     * + `Wild_Cats`
     *
     * To obtain a generated host name, call `GetHostNameSuggestion`, which returns a host name based on the current theme.
     */
    val hostnameTheme: kotlin.String? = builder.hostnameTheme
    /**
     * The cloned stack name.
     */
    val name: kotlin.String? = builder.name
    /**
     * The cloned stack AWS region, such as "ap-northeast-2". For more information about AWS regions, see [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html).
     */
    val region: kotlin.String? = builder.region
    /**
     * The stack AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work with AWS resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an existing IAM role. If you create a stack by using the AWS OpsWorks Stacks console, it creates the role for you. You can obtain an existing stack's IAM ARN programmatically by calling DescribePermissions. For more information about IAM ARNs, see [Using Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
     *
     * You must set this parameter to a valid service role ARN or the action will fail; there is no default value. You can specify the source stack's service role ARN, if you prefer, but you must do so explicitly.
     */
    val serviceRoleArn: kotlin.String? = builder.serviceRoleArn
    /**
     * The source stack ID.
     */
    val sourceStackId: kotlin.String? = builder.sourceStackId
    /**
     * Whether to use custom cookbooks.
     */
    val useCustomCookbooks: kotlin.Boolean? = builder.useCustomCookbooks
    /**
     * Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.
     *
     * AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. With `UseOpsworksSecurityGroups` you can instead provide your own custom security groups. `UseOpsworksSecurityGroups` has the following settings:
     * + True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it but you cannot delete the built-in security group.
     * + False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate Amazon Elastic Compute Cloud (Amazon EC2) security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on creation; custom security groups are required only for those layers that need custom settings.
     *
     * For more information, see [Create a New Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
     */
    val useOpsworksSecurityGroups: kotlin.Boolean? = builder.useOpsworksSecurityGroups
    /**
     * The ID of the VPC that the cloned stack is to be launched into. It must be in the specified region. All instances are launched into this VPC, and you cannot change the ID later.
     * + If your account supports EC2 Classic, the default value is no VPC.
     * + If your account does not support EC2 Classic, the default value is the default VPC for the specified region.
     *
     * If the VPC ID corresponds to a default VPC and you have specified either the `DefaultAvailabilityZone` or the `DefaultSubnetId` parameter only, AWS OpsWorks Stacks infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks sets these parameters to the first valid Availability Zone for the specified region and the corresponding default VPC subnet ID, respectively.
     *
     * If you specify a nondefault VPC ID, note the following:
     * + It must belong to a VPC in your account that is in the specified region.
     * + You must specify a value for `DefaultSubnetId`.
     *
     * For more information about how to use AWS OpsWorks Stacks with a VPC, see [Running a Stack in a VPC](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html). For more information about default VPC and EC2 Classic, see [Supported Platforms](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html).
     */
    val vpcId: kotlin.String? = builder.vpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.CloneStackRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloneStackRequest(")
        append("agentVersion=$agentVersion,")
        append("attributes=$attributes,")
        append("chefConfiguration=$chefConfiguration,")
        append("cloneAppIds=$cloneAppIds,")
        append("clonePermissions=$clonePermissions,")
        append("configurationManager=$configurationManager,")
        append("customCookbooksSource=$customCookbooksSource,")
        append("customJson=$customJson,")
        append("defaultAvailabilityZone=$defaultAvailabilityZone,")
        append("defaultInstanceProfileArn=$defaultInstanceProfileArn,")
        append("defaultOs=$defaultOs,")
        append("defaultRootDeviceType=$defaultRootDeviceType,")
        append("defaultSshKeyName=$defaultSshKeyName,")
        append("defaultSubnetId=$defaultSubnetId,")
        append("hostnameTheme=$hostnameTheme,")
        append("name=$name,")
        append("region=$region,")
        append("serviceRoleArn=$serviceRoleArn,")
        append("sourceStackId=$sourceStackId,")
        append("useCustomCookbooks=$useCustomCookbooks,")
        append("useOpsworksSecurityGroups=$useOpsworksSecurityGroups,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentVersion?.hashCode() ?: 0
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (chefConfiguration?.hashCode() ?: 0)
        result = 31 * result + (cloneAppIds?.hashCode() ?: 0)
        result = 31 * result + (clonePermissions?.hashCode() ?: 0)
        result = 31 * result + (configurationManager?.hashCode() ?: 0)
        result = 31 * result + (customCookbooksSource?.hashCode() ?: 0)
        result = 31 * result + (customJson?.hashCode() ?: 0)
        result = 31 * result + (defaultAvailabilityZone?.hashCode() ?: 0)
        result = 31 * result + (defaultInstanceProfileArn?.hashCode() ?: 0)
        result = 31 * result + (defaultOs?.hashCode() ?: 0)
        result = 31 * result + (defaultRootDeviceType?.hashCode() ?: 0)
        result = 31 * result + (defaultSshKeyName?.hashCode() ?: 0)
        result = 31 * result + (defaultSubnetId?.hashCode() ?: 0)
        result = 31 * result + (hostnameTheme?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (serviceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (sourceStackId?.hashCode() ?: 0)
        result = 31 * result + (useCustomCookbooks?.hashCode() ?: 0)
        result = 31 * result + (useOpsworksSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloneStackRequest

        if (agentVersion != other.agentVersion) return false
        if (attributes != other.attributes) return false
        if (chefConfiguration != other.chefConfiguration) return false
        if (cloneAppIds != other.cloneAppIds) return false
        if (clonePermissions != other.clonePermissions) return false
        if (configurationManager != other.configurationManager) return false
        if (customCookbooksSource != other.customCookbooksSource) return false
        if (customJson != other.customJson) return false
        if (defaultAvailabilityZone != other.defaultAvailabilityZone) return false
        if (defaultInstanceProfileArn != other.defaultInstanceProfileArn) return false
        if (defaultOs != other.defaultOs) return false
        if (defaultRootDeviceType != other.defaultRootDeviceType) return false
        if (defaultSshKeyName != other.defaultSshKeyName) return false
        if (defaultSubnetId != other.defaultSubnetId) return false
        if (hostnameTheme != other.hostnameTheme) return false
        if (name != other.name) return false
        if (region != other.region) return false
        if (serviceRoleArn != other.serviceRoleArn) return false
        if (sourceStackId != other.sourceStackId) return false
        if (useCustomCookbooks != other.useCustomCookbooks) return false
        if (useOpsworksSecurityGroups != other.useOpsworksSecurityGroups) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.CloneStackRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The default AWS OpsWorks Stacks agent version. You have the following options:
         * + Auto-update - Set this parameter to `LATEST`. AWS OpsWorks Stacks automatically installs new agent versions on the stack's instances as soon as they are available.
         * + Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the stack's instances.
         *
         * The default setting is `LATEST`. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call DescribeAgentVersions. AgentVersion cannot be set to Chef 12.2.
         *
         * You can also specify an agent version when you create or update an instance, which overrides the stack's default setting.
         */
        var agentVersion: kotlin.String? = null
        /**
         * A list of stack attributes and values as key/value pairs to be added to the cloned stack.
         */
        var attributes: Map<String, String>? = null
        /**
         * A `ChefConfiguration` object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see [Create a New Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
         */
        var chefConfiguration: aws.sdk.kotlin.services.opsworks.model.ChefConfiguration? = null
        /**
         * A list of source stack app IDs to be included in the cloned stack.
         */
        var cloneAppIds: List<String>? = null
        /**
         * Whether to clone the source stack's permissions.
         */
        var clonePermissions: kotlin.Boolean? = null
        /**
         * The configuration manager. When you clone a stack we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12.
         */
        var configurationManager: aws.sdk.kotlin.services.opsworks.model.StackConfigurationManager? = null
        /**
         * Contains the information required to retrieve an app or cookbook from a repository. For more information, see [Adding Apps](https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html) or [Cookbooks and Recipes](https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html).
         */
        var customCookbooksSource: aws.sdk.kotlin.services.opsworks.model.Source? = null
        /**
         * A string that contains user-defined, custom JSON. It is used to override the corresponding default stack configuration JSON values. The string should be in the following format:
         *
         * `"{\"key1\": \"value1\", \"key2\": \"value2\",...}"`
         *
         * For more information about custom JSON, see [Use Custom JSON to Modify the Stack Configuration Attributes](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html)
         */
        var customJson: kotlin.String? = null
        /**
         * The cloned stack's default Availability Zone, which must be in the specified region. For more information, see [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html). If you also specify a value for `DefaultSubnetId`, the subnet must be in the same zone. For more information, see the `VpcId` parameter description.
         */
        var defaultAvailabilityZone: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2 instances. For more information about IAM ARNs, see [Using Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
         */
        var defaultInstanceProfileArn: kotlin.String? = null
        /**
         * The stack's operating system, which must be set to one of the following.
         * + A supported Linux operating system: An Amazon Linux version, such as `Amazon Linux 2018.03`, `Amazon Linux 2017.09`, `Amazon Linux 2017.03`, `Amazon Linux 2016.09`, `Amazon Linux 2016.03`, `Amazon Linux 2015.09`, or `Amazon Linux 2015.03`.
         * + A supported Ubuntu operating system, such as `Ubuntu 16.04 LTS`, `Ubuntu 14.04 LTS`, or `Ubuntu 12.04 LTS`.
         * + `CentOS Linux 7`
         * + `Red Hat Enterprise Linux 7`
         * + `Microsoft Windows Server 2012 R2 Base`, `Microsoft Windows Server 2012 R2 with SQL Server Express`, `Microsoft Windows Server 2012 R2 with SQL Server Standard`, or `Microsoft Windows Server 2012 R2 with SQL Server Web`.
         * + A custom AMI: `Custom`. You specify the custom AMI you want to use when you create instances. For more information about how to use custom AMIs with OpsWorks, see [Using Custom AMIs](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
         *
         * The default option is the parent stack's operating system. For more information about supported operating systems, see [AWS OpsWorks Stacks Operating Systems](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
         *
         * You can specify a different Linux operating system for the cloned stack, but you cannot change from Linux to Windows or Windows to Linux.
         */
        var defaultOs: kotlin.String? = null
        /**
         * The default root device type. This value is used by default for all instances in the cloned stack, but you can override it when you create an instance. For more information, see [Storage for the Root Device](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
         */
        var defaultRootDeviceType: aws.sdk.kotlin.services.opsworks.model.RootDeviceType? = null
        /**
         * A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS OpsWorks installs the public key on the instance and you can use the private key with an SSH client to log in to the instance. For more information, see [ Using SSH to Communicate with an Instance](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html) and [ Managing SSH Access](https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html). You can override this setting by specifying a different key pair, or no key pair, when you [ create an instance](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html).
         */
        var defaultSshKeyName: kotlin.String? = null
        /**
         * The stack's default VPC subnet ID. This parameter is required if you specify a value for the `VpcId` parameter. All instances are launched into this subnet unless you specify otherwise when you create the instance. If you also specify a value for `DefaultAvailabilityZone`, the subnet must be in that zone. For information on default values and when this parameter is required, see the `VpcId` parameter description.
         */
        var defaultSubnetId: kotlin.String? = null
        /**
         * The stack's host name theme, with spaces are replaced by underscores. The theme is used to generate host names for the stack's instances. By default, `HostnameTheme` is set to `Layer_Dependent`, which creates host names by appending integers to the layer's short name. The other themes are:
         * + `Baked_Goods`
         * + `Clouds`
         * + `Europe_Cities`
         * + `Fruits`
         * + `Greek_Deities_and_Titans`
         * + `Legendary_creatures_from_Japan`
         * + `Planets_and_Moons`
         * + `Roman_Deities`
         * + `Scottish_Islands`
         * + `US_Cities`
         * + `Wild_Cats`
         *
         * To obtain a generated host name, call `GetHostNameSuggestion`, which returns a host name based on the current theme.
         */
        var hostnameTheme: kotlin.String? = null
        /**
         * The cloned stack name.
         */
        var name: kotlin.String? = null
        /**
         * The cloned stack AWS region, such as "ap-northeast-2". For more information about AWS regions, see [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html).
         */
        var region: kotlin.String? = null
        /**
         * The stack AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work with AWS resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an existing IAM role. If you create a stack by using the AWS OpsWorks Stacks console, it creates the role for you. You can obtain an existing stack's IAM ARN programmatically by calling DescribePermissions. For more information about IAM ARNs, see [Using Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
         *
         * You must set this parameter to a valid service role ARN or the action will fail; there is no default value. You can specify the source stack's service role ARN, if you prefer, but you must do so explicitly.
         */
        var serviceRoleArn: kotlin.String? = null
        /**
         * The source stack ID.
         */
        var sourceStackId: kotlin.String? = null
        /**
         * Whether to use custom cookbooks.
         */
        var useCustomCookbooks: kotlin.Boolean? = null
        /**
         * Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.
         *
         * AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. With `UseOpsworksSecurityGroups` you can instead provide your own custom security groups. `UseOpsworksSecurityGroups` has the following settings:
         * + True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it but you cannot delete the built-in security group.
         * + False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate Amazon Elastic Compute Cloud (Amazon EC2) security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on creation; custom security groups are required only for those layers that need custom settings.
         *
         * For more information, see [Create a New Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
         */
        var useOpsworksSecurityGroups: kotlin.Boolean? = null
        /**
         * The ID of the VPC that the cloned stack is to be launched into. It must be in the specified region. All instances are launched into this VPC, and you cannot change the ID later.
         * + If your account supports EC2 Classic, the default value is no VPC.
         * + If your account does not support EC2 Classic, the default value is the default VPC for the specified region.
         *
         * If the VPC ID corresponds to a default VPC and you have specified either the `DefaultAvailabilityZone` or the `DefaultSubnetId` parameter only, AWS OpsWorks Stacks infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks sets these parameters to the first valid Availability Zone for the specified region and the corresponding default VPC subnet ID, respectively.
         *
         * If you specify a nondefault VPC ID, note the following:
         * + It must belong to a VPC in your account that is in the specified region.
         * + You must specify a value for `DefaultSubnetId`.
         *
         * For more information about how to use AWS OpsWorks Stacks with a VPC, see [Running a Stack in a VPC](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html). For more information about default VPC and EC2 Classic, see [Supported Platforms](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html).
         */
        var vpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.CloneStackRequest) : this() {
            this.agentVersion = x.agentVersion
            this.attributes = x.attributes
            this.chefConfiguration = x.chefConfiguration
            this.cloneAppIds = x.cloneAppIds
            this.clonePermissions = x.clonePermissions
            this.configurationManager = x.configurationManager
            this.customCookbooksSource = x.customCookbooksSource
            this.customJson = x.customJson
            this.defaultAvailabilityZone = x.defaultAvailabilityZone
            this.defaultInstanceProfileArn = x.defaultInstanceProfileArn
            this.defaultOs = x.defaultOs
            this.defaultRootDeviceType = x.defaultRootDeviceType
            this.defaultSshKeyName = x.defaultSshKeyName
            this.defaultSubnetId = x.defaultSubnetId
            this.hostnameTheme = x.hostnameTheme
            this.name = x.name
            this.region = x.region
            this.serviceRoleArn = x.serviceRoleArn
            this.sourceStackId = x.sourceStackId
            this.useCustomCookbooks = x.useCustomCookbooks
            this.useOpsworksSecurityGroups = x.useOpsworksSecurityGroups
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.CloneStackRequest = CloneStackRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.opsworks.model.ChefConfiguration] inside the given [block]
         */
        fun chefConfiguration(block: aws.sdk.kotlin.services.opsworks.model.ChefConfiguration.Builder.() -> kotlin.Unit) {
            this.chefConfiguration = aws.sdk.kotlin.services.opsworks.model.ChefConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opsworks.model.StackConfigurationManager] inside the given [block]
         */
        fun configurationManager(block: aws.sdk.kotlin.services.opsworks.model.StackConfigurationManager.Builder.() -> kotlin.Unit) {
            this.configurationManager = aws.sdk.kotlin.services.opsworks.model.StackConfigurationManager.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opsworks.model.Source] inside the given [block]
         */
        fun customCookbooksSource(block: aws.sdk.kotlin.services.opsworks.model.Source.Builder.() -> kotlin.Unit) {
            this.customCookbooksSource = aws.sdk.kotlin.services.opsworks.model.Source.invoke(block)
        }
    }
}
