// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



/**
 * Describes the Amazon CloudWatch logs configuration for a layer. For detailed information about members of this data type, see the [CloudWatch Logs Agent Reference](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html).
 */
class CloudWatchLogsLogStream private constructor(builder: Builder) {
    /**
     * Specifies the max number of log events in a batch, up to 10000. The default value is 1000.
     */
    val batchCount: kotlin.Int? = builder.batchCount
    /**
     * Specifies the maximum size of log events in a batch, in bytes, up to 1048576 bytes. The default value is 32768 bytes. This size is calculated as the sum of all event messages in UTF-8, plus 26 bytes for each log event.
     */
    val batchSize: kotlin.Int? = builder.batchSize
    /**
     * Specifies the time duration for the batching of log events. The minimum value is 5000ms and default value is 5000ms.
     */
    val bufferDuration: kotlin.Int? = builder.bufferDuration
    /**
     * Specifies how the time stamp is extracted from logs. For more information, see the [CloudWatch Logs Agent Reference](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html).
     */
    val datetimeFormat: kotlin.String? = builder.datetimeFormat
    /**
     * Specifies the encoding of the log file so that the file can be read correctly. The default is `utf_8`. Encodings supported by Python `codecs.decode()` can be used here.
     */
    val encoding: aws.sdk.kotlin.services.opsworks.model.CloudWatchLogsEncoding? = builder.encoding
    /**
     * Specifies log files that you want to push to CloudWatch Logs.
     *
     * `File` can point to a specific file or multiple files (by using wild card characters such as `/var/log/system.log*`). Only the latest file is pushed to CloudWatch Logs, based on file modification time. We recommend that you use wild card characters to specify a series of files of the same type, such as `access_log.2014-06-01-01`, `access_log.2014-06-01-02`, and so on by using a pattern like `access_log.*`. Don't use a wildcard to match multiple file types, such as `access_log_80` and `access_log_443`. To specify multiple, different file types, add another log stream entry to the configuration file, so that each log file type is stored in a different log group.
     *
     * Zipped files are not supported.
     */
    val file: kotlin.String? = builder.file
    /**
     * Specifies the range of lines for identifying a file. The valid values are one number, or two dash-delimited numbers, such as '1', '2-5'. The default value is '1', meaning the first line is used to calculate the fingerprint. Fingerprint lines are not sent to CloudWatch Logs unless all specified lines are available.
     */
    val fileFingerprintLines: kotlin.String? = builder.fileFingerprintLines
    /**
     * Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file. This setting is only used if there is no state persisted for that log stream.
     */
    val initialPosition: aws.sdk.kotlin.services.opsworks.model.CloudWatchLogsInitialPosition? = builder.initialPosition
    /**
     * Specifies the destination log group. A log group is created automatically if it doesn't already exist. Log group names can be between 1 and 512 characters long. Allowed characters include a-z, A-Z, 0-9, '_' (underscore), '-' (hyphen), '/' (forward slash), and '.' (period).
     */
    val logGroupName: kotlin.String? = builder.logGroupName
    /**
     * Specifies the pattern for identifying the start of a log message.
     */
    val multiLineStartPattern: kotlin.String? = builder.multiLineStartPattern
    /**
     * Specifies the time zone of log event time stamps.
     */
    val timeZone: aws.sdk.kotlin.services.opsworks.model.CloudWatchLogsTimeZone? = builder.timeZone

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.CloudWatchLogsLogStream = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudWatchLogsLogStream(")
        append("batchCount=$batchCount,")
        append("batchSize=$batchSize,")
        append("bufferDuration=$bufferDuration,")
        append("datetimeFormat=$datetimeFormat,")
        append("encoding=$encoding,")
        append("file=$file,")
        append("fileFingerprintLines=$fileFingerprintLines,")
        append("initialPosition=$initialPosition,")
        append("logGroupName=$logGroupName,")
        append("multiLineStartPattern=$multiLineStartPattern,")
        append("timeZone=$timeZone)")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchCount ?: 0
        result = 31 * result + (batchSize ?: 0)
        result = 31 * result + (bufferDuration ?: 0)
        result = 31 * result + (datetimeFormat?.hashCode() ?: 0)
        result = 31 * result + (encoding?.hashCode() ?: 0)
        result = 31 * result + (file?.hashCode() ?: 0)
        result = 31 * result + (fileFingerprintLines?.hashCode() ?: 0)
        result = 31 * result + (initialPosition?.hashCode() ?: 0)
        result = 31 * result + (logGroupName?.hashCode() ?: 0)
        result = 31 * result + (multiLineStartPattern?.hashCode() ?: 0)
        result = 31 * result + (timeZone?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudWatchLogsLogStream

        if (batchCount != other.batchCount) return false
        if (batchSize != other.batchSize) return false
        if (bufferDuration != other.bufferDuration) return false
        if (datetimeFormat != other.datetimeFormat) return false
        if (encoding != other.encoding) return false
        if (file != other.file) return false
        if (fileFingerprintLines != other.fileFingerprintLines) return false
        if (initialPosition != other.initialPosition) return false
        if (logGroupName != other.logGroupName) return false
        if (multiLineStartPattern != other.multiLineStartPattern) return false
        if (timeZone != other.timeZone) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.CloudWatchLogsLogStream = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the max number of log events in a batch, up to 10000. The default value is 1000.
         */
        var batchCount: kotlin.Int? = null
        /**
         * Specifies the maximum size of log events in a batch, in bytes, up to 1048576 bytes. The default value is 32768 bytes. This size is calculated as the sum of all event messages in UTF-8, plus 26 bytes for each log event.
         */
        var batchSize: kotlin.Int? = null
        /**
         * Specifies the time duration for the batching of log events. The minimum value is 5000ms and default value is 5000ms.
         */
        var bufferDuration: kotlin.Int? = null
        /**
         * Specifies how the time stamp is extracted from logs. For more information, see the [CloudWatch Logs Agent Reference](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html).
         */
        var datetimeFormat: kotlin.String? = null
        /**
         * Specifies the encoding of the log file so that the file can be read correctly. The default is `utf_8`. Encodings supported by Python `codecs.decode()` can be used here.
         */
        var encoding: aws.sdk.kotlin.services.opsworks.model.CloudWatchLogsEncoding? = null
        /**
         * Specifies log files that you want to push to CloudWatch Logs.
         *
         * `File` can point to a specific file or multiple files (by using wild card characters such as `/var/log/system.log*`). Only the latest file is pushed to CloudWatch Logs, based on file modification time. We recommend that you use wild card characters to specify a series of files of the same type, such as `access_log.2014-06-01-01`, `access_log.2014-06-01-02`, and so on by using a pattern like `access_log.*`. Don't use a wildcard to match multiple file types, such as `access_log_80` and `access_log_443`. To specify multiple, different file types, add another log stream entry to the configuration file, so that each log file type is stored in a different log group.
         *
         * Zipped files are not supported.
         */
        var file: kotlin.String? = null
        /**
         * Specifies the range of lines for identifying a file. The valid values are one number, or two dash-delimited numbers, such as '1', '2-5'. The default value is '1', meaning the first line is used to calculate the fingerprint. Fingerprint lines are not sent to CloudWatch Logs unless all specified lines are available.
         */
        var fileFingerprintLines: kotlin.String? = null
        /**
         * Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file. This setting is only used if there is no state persisted for that log stream.
         */
        var initialPosition: aws.sdk.kotlin.services.opsworks.model.CloudWatchLogsInitialPosition? = null
        /**
         * Specifies the destination log group. A log group is created automatically if it doesn't already exist. Log group names can be between 1 and 512 characters long. Allowed characters include a-z, A-Z, 0-9, '_' (underscore), '-' (hyphen), '/' (forward slash), and '.' (period).
         */
        var logGroupName: kotlin.String? = null
        /**
         * Specifies the pattern for identifying the start of a log message.
         */
        var multiLineStartPattern: kotlin.String? = null
        /**
         * Specifies the time zone of log event time stamps.
         */
        var timeZone: aws.sdk.kotlin.services.opsworks.model.CloudWatchLogsTimeZone? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.CloudWatchLogsLogStream) : this() {
            this.batchCount = x.batchCount
            this.batchSize = x.batchSize
            this.bufferDuration = x.bufferDuration
            this.datetimeFormat = x.datetimeFormat
            this.encoding = x.encoding
            this.file = x.file
            this.fileFingerprintLines = x.fileFingerprintLines
            this.initialPosition = x.initialPosition
            this.logGroupName = x.logGroupName
            this.multiLineStartPattern = x.multiLineStartPattern
            this.timeZone = x.timeZone
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.CloudWatchLogsLogStream = CloudWatchLogsLogStream(this)
    }
}
