// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



class CreateAppRequest private constructor(builder: Builder) {
    /**
     * A `Source` object that specifies the app repository.
     */
    val appSource: aws.sdk.kotlin.services.opsworks.model.Source? = builder.appSource
    /**
     * One or more user-defined key/value pairs to be added to the stack attributes.
     */
    val attributes: Map<String, String>? = builder.attributes
    /**
     * The app's data source.
     */
    val dataSources: List<DataSource>? = builder.dataSources
    /**
     * A description of the app.
     */
    val description: kotlin.String? = builder.description
    /**
     * The app virtual host settings, with multiple domains separated by commas. For example: `'www.example.com, example.com'`
     */
    val domains: List<String>? = builder.domains
    /**
     * Whether to enable SSL for the app.
     */
    val enableSsl: kotlin.Boolean? = builder.enableSsl
    /**
     * An array of `EnvironmentVariable` objects that specify environment variables to be associated with the app. After you deploy the app, these variables are defined on the associated app server instance. For more information, see [ Environment Variables](https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment).
     *
     * There is no specific limit on the number of environment variables. However, the size of the associated data structure - which includes the variables' names, values, and protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all use cases. Exceeding it will cause an exception with the message, "Environment: is too large (maximum is 20KB)."
     *
     * If you have specified one or more environment variables, you cannot modify the stack's Chef version.
     */
    val environment: List<EnvironmentVariable>? = builder.environment
    /**
     * The app name.
     */
    val name: kotlin.String? = builder.name
    /**
     * The app's short name.
     */
    val shortname: kotlin.String? = builder.shortname
    /**
     * An `SslConfiguration` object with the SSL configuration.
     */
    val sslConfiguration: aws.sdk.kotlin.services.opsworks.model.SslConfiguration? = builder.sslConfiguration
    /**
     * The stack ID.
     */
    val stackId: kotlin.String? = builder.stackId
    /**
     * The app type. Each supported type is associated with a particular layer. For example, PHP applications are associated with a PHP layer. AWS OpsWorks Stacks deploys an application to those instances that are members of the corresponding layer. If your app isn't one of the standard types, or you prefer to implement your own Deploy recipes, specify `other`.
     */
    val type: aws.sdk.kotlin.services.opsworks.model.AppType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.CreateAppRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAppRequest(")
        append("appSource=$appSource,")
        append("attributes=$attributes,")
        append("dataSources=$dataSources,")
        append("description=$description,")
        append("domains=$domains,")
        append("enableSsl=$enableSsl,")
        append("environment=$environment,")
        append("name=$name,")
        append("shortname=$shortname,")
        append("sslConfiguration=$sslConfiguration,")
        append("stackId=$stackId,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appSource?.hashCode() ?: 0
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (dataSources?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (domains?.hashCode() ?: 0)
        result = 31 * result + (enableSsl?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (shortname?.hashCode() ?: 0)
        result = 31 * result + (sslConfiguration?.hashCode() ?: 0)
        result = 31 * result + (stackId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAppRequest

        if (appSource != other.appSource) return false
        if (attributes != other.attributes) return false
        if (dataSources != other.dataSources) return false
        if (description != other.description) return false
        if (domains != other.domains) return false
        if (enableSsl != other.enableSsl) return false
        if (environment != other.environment) return false
        if (name != other.name) return false
        if (shortname != other.shortname) return false
        if (sslConfiguration != other.sslConfiguration) return false
        if (stackId != other.stackId) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.CreateAppRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A `Source` object that specifies the app repository.
         */
        var appSource: aws.sdk.kotlin.services.opsworks.model.Source? = null
        /**
         * One or more user-defined key/value pairs to be added to the stack attributes.
         */
        var attributes: Map<String, String>? = null
        /**
         * The app's data source.
         */
        var dataSources: List<DataSource>? = null
        /**
         * A description of the app.
         */
        var description: kotlin.String? = null
        /**
         * The app virtual host settings, with multiple domains separated by commas. For example: `'www.example.com, example.com'`
         */
        var domains: List<String>? = null
        /**
         * Whether to enable SSL for the app.
         */
        var enableSsl: kotlin.Boolean? = null
        /**
         * An array of `EnvironmentVariable` objects that specify environment variables to be associated with the app. After you deploy the app, these variables are defined on the associated app server instance. For more information, see [ Environment Variables](https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment).
         *
         * There is no specific limit on the number of environment variables. However, the size of the associated data structure - which includes the variables' names, values, and protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all use cases. Exceeding it will cause an exception with the message, "Environment: is too large (maximum is 20KB)."
         *
         * If you have specified one or more environment variables, you cannot modify the stack's Chef version.
         */
        var environment: List<EnvironmentVariable>? = null
        /**
         * The app name.
         */
        var name: kotlin.String? = null
        /**
         * The app's short name.
         */
        var shortname: kotlin.String? = null
        /**
         * An `SslConfiguration` object with the SSL configuration.
         */
        var sslConfiguration: aws.sdk.kotlin.services.opsworks.model.SslConfiguration? = null
        /**
         * The stack ID.
         */
        var stackId: kotlin.String? = null
        /**
         * The app type. Each supported type is associated with a particular layer. For example, PHP applications are associated with a PHP layer. AWS OpsWorks Stacks deploys an application to those instances that are members of the corresponding layer. If your app isn't one of the standard types, or you prefer to implement your own Deploy recipes, specify `other`.
         */
        var type: aws.sdk.kotlin.services.opsworks.model.AppType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.CreateAppRequest) : this() {
            this.appSource = x.appSource
            this.attributes = x.attributes
            this.dataSources = x.dataSources
            this.description = x.description
            this.domains = x.domains
            this.enableSsl = x.enableSsl
            this.environment = x.environment
            this.name = x.name
            this.shortname = x.shortname
            this.sslConfiguration = x.sslConfiguration
            this.stackId = x.stackId
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.CreateAppRequest = CreateAppRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.opsworks.model.Source] inside the given [block]
         */
        fun appSource(block: aws.sdk.kotlin.services.opsworks.model.Source.Builder.() -> kotlin.Unit) {
            this.appSource = aws.sdk.kotlin.services.opsworks.model.Source.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opsworks.model.SslConfiguration] inside the given [block]
         */
        fun sslConfiguration(block: aws.sdk.kotlin.services.opsworks.model.SslConfiguration.Builder.() -> kotlin.Unit) {
            this.sslConfiguration = aws.sdk.kotlin.services.opsworks.model.SslConfiguration.invoke(block)
        }
    }
}
