// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



class CreateDeploymentRequest private constructor(builder: Builder) {
    /**
     * The app ID. This parameter is required for app deployments, but not for other deployment commands.
     */
    val appId: kotlin.String? = builder.appId
    /**
     * A `DeploymentCommand` object that specifies the deployment command and any associated arguments.
     */
    val command: aws.sdk.kotlin.services.opsworks.model.DeploymentCommand? = builder.command
    /**
     * A user-defined comment.
     */
    val comment: kotlin.String? = builder.comment
    /**
     * A string that contains user-defined, custom JSON. You can use this parameter to override some corresponding default stack configuration JSON values. The string should be in the following format:
     *
     * `"{\"key1\": \"value1\", \"key2\": \"value2\",...}"`
     *
     * For more information about custom JSON, see [Use Custom JSON to Modify the Stack Configuration Attributes](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html) and [Overriding Attributes With Custom JSON](https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html).
     */
    val customJson: kotlin.String? = builder.customJson
    /**
     * The instance IDs for the deployment targets.
     */
    val instanceIds: List<String>? = builder.instanceIds
    /**
     * The layer IDs for the deployment targets.
     */
    val layerIds: List<String>? = builder.layerIds
    /**
     * The stack ID.
     */
    val stackId: kotlin.String? = builder.stackId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.CreateDeploymentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDeploymentRequest(")
        append("appId=$appId,")
        append("command=$command,")
        append("comment=$comment,")
        append("customJson=$customJson,")
        append("instanceIds=$instanceIds,")
        append("layerIds=$layerIds,")
        append("stackId=$stackId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appId?.hashCode() ?: 0
        result = 31 * result + (command?.hashCode() ?: 0)
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (customJson?.hashCode() ?: 0)
        result = 31 * result + (instanceIds?.hashCode() ?: 0)
        result = 31 * result + (layerIds?.hashCode() ?: 0)
        result = 31 * result + (stackId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDeploymentRequest

        if (appId != other.appId) return false
        if (command != other.command) return false
        if (comment != other.comment) return false
        if (customJson != other.customJson) return false
        if (instanceIds != other.instanceIds) return false
        if (layerIds != other.layerIds) return false
        if (stackId != other.stackId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.CreateDeploymentRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The app ID. This parameter is required for app deployments, but not for other deployment commands.
         */
        var appId: kotlin.String? = null
        /**
         * A `DeploymentCommand` object that specifies the deployment command and any associated arguments.
         */
        var command: aws.sdk.kotlin.services.opsworks.model.DeploymentCommand? = null
        /**
         * A user-defined comment.
         */
        var comment: kotlin.String? = null
        /**
         * A string that contains user-defined, custom JSON. You can use this parameter to override some corresponding default stack configuration JSON values. The string should be in the following format:
         *
         * `"{\"key1\": \"value1\", \"key2\": \"value2\",...}"`
         *
         * For more information about custom JSON, see [Use Custom JSON to Modify the Stack Configuration Attributes](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html) and [Overriding Attributes With Custom JSON](https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html).
         */
        var customJson: kotlin.String? = null
        /**
         * The instance IDs for the deployment targets.
         */
        var instanceIds: List<String>? = null
        /**
         * The layer IDs for the deployment targets.
         */
        var layerIds: List<String>? = null
        /**
         * The stack ID.
         */
        var stackId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.CreateDeploymentRequest) : this() {
            this.appId = x.appId
            this.command = x.command
            this.comment = x.comment
            this.customJson = x.customJson
            this.instanceIds = x.instanceIds
            this.layerIds = x.layerIds
            this.stackId = x.stackId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.CreateDeploymentRequest = CreateDeploymentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.opsworks.model.DeploymentCommand] inside the given [block]
         */
        fun command(block: aws.sdk.kotlin.services.opsworks.model.DeploymentCommand.Builder.() -> kotlin.Unit) {
            this.command = aws.sdk.kotlin.services.opsworks.model.DeploymentCommand.invoke(block)
        }
    }
}
