// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



class CreateInstanceRequest private constructor(builder: Builder) {
    /**
     * The default AWS OpsWorks Stacks agent version. You have the following options:
     * + `INHERIT` - Use the stack's default agent version setting.
     * + *version_number* - Use the specified agent version. This value overrides the stack's default setting. To update the agent version, edit the instance configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the instance.
     *
     * The default setting is `INHERIT`. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call DescribeAgentVersions. AgentVersion cannot be set to Chef 12.2.
     */
    val agentVersion: kotlin.String? = builder.agentVersion
    /**
     * A custom AMI ID to be used to create the instance. The AMI should be based on one of the supported operating systems. For more information, see [Using Custom AMIs](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
     *
     * If you specify a custom AMI, you must set `Os` to `Custom`.
     */
    val amiId: kotlin.String? = builder.amiId
    /**
     * The instance architecture. The default option is `x86_64`. Instance types do not necessarily support both architectures. For a list of the architectures that are supported by the different instance types, see [Instance Families and Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html).
     */
    val architecture: aws.sdk.kotlin.services.opsworks.model.Architecture? = builder.architecture
    /**
     * For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
     */
    val autoScalingType: aws.sdk.kotlin.services.opsworks.model.AutoScalingType? = builder.autoScalingType
    /**
     * The instance Availability Zone. For more information, see [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html).
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * An array of `BlockDeviceMapping` objects that specify the instance's block devices. For more information, see [Block Device Mapping](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html). Note that block device mappings are not supported for custom AMIs.
     */
    val blockDeviceMappings: List<BlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * Whether to create an Amazon EBS-optimized instance.
     */
    val ebsOptimized: kotlin.Boolean? = builder.ebsOptimized
    /**
     * The instance host name.
     */
    val hostname: kotlin.String? = builder.hostname
    /**
     * Whether to install operating system and package updates when the instance boots. The default value is `true`. To control when updates are installed, set this value to `false`. You must then update your instances manually by using CreateDeployment to run the `update_dependencies` stack command or by manually running `yum` (Amazon Linux) or `apt-get` (Ubuntu) on the instances.
     *
     * We strongly recommend using the default value of `true` to ensure that your instances have the latest security updates.
     */
    val installUpdatesOnBoot: kotlin.Boolean? = builder.installUpdatesOnBoot
    /**
     * The instance type, such as `t2.micro`. For a list of supported instance types, open the stack in the console, choose **Instances**, and choose **+ Instance**. The **Size** list contains the currently supported types. For more information, see [Instance Families and Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html). The parameter values that you use to specify the various types are in the **API Name** column of the **Available Instance Types** table.
     */
    val instanceType: kotlin.String? = builder.instanceType
    /**
     * An array that contains the instance's layer IDs.
     */
    val layerIds: List<String>? = builder.layerIds
    /**
     * The instance's operating system, which must be set to one of the following.
     * + A supported Linux operating system: An Amazon Linux version, such as `Amazon Linux 2018.03`, `Amazon Linux 2017.09`, `Amazon Linux 2017.03`, `Amazon Linux 2016.09`, `Amazon Linux 2016.03`, `Amazon Linux 2015.09`, or `Amazon Linux 2015.03`.
     * + A supported Ubuntu operating system, such as `Ubuntu 16.04 LTS`, `Ubuntu 14.04 LTS`, or `Ubuntu 12.04 LTS`.
     * + `CentOS Linux 7`
     * + `Red Hat Enterprise Linux 7`
     * + A supported Windows operating system, such as `Microsoft Windows Server 2012 R2 Base`, `Microsoft Windows Server 2012 R2 with SQL Server Express`, `Microsoft Windows Server 2012 R2 with SQL Server Standard`, or `Microsoft Windows Server 2012 R2 with SQL Server Web`.
     * + A custom AMI: `Custom`.
     *
     * For more information about the supported operating systems, see [AWS OpsWorks Stacks Operating Systems](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
     *
     * The default option is the current Amazon Linux version. If you set this parameter to `Custom`, you must use the CreateInstance action's AmiId parameter to specify the custom AMI that you want to use. Block device mappings are not supported if the value is `Custom`. For more information about supported operating systems, see [Operating Systems](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html)For more information about how to use custom AMIs with AWS OpsWorks Stacks, see [Using Custom AMIs](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
     */
    val os: kotlin.String? = builder.os
    /**
     * The instance root device type. For more information, see [Storage for the Root Device](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
     */
    val rootDeviceType: aws.sdk.kotlin.services.opsworks.model.RootDeviceType? = builder.rootDeviceType
    /**
     * The instance's Amazon EC2 key-pair name.
     */
    val sshKeyName: kotlin.String? = builder.sshKeyName
    /**
     * The stack ID.
     */
    val stackId: kotlin.String? = builder.stackId
    /**
     * The ID of the instance's subnet. If the stack is running in a VPC, you can use this parameter to override the stack's default subnet ID value and direct AWS OpsWorks Stacks to launch the instance in a different subnet.
     */
    val subnetId: kotlin.String? = builder.subnetId
    /**
     * The instance's tenancy option. The default option is no tenancy, or if the instance is running in a VPC, inherit tenancy settings from the VPC. The following are valid values for this parameter: `dedicated`, `default`, or `host`. Because there are costs associated with changes in tenancy options, we recommend that you research tenancy options before choosing them for your instances. For more information about dedicated hosts, see [Dedicated Hosts Overview](http://aws.amazon.com/ec2/dedicated-hosts/) and [Amazon EC2 Dedicated Hosts](http://aws.amazon.com/ec2/dedicated-hosts/). For more information about dedicated instances, see [Dedicated Instances](https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/dedicated-instance.html) and [Amazon EC2 Dedicated Instances](http://aws.amazon.com/ec2/purchasing-options/dedicated-instances/).
     */
    val tenancy: kotlin.String? = builder.tenancy
    /**
     * The instance's virtualization type, `paravirtual` or `hvm`.
     */
    val virtualizationType: kotlin.String? = builder.virtualizationType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.CreateInstanceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateInstanceRequest(")
        append("agentVersion=$agentVersion,")
        append("amiId=$amiId,")
        append("architecture=$architecture,")
        append("autoScalingType=$autoScalingType,")
        append("availabilityZone=$availabilityZone,")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("ebsOptimized=$ebsOptimized,")
        append("hostname=$hostname,")
        append("installUpdatesOnBoot=$installUpdatesOnBoot,")
        append("instanceType=$instanceType,")
        append("layerIds=$layerIds,")
        append("os=$os,")
        append("rootDeviceType=$rootDeviceType,")
        append("sshKeyName=$sshKeyName,")
        append("stackId=$stackId,")
        append("subnetId=$subnetId,")
        append("tenancy=$tenancy,")
        append("virtualizationType=$virtualizationType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentVersion?.hashCode() ?: 0
        result = 31 * result + (amiId?.hashCode() ?: 0)
        result = 31 * result + (architecture?.hashCode() ?: 0)
        result = 31 * result + (autoScalingType?.hashCode() ?: 0)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (blockDeviceMappings?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (hostname?.hashCode() ?: 0)
        result = 31 * result + (installUpdatesOnBoot?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (layerIds?.hashCode() ?: 0)
        result = 31 * result + (os?.hashCode() ?: 0)
        result = 31 * result + (rootDeviceType?.hashCode() ?: 0)
        result = 31 * result + (sshKeyName?.hashCode() ?: 0)
        result = 31 * result + (stackId?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (tenancy?.hashCode() ?: 0)
        result = 31 * result + (virtualizationType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateInstanceRequest

        if (agentVersion != other.agentVersion) return false
        if (amiId != other.amiId) return false
        if (architecture != other.architecture) return false
        if (autoScalingType != other.autoScalingType) return false
        if (availabilityZone != other.availabilityZone) return false
        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (hostname != other.hostname) return false
        if (installUpdatesOnBoot != other.installUpdatesOnBoot) return false
        if (instanceType != other.instanceType) return false
        if (layerIds != other.layerIds) return false
        if (os != other.os) return false
        if (rootDeviceType != other.rootDeviceType) return false
        if (sshKeyName != other.sshKeyName) return false
        if (stackId != other.stackId) return false
        if (subnetId != other.subnetId) return false
        if (tenancy != other.tenancy) return false
        if (virtualizationType != other.virtualizationType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.CreateInstanceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The default AWS OpsWorks Stacks agent version. You have the following options:
         * + `INHERIT` - Use the stack's default agent version setting.
         * + *version_number* - Use the specified agent version. This value overrides the stack's default setting. To update the agent version, edit the instance configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the instance.
         *
         * The default setting is `INHERIT`. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call DescribeAgentVersions. AgentVersion cannot be set to Chef 12.2.
         */
        var agentVersion: kotlin.String? = null
        /**
         * A custom AMI ID to be used to create the instance. The AMI should be based on one of the supported operating systems. For more information, see [Using Custom AMIs](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
         *
         * If you specify a custom AMI, you must set `Os` to `Custom`.
         */
        var amiId: kotlin.String? = null
        /**
         * The instance architecture. The default option is `x86_64`. Instance types do not necessarily support both architectures. For a list of the architectures that are supported by the different instance types, see [Instance Families and Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html).
         */
        var architecture: aws.sdk.kotlin.services.opsworks.model.Architecture? = null
        /**
         * For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
         */
        var autoScalingType: aws.sdk.kotlin.services.opsworks.model.AutoScalingType? = null
        /**
         * The instance Availability Zone. For more information, see [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html).
         */
        var availabilityZone: kotlin.String? = null
        /**
         * An array of `BlockDeviceMapping` objects that specify the instance's block devices. For more information, see [Block Device Mapping](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html). Note that block device mappings are not supported for custom AMIs.
         */
        var blockDeviceMappings: List<BlockDeviceMapping>? = null
        /**
         * Whether to create an Amazon EBS-optimized instance.
         */
        var ebsOptimized: kotlin.Boolean? = null
        /**
         * The instance host name.
         */
        var hostname: kotlin.String? = null
        /**
         * Whether to install operating system and package updates when the instance boots. The default value is `true`. To control when updates are installed, set this value to `false`. You must then update your instances manually by using CreateDeployment to run the `update_dependencies` stack command or by manually running `yum` (Amazon Linux) or `apt-get` (Ubuntu) on the instances.
         *
         * We strongly recommend using the default value of `true` to ensure that your instances have the latest security updates.
         */
        var installUpdatesOnBoot: kotlin.Boolean? = null
        /**
         * The instance type, such as `t2.micro`. For a list of supported instance types, open the stack in the console, choose **Instances**, and choose **+ Instance**. The **Size** list contains the currently supported types. For more information, see [Instance Families and Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html). The parameter values that you use to specify the various types are in the **API Name** column of the **Available Instance Types** table.
         */
        var instanceType: kotlin.String? = null
        /**
         * An array that contains the instance's layer IDs.
         */
        var layerIds: List<String>? = null
        /**
         * The instance's operating system, which must be set to one of the following.
         * + A supported Linux operating system: An Amazon Linux version, such as `Amazon Linux 2018.03`, `Amazon Linux 2017.09`, `Amazon Linux 2017.03`, `Amazon Linux 2016.09`, `Amazon Linux 2016.03`, `Amazon Linux 2015.09`, or `Amazon Linux 2015.03`.
         * + A supported Ubuntu operating system, such as `Ubuntu 16.04 LTS`, `Ubuntu 14.04 LTS`, or `Ubuntu 12.04 LTS`.
         * + `CentOS Linux 7`
         * + `Red Hat Enterprise Linux 7`
         * + A supported Windows operating system, such as `Microsoft Windows Server 2012 R2 Base`, `Microsoft Windows Server 2012 R2 with SQL Server Express`, `Microsoft Windows Server 2012 R2 with SQL Server Standard`, or `Microsoft Windows Server 2012 R2 with SQL Server Web`.
         * + A custom AMI: `Custom`.
         *
         * For more information about the supported operating systems, see [AWS OpsWorks Stacks Operating Systems](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
         *
         * The default option is the current Amazon Linux version. If you set this parameter to `Custom`, you must use the CreateInstance action's AmiId parameter to specify the custom AMI that you want to use. Block device mappings are not supported if the value is `Custom`. For more information about supported operating systems, see [Operating Systems](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html)For more information about how to use custom AMIs with AWS OpsWorks Stacks, see [Using Custom AMIs](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
         */
        var os: kotlin.String? = null
        /**
         * The instance root device type. For more information, see [Storage for the Root Device](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
         */
        var rootDeviceType: aws.sdk.kotlin.services.opsworks.model.RootDeviceType? = null
        /**
         * The instance's Amazon EC2 key-pair name.
         */
        var sshKeyName: kotlin.String? = null
        /**
         * The stack ID.
         */
        var stackId: kotlin.String? = null
        /**
         * The ID of the instance's subnet. If the stack is running in a VPC, you can use this parameter to override the stack's default subnet ID value and direct AWS OpsWorks Stacks to launch the instance in a different subnet.
         */
        var subnetId: kotlin.String? = null
        /**
         * The instance's tenancy option. The default option is no tenancy, or if the instance is running in a VPC, inherit tenancy settings from the VPC. The following are valid values for this parameter: `dedicated`, `default`, or `host`. Because there are costs associated with changes in tenancy options, we recommend that you research tenancy options before choosing them for your instances. For more information about dedicated hosts, see [Dedicated Hosts Overview](http://aws.amazon.com/ec2/dedicated-hosts/) and [Amazon EC2 Dedicated Hosts](http://aws.amazon.com/ec2/dedicated-hosts/). For more information about dedicated instances, see [Dedicated Instances](https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/dedicated-instance.html) and [Amazon EC2 Dedicated Instances](http://aws.amazon.com/ec2/purchasing-options/dedicated-instances/).
         */
        var tenancy: kotlin.String? = null
        /**
         * The instance's virtualization type, `paravirtual` or `hvm`.
         */
        var virtualizationType: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.CreateInstanceRequest) : this() {
            this.agentVersion = x.agentVersion
            this.amiId = x.amiId
            this.architecture = x.architecture
            this.autoScalingType = x.autoScalingType
            this.availabilityZone = x.availabilityZone
            this.blockDeviceMappings = x.blockDeviceMappings
            this.ebsOptimized = x.ebsOptimized
            this.hostname = x.hostname
            this.installUpdatesOnBoot = x.installUpdatesOnBoot
            this.instanceType = x.instanceType
            this.layerIds = x.layerIds
            this.os = x.os
            this.rootDeviceType = x.rootDeviceType
            this.sshKeyName = x.sshKeyName
            this.stackId = x.stackId
            this.subnetId = x.subnetId
            this.tenancy = x.tenancy
            this.virtualizationType = x.virtualizationType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.CreateInstanceRequest = CreateInstanceRequest(this)
    }
}
