// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



class CreateLayerRequest private constructor(builder: Builder) {
    /**
     * One or more user-defined key-value pairs to be added to the stack attributes.
     *
     * To create a cluster layer, set the `EcsClusterArn` attribute to the cluster's ARN.
     */
    val attributes: Map<String, String>? = builder.attributes
    /**
     * Whether to automatically assign an [Elastic IP address](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) to the layer's instances. For more information, see [How to Edit a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
     */
    val autoAssignElasticIps: kotlin.Boolean? = builder.autoAssignElasticIps
    /**
     * For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances. For more information, see [How to Edit a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
     */
    val autoAssignPublicIps: kotlin.Boolean? = builder.autoAssignPublicIps
    /**
     * Specifies CloudWatch Logs configuration options for the layer. For more information, see CloudWatchLogsLogStream.
     */
    val cloudWatchLogsConfiguration: aws.sdk.kotlin.services.opsworks.model.CloudWatchLogsConfiguration? = builder.cloudWatchLogsConfiguration
    /**
     * The ARN of an IAM profile to be used for the layer's EC2 instances. For more information about IAM ARNs, see [Using Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
     */
    val customInstanceProfileArn: kotlin.String? = builder.customInstanceProfileArn
    /**
     * A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on the layer's instances. For more information, see [ Using Custom JSON](https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html). This feature is supported as of version 1.7.42 of the AWS CLI.
     */
    val customJson: kotlin.String? = builder.customJson
    /**
     * A `LayerCustomRecipes` object that specifies the layer custom recipes.
     */
    val customRecipes: aws.sdk.kotlin.services.opsworks.model.Recipes? = builder.customRecipes
    /**
     * An array containing the layer custom security group IDs.
     */
    val customSecurityGroupIds: List<String>? = builder.customSecurityGroupIds
    /**
     * Whether to disable auto healing for the layer.
     */
    val enableAutoHealing: kotlin.Boolean? = builder.enableAutoHealing
    /**
     * Whether to install operating system and package updates when the instance boots. The default value is `true`. To control when updates are installed, set this value to `false`. You must then update your instances manually by using CreateDeployment to run the `update_dependencies` stack command or by manually running `yum` (Amazon Linux) or `apt-get` (Ubuntu) on the instances.
     *
     * To ensure that your instances have the latest security updates, we strongly recommend using the default value of `true`.
     */
    val installUpdatesOnBoot: kotlin.Boolean? = builder.installUpdatesOnBoot
    /**
     * A `LifeCycleEventConfiguration` object that you can use to configure the Shutdown event to specify an execution timeout and enable or disable Elastic Load Balancer connection draining.
     */
    val lifecycleEventConfiguration: aws.sdk.kotlin.services.opsworks.model.LifecycleEventConfiguration? = builder.lifecycleEventConfiguration
    /**
     * The layer name, which is used by the console.
     */
    val name: kotlin.String? = builder.name
    /**
     * An array of `Package` objects that describes the layer packages.
     */
    val packages: List<String>? = builder.packages
    /**
     * For custom layers only, use this parameter to specify the layer's short name, which is used internally by AWS OpsWorks Stacks and by Chef recipes. The short name is also used as the name for the directory where your app files are installed. It can have a maximum of 200 characters, which are limited to the alphanumeric characters, '-', '_', and '.'.
     *
     * The built-in layers' short names are defined by AWS OpsWorks Stacks. For more information, see the [Layer Reference](https://docs.aws.amazon.com/opsworks/latest/userguide/layers.html).
     */
    val shortname: kotlin.String? = builder.shortname
    /**
     * The layer stack ID.
     */
    val stackId: kotlin.String? = builder.stackId
    /**
     * The layer type. A stack cannot have more than one built-in layer of the same type. It can have any number of custom layers. Built-in layers are not available in Chef 12 stacks.
     */
    val type: aws.sdk.kotlin.services.opsworks.model.LayerType? = builder.type
    /**
     * Whether to use Amazon EBS-optimized instances.
     */
    val useEbsOptimizedInstances: kotlin.Boolean? = builder.useEbsOptimizedInstances
    /**
     * A `VolumeConfigurations` object that describes the layer's Amazon EBS volumes.
     */
    val volumeConfigurations: List<VolumeConfiguration>? = builder.volumeConfigurations

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.CreateLayerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLayerRequest(")
        append("attributes=$attributes,")
        append("autoAssignElasticIps=$autoAssignElasticIps,")
        append("autoAssignPublicIps=$autoAssignPublicIps,")
        append("cloudWatchLogsConfiguration=$cloudWatchLogsConfiguration,")
        append("customInstanceProfileArn=$customInstanceProfileArn,")
        append("customJson=$customJson,")
        append("customRecipes=$customRecipes,")
        append("customSecurityGroupIds=$customSecurityGroupIds,")
        append("enableAutoHealing=$enableAutoHealing,")
        append("installUpdatesOnBoot=$installUpdatesOnBoot,")
        append("lifecycleEventConfiguration=$lifecycleEventConfiguration,")
        append("name=$name,")
        append("packages=$packages,")
        append("shortname=$shortname,")
        append("stackId=$stackId,")
        append("type=$type,")
        append("useEbsOptimizedInstances=$useEbsOptimizedInstances,")
        append("volumeConfigurations=$volumeConfigurations)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (autoAssignElasticIps?.hashCode() ?: 0)
        result = 31 * result + (autoAssignPublicIps?.hashCode() ?: 0)
        result = 31 * result + (cloudWatchLogsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (customInstanceProfileArn?.hashCode() ?: 0)
        result = 31 * result + (customJson?.hashCode() ?: 0)
        result = 31 * result + (customRecipes?.hashCode() ?: 0)
        result = 31 * result + (customSecurityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (enableAutoHealing?.hashCode() ?: 0)
        result = 31 * result + (installUpdatesOnBoot?.hashCode() ?: 0)
        result = 31 * result + (lifecycleEventConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (packages?.hashCode() ?: 0)
        result = 31 * result + (shortname?.hashCode() ?: 0)
        result = 31 * result + (stackId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (useEbsOptimizedInstances?.hashCode() ?: 0)
        result = 31 * result + (volumeConfigurations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLayerRequest

        if (attributes != other.attributes) return false
        if (autoAssignElasticIps != other.autoAssignElasticIps) return false
        if (autoAssignPublicIps != other.autoAssignPublicIps) return false
        if (cloudWatchLogsConfiguration != other.cloudWatchLogsConfiguration) return false
        if (customInstanceProfileArn != other.customInstanceProfileArn) return false
        if (customJson != other.customJson) return false
        if (customRecipes != other.customRecipes) return false
        if (customSecurityGroupIds != other.customSecurityGroupIds) return false
        if (enableAutoHealing != other.enableAutoHealing) return false
        if (installUpdatesOnBoot != other.installUpdatesOnBoot) return false
        if (lifecycleEventConfiguration != other.lifecycleEventConfiguration) return false
        if (name != other.name) return false
        if (packages != other.packages) return false
        if (shortname != other.shortname) return false
        if (stackId != other.stackId) return false
        if (type != other.type) return false
        if (useEbsOptimizedInstances != other.useEbsOptimizedInstances) return false
        if (volumeConfigurations != other.volumeConfigurations) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.CreateLayerRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * One or more user-defined key-value pairs to be added to the stack attributes.
         *
         * To create a cluster layer, set the `EcsClusterArn` attribute to the cluster's ARN.
         */
        var attributes: Map<String, String>? = null
        /**
         * Whether to automatically assign an [Elastic IP address](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) to the layer's instances. For more information, see [How to Edit a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
         */
        var autoAssignElasticIps: kotlin.Boolean? = null
        /**
         * For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances. For more information, see [How to Edit a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
         */
        var autoAssignPublicIps: kotlin.Boolean? = null
        /**
         * Specifies CloudWatch Logs configuration options for the layer. For more information, see CloudWatchLogsLogStream.
         */
        var cloudWatchLogsConfiguration: aws.sdk.kotlin.services.opsworks.model.CloudWatchLogsConfiguration? = null
        /**
         * The ARN of an IAM profile to be used for the layer's EC2 instances. For more information about IAM ARNs, see [Using Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
         */
        var customInstanceProfileArn: kotlin.String? = null
        /**
         * A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on the layer's instances. For more information, see [ Using Custom JSON](https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html). This feature is supported as of version 1.7.42 of the AWS CLI.
         */
        var customJson: kotlin.String? = null
        /**
         * A `LayerCustomRecipes` object that specifies the layer custom recipes.
         */
        var customRecipes: aws.sdk.kotlin.services.opsworks.model.Recipes? = null
        /**
         * An array containing the layer custom security group IDs.
         */
        var customSecurityGroupIds: List<String>? = null
        /**
         * Whether to disable auto healing for the layer.
         */
        var enableAutoHealing: kotlin.Boolean? = null
        /**
         * Whether to install operating system and package updates when the instance boots. The default value is `true`. To control when updates are installed, set this value to `false`. You must then update your instances manually by using CreateDeployment to run the `update_dependencies` stack command or by manually running `yum` (Amazon Linux) or `apt-get` (Ubuntu) on the instances.
         *
         * To ensure that your instances have the latest security updates, we strongly recommend using the default value of `true`.
         */
        var installUpdatesOnBoot: kotlin.Boolean? = null
        /**
         * A `LifeCycleEventConfiguration` object that you can use to configure the Shutdown event to specify an execution timeout and enable or disable Elastic Load Balancer connection draining.
         */
        var lifecycleEventConfiguration: aws.sdk.kotlin.services.opsworks.model.LifecycleEventConfiguration? = null
        /**
         * The layer name, which is used by the console.
         */
        var name: kotlin.String? = null
        /**
         * An array of `Package` objects that describes the layer packages.
         */
        var packages: List<String>? = null
        /**
         * For custom layers only, use this parameter to specify the layer's short name, which is used internally by AWS OpsWorks Stacks and by Chef recipes. The short name is also used as the name for the directory where your app files are installed. It can have a maximum of 200 characters, which are limited to the alphanumeric characters, '-', '_', and '.'.
         *
         * The built-in layers' short names are defined by AWS OpsWorks Stacks. For more information, see the [Layer Reference](https://docs.aws.amazon.com/opsworks/latest/userguide/layers.html).
         */
        var shortname: kotlin.String? = null
        /**
         * The layer stack ID.
         */
        var stackId: kotlin.String? = null
        /**
         * The layer type. A stack cannot have more than one built-in layer of the same type. It can have any number of custom layers. Built-in layers are not available in Chef 12 stacks.
         */
        var type: aws.sdk.kotlin.services.opsworks.model.LayerType? = null
        /**
         * Whether to use Amazon EBS-optimized instances.
         */
        var useEbsOptimizedInstances: kotlin.Boolean? = null
        /**
         * A `VolumeConfigurations` object that describes the layer's Amazon EBS volumes.
         */
        var volumeConfigurations: List<VolumeConfiguration>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.CreateLayerRequest) : this() {
            this.attributes = x.attributes
            this.autoAssignElasticIps = x.autoAssignElasticIps
            this.autoAssignPublicIps = x.autoAssignPublicIps
            this.cloudWatchLogsConfiguration = x.cloudWatchLogsConfiguration
            this.customInstanceProfileArn = x.customInstanceProfileArn
            this.customJson = x.customJson
            this.customRecipes = x.customRecipes
            this.customSecurityGroupIds = x.customSecurityGroupIds
            this.enableAutoHealing = x.enableAutoHealing
            this.installUpdatesOnBoot = x.installUpdatesOnBoot
            this.lifecycleEventConfiguration = x.lifecycleEventConfiguration
            this.name = x.name
            this.packages = x.packages
            this.shortname = x.shortname
            this.stackId = x.stackId
            this.type = x.type
            this.useEbsOptimizedInstances = x.useEbsOptimizedInstances
            this.volumeConfigurations = x.volumeConfigurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.CreateLayerRequest = CreateLayerRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.opsworks.model.CloudWatchLogsConfiguration] inside the given [block]
         */
        fun cloudWatchLogsConfiguration(block: aws.sdk.kotlin.services.opsworks.model.CloudWatchLogsConfiguration.Builder.() -> kotlin.Unit) {
            this.cloudWatchLogsConfiguration = aws.sdk.kotlin.services.opsworks.model.CloudWatchLogsConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opsworks.model.Recipes] inside the given [block]
         */
        fun customRecipes(block: aws.sdk.kotlin.services.opsworks.model.Recipes.Builder.() -> kotlin.Unit) {
            this.customRecipes = aws.sdk.kotlin.services.opsworks.model.Recipes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opsworks.model.LifecycleEventConfiguration] inside the given [block]
         */
        fun lifecycleEventConfiguration(block: aws.sdk.kotlin.services.opsworks.model.LifecycleEventConfiguration.Builder.() -> kotlin.Unit) {
            this.lifecycleEventConfiguration = aws.sdk.kotlin.services.opsworks.model.LifecycleEventConfiguration.invoke(block)
        }
    }
}
