// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



/**
 * Describes a deployment of a stack or app.
 */
class Deployment private constructor(builder: Builder) {
    /**
     * The app ID.
     */
    val appId: kotlin.String? = builder.appId
    /**
     * Used to specify a stack or deployment command.
     */
    val command: aws.sdk.kotlin.services.opsworks.model.DeploymentCommand? = builder.command
    /**
     * A user-defined comment.
     */
    val comment: kotlin.String? = builder.comment
    /**
     * Date when the deployment completed.
     */
    val completedAt: kotlin.String? = builder.completedAt
    /**
     * Date when the deployment was created.
     */
    val createdAt: kotlin.String? = builder.createdAt
    /**
     * A string that contains user-defined custom JSON. It can be used to override the corresponding default stack configuration attribute values for stack or to pass data to recipes. The string should be in the following format:
     *
     * `"{\"key1\": \"value1\", \"key2\": \"value2\",...}"`
     *
     * For more information on custom JSON, see [Use Custom JSON to Modify the Stack Configuration Attributes](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html).
     */
    val customJson: kotlin.String? = builder.customJson
    /**
     * The deployment ID.
     */
    val deploymentId: kotlin.String? = builder.deploymentId
    /**
     * The deployment duration.
     */
    val duration: kotlin.Int? = builder.duration
    /**
     * The user's IAM ARN.
     */
    val iamUserArn: kotlin.String? = builder.iamUserArn
    /**
     * The IDs of the target instances.
     */
    val instanceIds: List<String>? = builder.instanceIds
    /**
     * The stack ID.
     */
    val stackId: kotlin.String? = builder.stackId
    /**
     * The deployment status:
     * + running
     * + successful
     * + failed
     */
    val status: kotlin.String? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.Deployment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Deployment(")
        append("appId=$appId,")
        append("command=$command,")
        append("comment=$comment,")
        append("completedAt=$completedAt,")
        append("createdAt=$createdAt,")
        append("customJson=$customJson,")
        append("deploymentId=$deploymentId,")
        append("duration=$duration,")
        append("iamUserArn=$iamUserArn,")
        append("instanceIds=$instanceIds,")
        append("stackId=$stackId,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appId?.hashCode() ?: 0
        result = 31 * result + (command?.hashCode() ?: 0)
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (completedAt?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (customJson?.hashCode() ?: 0)
        result = 31 * result + (deploymentId?.hashCode() ?: 0)
        result = 31 * result + (duration ?: 0)
        result = 31 * result + (iamUserArn?.hashCode() ?: 0)
        result = 31 * result + (instanceIds?.hashCode() ?: 0)
        result = 31 * result + (stackId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Deployment

        if (appId != other.appId) return false
        if (command != other.command) return false
        if (comment != other.comment) return false
        if (completedAt != other.completedAt) return false
        if (createdAt != other.createdAt) return false
        if (customJson != other.customJson) return false
        if (deploymentId != other.deploymentId) return false
        if (duration != other.duration) return false
        if (iamUserArn != other.iamUserArn) return false
        if (instanceIds != other.instanceIds) return false
        if (stackId != other.stackId) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.Deployment = Builder(this).apply(block).build()

    class Builder {
        /**
         * The app ID.
         */
        var appId: kotlin.String? = null
        /**
         * Used to specify a stack or deployment command.
         */
        var command: aws.sdk.kotlin.services.opsworks.model.DeploymentCommand? = null
        /**
         * A user-defined comment.
         */
        var comment: kotlin.String? = null
        /**
         * Date when the deployment completed.
         */
        var completedAt: kotlin.String? = null
        /**
         * Date when the deployment was created.
         */
        var createdAt: kotlin.String? = null
        /**
         * A string that contains user-defined custom JSON. It can be used to override the corresponding default stack configuration attribute values for stack or to pass data to recipes. The string should be in the following format:
         *
         * `"{\"key1\": \"value1\", \"key2\": \"value2\",...}"`
         *
         * For more information on custom JSON, see [Use Custom JSON to Modify the Stack Configuration Attributes](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html).
         */
        var customJson: kotlin.String? = null
        /**
         * The deployment ID.
         */
        var deploymentId: kotlin.String? = null
        /**
         * The deployment duration.
         */
        var duration: kotlin.Int? = null
        /**
         * The user's IAM ARN.
         */
        var iamUserArn: kotlin.String? = null
        /**
         * The IDs of the target instances.
         */
        var instanceIds: List<String>? = null
        /**
         * The stack ID.
         */
        var stackId: kotlin.String? = null
        /**
         * The deployment status:
         * + running
         * + successful
         * + failed
         */
        var status: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.Deployment) : this() {
            this.appId = x.appId
            this.command = x.command
            this.comment = x.comment
            this.completedAt = x.completedAt
            this.createdAt = x.createdAt
            this.customJson = x.customJson
            this.deploymentId = x.deploymentId
            this.duration = x.duration
            this.iamUserArn = x.iamUserArn
            this.instanceIds = x.instanceIds
            this.stackId = x.stackId
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.Deployment = Deployment(this)

        /**
         * construct an [aws.sdk.kotlin.services.opsworks.model.DeploymentCommand] inside the given [block]
         */
        fun command(block: aws.sdk.kotlin.services.opsworks.model.DeploymentCommand.Builder.() -> kotlin.Unit) {
            this.command = aws.sdk.kotlin.services.opsworks.model.DeploymentCommand.invoke(block)
        }
    }
}
