// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



/**
 * Used to specify a stack or deployment command.
 */
class DeploymentCommand private constructor(builder: Builder) {
    /**
     * The arguments of those commands that take arguments. It should be set to a JSON object with the following format:
     *
     * `{"arg_name1" : ["value1", "value2", ...], "arg_name2" : ["value1", "value2", ...], ...}`
     *
     * The `update_dependencies` command takes two arguments:
     * + `upgrade_os_to` - Specifies the desired Amazon Linux version for instances whose OS you want to upgrade, such as `Amazon Linux 2016.09`. You must also set the `allow_reboot` argument to true.
     * + `allow_reboot` - Specifies whether to allow AWS OpsWorks Stacks to reboot the instances if necessary, after installing the updates. This argument can be set to either `true` or `false`. The default value is `false`.
     *
     * For example, to upgrade an instance to Amazon Linux 2016.09, set `Args` to the following.
     *
     * ` { "upgrade_os_to":["Amazon Linux 2016.09"], "allow_reboot":["true"] } `
     */
    val args: Map<String, List<String>>? = builder.args
    /**
     * Specifies the operation. You can specify only one command.
     *
     * For stacks, the following commands are available:
     * + `execute_recipes`: Execute one or more recipes. To specify the recipes, set an `Args` parameter named `recipes` to the list of recipes to be executed. For example, to execute `phpapp::appsetup`, set `Args` to `{"recipes":["phpapp::appsetup"]}`.
     * + `install_dependencies`: Install the stack's dependencies.
     * + `update_custom_cookbooks`: Update the stack's custom cookbooks.
     * + `update_dependencies`: Update the stack's dependencies.
     *
     * The update_dependencies and install_dependencies commands are supported only for Linux instances. You can run the commands successfully on Windows instances, but they do nothing.
     *
     * For apps, the following commands are available:
     * + `deploy`: Deploy an app. Ruby on Rails apps have an optional `Args` parameter named `migrate`. Set `Args` to {"migrate":&#91;"true"&#93;} to migrate the database. The default setting is {"migrate":&#91;"false"&#93;}.
     * + `rollback` Roll the app back to the previous version. When you update an app, AWS OpsWorks Stacks stores the previous version, up to a maximum of five versions. You can use this command to roll an app back as many as four versions.
     * + `start`: Start the app's web or application server.
     * + `stop`: Stop the app's web or application server.
     * + `restart`: Restart the app's web or application server.
     * + `undeploy`: Undeploy the app.
     */
    val name: aws.sdk.kotlin.services.opsworks.model.DeploymentCommandName? = builder.name

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.DeploymentCommand = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentCommand(")
        append("args=$args,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = args?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeploymentCommand

        if (args != other.args) return false
        if (name != other.name) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.DeploymentCommand = Builder(this).apply(block).build()

    class Builder {
        /**
         * The arguments of those commands that take arguments. It should be set to a JSON object with the following format:
         *
         * `{"arg_name1" : ["value1", "value2", ...], "arg_name2" : ["value1", "value2", ...], ...}`
         *
         * The `update_dependencies` command takes two arguments:
         * + `upgrade_os_to` - Specifies the desired Amazon Linux version for instances whose OS you want to upgrade, such as `Amazon Linux 2016.09`. You must also set the `allow_reboot` argument to true.
         * + `allow_reboot` - Specifies whether to allow AWS OpsWorks Stacks to reboot the instances if necessary, after installing the updates. This argument can be set to either `true` or `false`. The default value is `false`.
         *
         * For example, to upgrade an instance to Amazon Linux 2016.09, set `Args` to the following.
         *
         * ` { "upgrade_os_to":["Amazon Linux 2016.09"], "allow_reboot":["true"] } `
         */
        var args: Map<String, List<String>>? = null
        /**
         * Specifies the operation. You can specify only one command.
         *
         * For stacks, the following commands are available:
         * + `execute_recipes`: Execute one or more recipes. To specify the recipes, set an `Args` parameter named `recipes` to the list of recipes to be executed. For example, to execute `phpapp::appsetup`, set `Args` to `{"recipes":["phpapp::appsetup"]}`.
         * + `install_dependencies`: Install the stack's dependencies.
         * + `update_custom_cookbooks`: Update the stack's custom cookbooks.
         * + `update_dependencies`: Update the stack's dependencies.
         *
         * The update_dependencies and install_dependencies commands are supported only for Linux instances. You can run the commands successfully on Windows instances, but they do nothing.
         *
         * For apps, the following commands are available:
         * + `deploy`: Deploy an app. Ruby on Rails apps have an optional `Args` parameter named `migrate`. Set `Args` to {"migrate":&#91;"true"&#93;} to migrate the database. The default setting is {"migrate":&#91;"false"&#93;}.
         * + `rollback` Roll the app back to the previous version. When you update an app, AWS OpsWorks Stacks stores the previous version, up to a maximum of five versions. You can use this command to roll an app back as many as four versions.
         * + `start`: Start the app's web or application server.
         * + `stop`: Stop the app's web or application server.
         * + `restart`: Restart the app's web or application server.
         * + `undeploy`: Undeploy the app.
         */
        var name: aws.sdk.kotlin.services.opsworks.model.DeploymentCommandName? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.DeploymentCommand) : this() {
            this.args = x.args
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.DeploymentCommand = DeploymentCommand(this)
    }
}
