// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



/**
 * Describes an Amazon EBS volume. This data type maps directly to the Amazon EC2 [EbsBlockDevice](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html) data type.
 */
class EbsBlockDevice private constructor(builder: Builder) {
    /**
     * Whether the volume is deleted on instance termination.
     */
    val deleteOnTermination: kotlin.Boolean? = builder.deleteOnTermination
    /**
     * The number of I/O operations per second (IOPS) that the volume supports. For more information, see [EbsBlockDevice](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html).
     */
    val iops: kotlin.Int? = builder.iops
    /**
     * The snapshot ID.
     */
    val snapshotId: kotlin.String? = builder.snapshotId
    /**
     * The volume size, in GiB. For more information, see [EbsBlockDevice](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html).
     */
    val volumeSize: kotlin.Int? = builder.volumeSize
    /**
     * The volume type. `gp2` for General Purpose (SSD) volumes, `io1` for Provisioned IOPS (SSD) volumes, `st1` for Throughput Optimized hard disk drives (HDD), `sc1` for Cold HDD,and `standard` for Magnetic volumes.
     *
     * If you specify the `io1` volume type, you must also specify a value for the `Iops` attribute. The maximum ratio of provisioned IOPS to requested volume size (in GiB) is 50:1. AWS uses the default volume size (in GiB) specified in the AMI attributes to set IOPS to 50 x (volume size).
     */
    val volumeType: aws.sdk.kotlin.services.opsworks.model.VolumeType? = builder.volumeType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.EbsBlockDevice = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EbsBlockDevice(")
        append("deleteOnTermination=$deleteOnTermination,")
        append("iops=$iops,")
        append("snapshotId=$snapshotId,")
        append("volumeSize=$volumeSize,")
        append("volumeType=$volumeType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deleteOnTermination?.hashCode() ?: 0
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (volumeSize ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EbsBlockDevice

        if (deleteOnTermination != other.deleteOnTermination) return false
        if (iops != other.iops) return false
        if (snapshotId != other.snapshotId) return false
        if (volumeSize != other.volumeSize) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.EbsBlockDevice = Builder(this).apply(block).build()

    class Builder {
        /**
         * Whether the volume is deleted on instance termination.
         */
        var deleteOnTermination: kotlin.Boolean? = null
        /**
         * The number of I/O operations per second (IOPS) that the volume supports. For more information, see [EbsBlockDevice](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html).
         */
        var iops: kotlin.Int? = null
        /**
         * The snapshot ID.
         */
        var snapshotId: kotlin.String? = null
        /**
         * The volume size, in GiB. For more information, see [EbsBlockDevice](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html).
         */
        var volumeSize: kotlin.Int? = null
        /**
         * The volume type. `gp2` for General Purpose (SSD) volumes, `io1` for Provisioned IOPS (SSD) volumes, `st1` for Throughput Optimized hard disk drives (HDD), `sc1` for Cold HDD,and `standard` for Magnetic volumes.
         *
         * If you specify the `io1` volume type, you must also specify a value for the `Iops` attribute. The maximum ratio of provisioned IOPS to requested volume size (in GiB) is 50:1. AWS uses the default volume size (in GiB) specified in the AMI attributes to set IOPS to 50 x (volume size).
         */
        var volumeType: aws.sdk.kotlin.services.opsworks.model.VolumeType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.EbsBlockDevice) : this() {
            this.deleteOnTermination = x.deleteOnTermination
            this.iops = x.iops
            this.snapshotId = x.snapshotId
            this.volumeSize = x.volumeSize
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.EbsBlockDevice = EbsBlockDevice(this)
    }
}
