// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



/**
 * Represents an app's environment variable.
 */
class EnvironmentVariable private constructor(builder: Builder) {
    /**
     * (Required) The environment variable's name, which can consist of up to 64 characters and must be specified. The name can contain upper- and lowercase letters, numbers, and underscores (_), but it must start with a letter or underscore.
     */
    val key: kotlin.String? = builder.key
    /**
     * (Optional) Whether the variable's value will be returned by the DescribeApps action. To conceal an environment variable's value, set `Secure` to `true`. `DescribeApps` then returns `*****FILTERED*****` instead of the actual value. The default value for `Secure` is `false`.
     */
    val secure: kotlin.Boolean? = builder.secure
    /**
     * (Optional) The environment variable's value, which can be left empty. If you specify a value, it can contain up to 256 characters, which must all be printable.
     */
    val value: kotlin.String? = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.EnvironmentVariable = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnvironmentVariable(")
        append("key=$key,")
        append("secure=$secure,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = key?.hashCode() ?: 0
        result = 31 * result + (secure?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnvironmentVariable

        if (key != other.key) return false
        if (secure != other.secure) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.EnvironmentVariable = Builder(this).apply(block).build()

    class Builder {
        /**
         * (Required) The environment variable's name, which can consist of up to 64 characters and must be specified. The name can contain upper- and lowercase letters, numbers, and underscores (_), but it must start with a letter or underscore.
         */
        var key: kotlin.String? = null
        /**
         * (Optional) Whether the variable's value will be returned by the DescribeApps action. To conceal an environment variable's value, set `Secure` to `true`. `DescribeApps` then returns `*****FILTERED*****` instead of the actual value. The default value for `Secure` is `false`.
         */
        var secure: kotlin.Boolean? = null
        /**
         * (Optional) The environment variable's value, which can be left empty. If you specify a value, it can contain up to 256 characters, which must all be printable.
         */
        var value: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.EnvironmentVariable) : this() {
            this.key = x.key
            this.secure = x.secure
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.EnvironmentVariable = EnvironmentVariable(this)
    }
}
