// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



/**
 * Describes an instance.
 */
class Instance private constructor(builder: Builder) {
    /**
     * The agent version. This parameter is set to `INHERIT` if the instance inherits the default stack setting or to a a version number for a fixed agent version.
     */
    val agentVersion: kotlin.String? = builder.agentVersion
    /**
     * A custom AMI ID to be used to create the instance. For more information, see [Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html)
     */
    val amiId: kotlin.String? = builder.amiId
    /**
     * The instance architecture: "i386" or "x86_64".
     */
    val architecture: aws.sdk.kotlin.services.opsworks.model.Architecture? = builder.architecture
    /**
     * The instance's Amazon Resource Number (ARN).
     */
    val arn: kotlin.String? = builder.arn
    /**
     * For load-based or time-based instances, the type.
     */
    val autoScalingType: aws.sdk.kotlin.services.opsworks.model.AutoScalingType? = builder.autoScalingType
    /**
     * The instance Availability Zone. For more information, see [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html).
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * An array of `BlockDeviceMapping` objects that specify the instance's block device mappings.
     */
    val blockDeviceMappings: List<BlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * The time that the instance was created.
     */
    val createdAt: kotlin.String? = builder.createdAt
    /**
     * Whether this is an Amazon EBS-optimized instance.
     */
    val ebsOptimized: kotlin.Boolean? = builder.ebsOptimized
    /**
     * The ID of the associated Amazon EC2 instance.
     */
    val ec2InstanceId: kotlin.String? = builder.ec2InstanceId
    /**
     * For container instances, the Amazon ECS cluster's ARN.
     */
    val ecsClusterArn: kotlin.String? = builder.ecsClusterArn
    /**
     * For container instances, the instance's ARN.
     */
    val ecsContainerInstanceArn: kotlin.String? = builder.ecsContainerInstanceArn
    /**
     * The instance [Elastic IP address ](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html).
     */
    val elasticIp: kotlin.String? = builder.elasticIp
    /**
     * The instance host name.
     */
    val hostname: kotlin.String? = builder.hostname
    /**
     * For registered instances, the infrastructure class: `ec2` or `on-premises`.
     */
    val infrastructureClass: kotlin.String? = builder.infrastructureClass
    /**
     * Whether to install operating system and package updates when the instance boots. The default value is `true`. If this value is set to `false`, you must then update your instances manually by using CreateDeployment to run the `update_dependencies` stack command or by manually running `yum` (Amazon Linux) or `apt-get` (Ubuntu) on the instances.
     *
     * We strongly recommend using the default value of `true`, to ensure that your instances have the latest security updates.
     */
    val installUpdatesOnBoot: kotlin.Boolean? = builder.installUpdatesOnBoot
    /**
     * The instance ID.
     */
    val instanceId: kotlin.String? = builder.instanceId
    /**
     * The ARN of the instance's IAM profile. For more information about IAM ARNs, see [Using Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
     */
    val instanceProfileArn: kotlin.String? = builder.instanceProfileArn
    /**
     * The instance type, such as `t2.micro`.
     */
    val instanceType: kotlin.String? = builder.instanceType
    /**
     * The ID of the last service error. For more information, call DescribeServiceErrors.
     */
    val lastServiceErrorId: kotlin.String? = builder.lastServiceErrorId
    /**
     * An array containing the instance layer IDs.
     */
    val layerIds: List<String>? = builder.layerIds
    /**
     * The instance's operating system.
     */
    val os: kotlin.String? = builder.os
    /**
     * The instance's platform.
     */
    val platform: kotlin.String? = builder.platform
    /**
     * The instance's private DNS name.
     */
    val privateDns: kotlin.String? = builder.privateDns
    /**
     * The instance's private IP address.
     */
    val privateIp: kotlin.String? = builder.privateIp
    /**
     * The instance public DNS name.
     */
    val publicDns: kotlin.String? = builder.publicDns
    /**
     * The instance public IP address.
     */
    val publicIp: kotlin.String? = builder.publicIp
    /**
     * For registered instances, who performed the registration.
     */
    val registeredBy: kotlin.String? = builder.registeredBy
    /**
     * The instance's reported AWS OpsWorks Stacks agent version.
     */
    val reportedAgentVersion: kotlin.String? = builder.reportedAgentVersion
    /**
     * For registered instances, the reported operating system.
     */
    val reportedOs: aws.sdk.kotlin.services.opsworks.model.ReportedOs? = builder.reportedOs
    /**
     * The instance's root device type. For more information, see [Storage for the Root Device](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
     */
    val rootDeviceType: aws.sdk.kotlin.services.opsworks.model.RootDeviceType? = builder.rootDeviceType
    /**
     * The root device volume ID.
     */
    val rootDeviceVolumeId: kotlin.String? = builder.rootDeviceVolumeId
    /**
     * An array containing the instance security group IDs.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The SSH key's Deep Security Agent (DSA) fingerprint.
     */
    val sshHostDsaKeyFingerprint: kotlin.String? = builder.sshHostDsaKeyFingerprint
    /**
     * The SSH key's RSA fingerprint.
     */
    val sshHostRsaKeyFingerprint: kotlin.String? = builder.sshHostRsaKeyFingerprint
    /**
     * The instance's Amazon EC2 key-pair name.
     */
    val sshKeyName: kotlin.String? = builder.sshKeyName
    /**
     * The stack ID.
     */
    val stackId: kotlin.String? = builder.stackId
    /**
     * The instance status:
     * + `booting`
     * + `connection_lost`
     * + `online`
     * + `pending`
     * + `rebooting`
     * + `requested`
     * + `running_setup`
     * + `setup_failed`
     * + `shutting_down`
     * + `start_failed`
     * + `stop_failed`
     * + `stopped`
     * + `stopping`
     * + `terminated`
     * + `terminating`
     */
    val status: kotlin.String? = builder.status
    /**
     * The instance's subnet ID; applicable only if the stack is running in a VPC.
     */
    val subnetId: kotlin.String? = builder.subnetId
    /**
     * The instance's tenancy option, such as `dedicated` or `host`.
     */
    val tenancy: kotlin.String? = builder.tenancy
    /**
     * The instance's virtualization type: `paravirtual` or `hvm`.
     */
    val virtualizationType: aws.sdk.kotlin.services.opsworks.model.VirtualizationType? = builder.virtualizationType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.Instance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Instance(")
        append("agentVersion=$agentVersion,")
        append("amiId=$amiId,")
        append("architecture=$architecture,")
        append("arn=$arn,")
        append("autoScalingType=$autoScalingType,")
        append("availabilityZone=$availabilityZone,")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("createdAt=$createdAt,")
        append("ebsOptimized=$ebsOptimized,")
        append("ec2InstanceId=$ec2InstanceId,")
        append("ecsClusterArn=$ecsClusterArn,")
        append("ecsContainerInstanceArn=$ecsContainerInstanceArn,")
        append("elasticIp=$elasticIp,")
        append("hostname=$hostname,")
        append("infrastructureClass=$infrastructureClass,")
        append("installUpdatesOnBoot=$installUpdatesOnBoot,")
        append("instanceId=$instanceId,")
        append("instanceProfileArn=$instanceProfileArn,")
        append("instanceType=$instanceType,")
        append("lastServiceErrorId=$lastServiceErrorId,")
        append("layerIds=$layerIds,")
        append("os=$os,")
        append("platform=$platform,")
        append("privateDns=$privateDns,")
        append("privateIp=$privateIp,")
        append("publicDns=$publicDns,")
        append("publicIp=$publicIp,")
        append("registeredBy=$registeredBy,")
        append("reportedAgentVersion=$reportedAgentVersion,")
        append("reportedOs=$reportedOs,")
        append("rootDeviceType=$rootDeviceType,")
        append("rootDeviceVolumeId=$rootDeviceVolumeId,")
        append("securityGroupIds=$securityGroupIds,")
        append("sshHostDsaKeyFingerprint=$sshHostDsaKeyFingerprint,")
        append("sshHostRsaKeyFingerprint=$sshHostRsaKeyFingerprint,")
        append("sshKeyName=$sshKeyName,")
        append("stackId=$stackId,")
        append("status=$status,")
        append("subnetId=$subnetId,")
        append("tenancy=$tenancy,")
        append("virtualizationType=$virtualizationType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentVersion?.hashCode() ?: 0
        result = 31 * result + (amiId?.hashCode() ?: 0)
        result = 31 * result + (architecture?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (autoScalingType?.hashCode() ?: 0)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (blockDeviceMappings?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (ec2InstanceId?.hashCode() ?: 0)
        result = 31 * result + (ecsClusterArn?.hashCode() ?: 0)
        result = 31 * result + (ecsContainerInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (elasticIp?.hashCode() ?: 0)
        result = 31 * result + (hostname?.hashCode() ?: 0)
        result = 31 * result + (infrastructureClass?.hashCode() ?: 0)
        result = 31 * result + (installUpdatesOnBoot?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceProfileArn?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (lastServiceErrorId?.hashCode() ?: 0)
        result = 31 * result + (layerIds?.hashCode() ?: 0)
        result = 31 * result + (os?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (privateDns?.hashCode() ?: 0)
        result = 31 * result + (privateIp?.hashCode() ?: 0)
        result = 31 * result + (publicDns?.hashCode() ?: 0)
        result = 31 * result + (publicIp?.hashCode() ?: 0)
        result = 31 * result + (registeredBy?.hashCode() ?: 0)
        result = 31 * result + (reportedAgentVersion?.hashCode() ?: 0)
        result = 31 * result + (reportedOs?.hashCode() ?: 0)
        result = 31 * result + (rootDeviceType?.hashCode() ?: 0)
        result = 31 * result + (rootDeviceVolumeId?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (sshHostDsaKeyFingerprint?.hashCode() ?: 0)
        result = 31 * result + (sshHostRsaKeyFingerprint?.hashCode() ?: 0)
        result = 31 * result + (sshKeyName?.hashCode() ?: 0)
        result = 31 * result + (stackId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (tenancy?.hashCode() ?: 0)
        result = 31 * result + (virtualizationType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Instance

        if (agentVersion != other.agentVersion) return false
        if (amiId != other.amiId) return false
        if (architecture != other.architecture) return false
        if (arn != other.arn) return false
        if (autoScalingType != other.autoScalingType) return false
        if (availabilityZone != other.availabilityZone) return false
        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (createdAt != other.createdAt) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (ec2InstanceId != other.ec2InstanceId) return false
        if (ecsClusterArn != other.ecsClusterArn) return false
        if (ecsContainerInstanceArn != other.ecsContainerInstanceArn) return false
        if (elasticIp != other.elasticIp) return false
        if (hostname != other.hostname) return false
        if (infrastructureClass != other.infrastructureClass) return false
        if (installUpdatesOnBoot != other.installUpdatesOnBoot) return false
        if (instanceId != other.instanceId) return false
        if (instanceProfileArn != other.instanceProfileArn) return false
        if (instanceType != other.instanceType) return false
        if (lastServiceErrorId != other.lastServiceErrorId) return false
        if (layerIds != other.layerIds) return false
        if (os != other.os) return false
        if (platform != other.platform) return false
        if (privateDns != other.privateDns) return false
        if (privateIp != other.privateIp) return false
        if (publicDns != other.publicDns) return false
        if (publicIp != other.publicIp) return false
        if (registeredBy != other.registeredBy) return false
        if (reportedAgentVersion != other.reportedAgentVersion) return false
        if (reportedOs != other.reportedOs) return false
        if (rootDeviceType != other.rootDeviceType) return false
        if (rootDeviceVolumeId != other.rootDeviceVolumeId) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (sshHostDsaKeyFingerprint != other.sshHostDsaKeyFingerprint) return false
        if (sshHostRsaKeyFingerprint != other.sshHostRsaKeyFingerprint) return false
        if (sshKeyName != other.sshKeyName) return false
        if (stackId != other.stackId) return false
        if (status != other.status) return false
        if (subnetId != other.subnetId) return false
        if (tenancy != other.tenancy) return false
        if (virtualizationType != other.virtualizationType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.Instance = Builder(this).apply(block).build()

    class Builder {
        /**
         * The agent version. This parameter is set to `INHERIT` if the instance inherits the default stack setting or to a a version number for a fixed agent version.
         */
        var agentVersion: kotlin.String? = null
        /**
         * A custom AMI ID to be used to create the instance. For more information, see [Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html)
         */
        var amiId: kotlin.String? = null
        /**
         * The instance architecture: "i386" or "x86_64".
         */
        var architecture: aws.sdk.kotlin.services.opsworks.model.Architecture? = null
        /**
         * The instance's Amazon Resource Number (ARN).
         */
        var arn: kotlin.String? = null
        /**
         * For load-based or time-based instances, the type.
         */
        var autoScalingType: aws.sdk.kotlin.services.opsworks.model.AutoScalingType? = null
        /**
         * The instance Availability Zone. For more information, see [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html).
         */
        var availabilityZone: kotlin.String? = null
        /**
         * An array of `BlockDeviceMapping` objects that specify the instance's block device mappings.
         */
        var blockDeviceMappings: List<BlockDeviceMapping>? = null
        /**
         * The time that the instance was created.
         */
        var createdAt: kotlin.String? = null
        /**
         * Whether this is an Amazon EBS-optimized instance.
         */
        var ebsOptimized: kotlin.Boolean? = null
        /**
         * The ID of the associated Amazon EC2 instance.
         */
        var ec2InstanceId: kotlin.String? = null
        /**
         * For container instances, the Amazon ECS cluster's ARN.
         */
        var ecsClusterArn: kotlin.String? = null
        /**
         * For container instances, the instance's ARN.
         */
        var ecsContainerInstanceArn: kotlin.String? = null
        /**
         * The instance [Elastic IP address ](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html).
         */
        var elasticIp: kotlin.String? = null
        /**
         * The instance host name.
         */
        var hostname: kotlin.String? = null
        /**
         * For registered instances, the infrastructure class: `ec2` or `on-premises`.
         */
        var infrastructureClass: kotlin.String? = null
        /**
         * Whether to install operating system and package updates when the instance boots. The default value is `true`. If this value is set to `false`, you must then update your instances manually by using CreateDeployment to run the `update_dependencies` stack command or by manually running `yum` (Amazon Linux) or `apt-get` (Ubuntu) on the instances.
         *
         * We strongly recommend using the default value of `true`, to ensure that your instances have the latest security updates.
         */
        var installUpdatesOnBoot: kotlin.Boolean? = null
        /**
         * The instance ID.
         */
        var instanceId: kotlin.String? = null
        /**
         * The ARN of the instance's IAM profile. For more information about IAM ARNs, see [Using Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
         */
        var instanceProfileArn: kotlin.String? = null
        /**
         * The instance type, such as `t2.micro`.
         */
        var instanceType: kotlin.String? = null
        /**
         * The ID of the last service error. For more information, call DescribeServiceErrors.
         */
        var lastServiceErrorId: kotlin.String? = null
        /**
         * An array containing the instance layer IDs.
         */
        var layerIds: List<String>? = null
        /**
         * The instance's operating system.
         */
        var os: kotlin.String? = null
        /**
         * The instance's platform.
         */
        var platform: kotlin.String? = null
        /**
         * The instance's private DNS name.
         */
        var privateDns: kotlin.String? = null
        /**
         * The instance's private IP address.
         */
        var privateIp: kotlin.String? = null
        /**
         * The instance public DNS name.
         */
        var publicDns: kotlin.String? = null
        /**
         * The instance public IP address.
         */
        var publicIp: kotlin.String? = null
        /**
         * For registered instances, who performed the registration.
         */
        var registeredBy: kotlin.String? = null
        /**
         * The instance's reported AWS OpsWorks Stacks agent version.
         */
        var reportedAgentVersion: kotlin.String? = null
        /**
         * For registered instances, the reported operating system.
         */
        var reportedOs: aws.sdk.kotlin.services.opsworks.model.ReportedOs? = null
        /**
         * The instance's root device type. For more information, see [Storage for the Root Device](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
         */
        var rootDeviceType: aws.sdk.kotlin.services.opsworks.model.RootDeviceType? = null
        /**
         * The root device volume ID.
         */
        var rootDeviceVolumeId: kotlin.String? = null
        /**
         * An array containing the instance security group IDs.
         */
        var securityGroupIds: List<String>? = null
        /**
         * The SSH key's Deep Security Agent (DSA) fingerprint.
         */
        var sshHostDsaKeyFingerprint: kotlin.String? = null
        /**
         * The SSH key's RSA fingerprint.
         */
        var sshHostRsaKeyFingerprint: kotlin.String? = null
        /**
         * The instance's Amazon EC2 key-pair name.
         */
        var sshKeyName: kotlin.String? = null
        /**
         * The stack ID.
         */
        var stackId: kotlin.String? = null
        /**
         * The instance status:
         * + `booting`
         * + `connection_lost`
         * + `online`
         * + `pending`
         * + `rebooting`
         * + `requested`
         * + `running_setup`
         * + `setup_failed`
         * + `shutting_down`
         * + `start_failed`
         * + `stop_failed`
         * + `stopped`
         * + `stopping`
         * + `terminated`
         * + `terminating`
         */
        var status: kotlin.String? = null
        /**
         * The instance's subnet ID; applicable only if the stack is running in a VPC.
         */
        var subnetId: kotlin.String? = null
        /**
         * The instance's tenancy option, such as `dedicated` or `host`.
         */
        var tenancy: kotlin.String? = null
        /**
         * The instance's virtualization type: `paravirtual` or `hvm`.
         */
        var virtualizationType: aws.sdk.kotlin.services.opsworks.model.VirtualizationType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.Instance) : this() {
            this.agentVersion = x.agentVersion
            this.amiId = x.amiId
            this.architecture = x.architecture
            this.arn = x.arn
            this.autoScalingType = x.autoScalingType
            this.availabilityZone = x.availabilityZone
            this.blockDeviceMappings = x.blockDeviceMappings
            this.createdAt = x.createdAt
            this.ebsOptimized = x.ebsOptimized
            this.ec2InstanceId = x.ec2InstanceId
            this.ecsClusterArn = x.ecsClusterArn
            this.ecsContainerInstanceArn = x.ecsContainerInstanceArn
            this.elasticIp = x.elasticIp
            this.hostname = x.hostname
            this.infrastructureClass = x.infrastructureClass
            this.installUpdatesOnBoot = x.installUpdatesOnBoot
            this.instanceId = x.instanceId
            this.instanceProfileArn = x.instanceProfileArn
            this.instanceType = x.instanceType
            this.lastServiceErrorId = x.lastServiceErrorId
            this.layerIds = x.layerIds
            this.os = x.os
            this.platform = x.platform
            this.privateDns = x.privateDns
            this.privateIp = x.privateIp
            this.publicDns = x.publicDns
            this.publicIp = x.publicIp
            this.registeredBy = x.registeredBy
            this.reportedAgentVersion = x.reportedAgentVersion
            this.reportedOs = x.reportedOs
            this.rootDeviceType = x.rootDeviceType
            this.rootDeviceVolumeId = x.rootDeviceVolumeId
            this.securityGroupIds = x.securityGroupIds
            this.sshHostDsaKeyFingerprint = x.sshHostDsaKeyFingerprint
            this.sshHostRsaKeyFingerprint = x.sshHostRsaKeyFingerprint
            this.sshKeyName = x.sshKeyName
            this.stackId = x.stackId
            this.status = x.status
            this.subnetId = x.subnetId
            this.tenancy = x.tenancy
            this.virtualizationType = x.virtualizationType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.Instance = Instance(this)

        /**
         * construct an [aws.sdk.kotlin.services.opsworks.model.ReportedOs] inside the given [block]
         */
        fun reportedOs(block: aws.sdk.kotlin.services.opsworks.model.ReportedOs.Builder.() -> kotlin.Unit) {
            this.reportedOs = aws.sdk.kotlin.services.opsworks.model.ReportedOs.invoke(block)
        }
    }
}
