// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



/**
 * Describes a layer.
 */
class Layer private constructor(builder: Builder) {
    /**
     * The Amazon Resource Number (ARN) of a layer.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The layer attributes.
     *
     * For the `HaproxyStatsPassword`, `MysqlRootPassword`, and `GangliaPassword` attributes, AWS OpsWorks Stacks returns `*****FILTERED*****` instead of the actual value
     *
     * For an ECS Cluster layer, AWS OpsWorks Stacks the `EcsClusterArn` attribute is set to the cluster's ARN.
     */
    val attributes: Map<String, String>? = builder.attributes
    /**
     * Whether to automatically assign an [Elastic IP address](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) to the layer's instances. For more information, see [How to Edit a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
     */
    val autoAssignElasticIps: kotlin.Boolean? = builder.autoAssignElasticIps
    /**
     * For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances. For more information, see [How to Edit a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
     */
    val autoAssignPublicIps: kotlin.Boolean? = builder.autoAssignPublicIps
    /**
     * The Amazon CloudWatch Logs configuration settings for the layer.
     */
    val cloudWatchLogsConfiguration: aws.sdk.kotlin.services.opsworks.model.CloudWatchLogsConfiguration? = builder.cloudWatchLogsConfiguration
    /**
     * Date when the layer was created.
     */
    val createdAt: kotlin.String? = builder.createdAt
    /**
     * The ARN of the default IAM profile to be used for the layer's EC2 instances. For more information about IAM ARNs, see [Using Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
     */
    val customInstanceProfileArn: kotlin.String? = builder.customInstanceProfileArn
    /**
     * A JSON formatted string containing the layer's custom stack configuration and deployment attributes.
     */
    val customJson: kotlin.String? = builder.customJson
    /**
     * A `LayerCustomRecipes` object that specifies the layer's custom recipes.
     */
    val customRecipes: aws.sdk.kotlin.services.opsworks.model.Recipes? = builder.customRecipes
    /**
     * An array containing the layer's custom security group IDs.
     */
    val customSecurityGroupIds: List<String>? = builder.customSecurityGroupIds
    /**
     * AWS OpsWorks Stacks supports five lifecycle events: **setup**, **configuration**, **deploy**, **undeploy**, and **shutdown**. For each layer, AWS OpsWorks Stacks runs a set of standard recipes for each event. You can also provide custom recipes for any or all layers and events. AWS OpsWorks Stacks runs custom event recipes after the standard recipes. `LayerCustomRecipes` specifies the custom recipes for a particular layer to be run in response to each of the five events.
     *
     * To specify a recipe, use the cookbook's directory name in the repository followed by two colons and the recipe name, which is the recipe's file name without the `.rb` extension. For example: `phpapp2::dbsetup` specifies the `dbsetup.rb` recipe in the repository's `phpapp2` folder.
     */
    val defaultRecipes: aws.sdk.kotlin.services.opsworks.model.Recipes? = builder.defaultRecipes
    /**
     * An array containing the layer's security group names.
     */
    val defaultSecurityGroupNames: List<String>? = builder.defaultSecurityGroupNames
    /**
     * Whether auto healing is disabled for the layer.
     */
    val enableAutoHealing: kotlin.Boolean? = builder.enableAutoHealing
    /**
     * Whether to install operating system and package updates when the instance boots. The default value is `true`. If this value is set to `false`, you must then update your instances manually by using CreateDeployment to run the `update_dependencies` stack command or manually running `yum` (Amazon Linux) or `apt-get` (Ubuntu) on the instances.
     *
     * We strongly recommend using the default value of `true`, to ensure that your instances have the latest security updates.
     */
    val installUpdatesOnBoot: kotlin.Boolean? = builder.installUpdatesOnBoot
    /**
     * The layer ID.
     */
    val layerId: kotlin.String? = builder.layerId
    /**
     * A `LifeCycleEventConfiguration` object that specifies the Shutdown event configuration.
     */
    val lifecycleEventConfiguration: aws.sdk.kotlin.services.opsworks.model.LifecycleEventConfiguration? = builder.lifecycleEventConfiguration
    /**
     * The layer name.
     */
    val name: kotlin.String? = builder.name
    /**
     * An array of `Package` objects that describe the layer's packages.
     */
    val packages: List<String>? = builder.packages
    /**
     * The layer short name.
     */
    val shortname: kotlin.String? = builder.shortname
    /**
     * The layer stack ID.
     */
    val stackId: kotlin.String? = builder.stackId
    /**
     * The layer type.
     */
    val type: aws.sdk.kotlin.services.opsworks.model.LayerType? = builder.type
    /**
     * Whether the layer uses Amazon EBS-optimized instances.
     */
    val useEbsOptimizedInstances: kotlin.Boolean? = builder.useEbsOptimizedInstances
    /**
     * A `VolumeConfigurations` object that describes the layer's Amazon EBS volumes.
     */
    val volumeConfigurations: List<VolumeConfiguration>? = builder.volumeConfigurations

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.Layer = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Layer(")
        append("arn=$arn,")
        append("attributes=$attributes,")
        append("autoAssignElasticIps=$autoAssignElasticIps,")
        append("autoAssignPublicIps=$autoAssignPublicIps,")
        append("cloudWatchLogsConfiguration=$cloudWatchLogsConfiguration,")
        append("createdAt=$createdAt,")
        append("customInstanceProfileArn=$customInstanceProfileArn,")
        append("customJson=$customJson,")
        append("customRecipes=$customRecipes,")
        append("customSecurityGroupIds=$customSecurityGroupIds,")
        append("defaultRecipes=$defaultRecipes,")
        append("defaultSecurityGroupNames=$defaultSecurityGroupNames,")
        append("enableAutoHealing=$enableAutoHealing,")
        append("installUpdatesOnBoot=$installUpdatesOnBoot,")
        append("layerId=$layerId,")
        append("lifecycleEventConfiguration=$lifecycleEventConfiguration,")
        append("name=$name,")
        append("packages=$packages,")
        append("shortname=$shortname,")
        append("stackId=$stackId,")
        append("type=$type,")
        append("useEbsOptimizedInstances=$useEbsOptimizedInstances,")
        append("volumeConfigurations=$volumeConfigurations)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (autoAssignElasticIps?.hashCode() ?: 0)
        result = 31 * result + (autoAssignPublicIps?.hashCode() ?: 0)
        result = 31 * result + (cloudWatchLogsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (customInstanceProfileArn?.hashCode() ?: 0)
        result = 31 * result + (customJson?.hashCode() ?: 0)
        result = 31 * result + (customRecipes?.hashCode() ?: 0)
        result = 31 * result + (customSecurityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (defaultRecipes?.hashCode() ?: 0)
        result = 31 * result + (defaultSecurityGroupNames?.hashCode() ?: 0)
        result = 31 * result + (enableAutoHealing?.hashCode() ?: 0)
        result = 31 * result + (installUpdatesOnBoot?.hashCode() ?: 0)
        result = 31 * result + (layerId?.hashCode() ?: 0)
        result = 31 * result + (lifecycleEventConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (packages?.hashCode() ?: 0)
        result = 31 * result + (shortname?.hashCode() ?: 0)
        result = 31 * result + (stackId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (useEbsOptimizedInstances?.hashCode() ?: 0)
        result = 31 * result + (volumeConfigurations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Layer

        if (arn != other.arn) return false
        if (attributes != other.attributes) return false
        if (autoAssignElasticIps != other.autoAssignElasticIps) return false
        if (autoAssignPublicIps != other.autoAssignPublicIps) return false
        if (cloudWatchLogsConfiguration != other.cloudWatchLogsConfiguration) return false
        if (createdAt != other.createdAt) return false
        if (customInstanceProfileArn != other.customInstanceProfileArn) return false
        if (customJson != other.customJson) return false
        if (customRecipes != other.customRecipes) return false
        if (customSecurityGroupIds != other.customSecurityGroupIds) return false
        if (defaultRecipes != other.defaultRecipes) return false
        if (defaultSecurityGroupNames != other.defaultSecurityGroupNames) return false
        if (enableAutoHealing != other.enableAutoHealing) return false
        if (installUpdatesOnBoot != other.installUpdatesOnBoot) return false
        if (layerId != other.layerId) return false
        if (lifecycleEventConfiguration != other.lifecycleEventConfiguration) return false
        if (name != other.name) return false
        if (packages != other.packages) return false
        if (shortname != other.shortname) return false
        if (stackId != other.stackId) return false
        if (type != other.type) return false
        if (useEbsOptimizedInstances != other.useEbsOptimizedInstances) return false
        if (volumeConfigurations != other.volumeConfigurations) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.Layer = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Number (ARN) of a layer.
         */
        var arn: kotlin.String? = null
        /**
         * The layer attributes.
         *
         * For the `HaproxyStatsPassword`, `MysqlRootPassword`, and `GangliaPassword` attributes, AWS OpsWorks Stacks returns `*****FILTERED*****` instead of the actual value
         *
         * For an ECS Cluster layer, AWS OpsWorks Stacks the `EcsClusterArn` attribute is set to the cluster's ARN.
         */
        var attributes: Map<String, String>? = null
        /**
         * Whether to automatically assign an [Elastic IP address](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) to the layer's instances. For more information, see [How to Edit a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
         */
        var autoAssignElasticIps: kotlin.Boolean? = null
        /**
         * For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances. For more information, see [How to Edit a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
         */
        var autoAssignPublicIps: kotlin.Boolean? = null
        /**
         * The Amazon CloudWatch Logs configuration settings for the layer.
         */
        var cloudWatchLogsConfiguration: aws.sdk.kotlin.services.opsworks.model.CloudWatchLogsConfiguration? = null
        /**
         * Date when the layer was created.
         */
        var createdAt: kotlin.String? = null
        /**
         * The ARN of the default IAM profile to be used for the layer's EC2 instances. For more information about IAM ARNs, see [Using Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
         */
        var customInstanceProfileArn: kotlin.String? = null
        /**
         * A JSON formatted string containing the layer's custom stack configuration and deployment attributes.
         */
        var customJson: kotlin.String? = null
        /**
         * A `LayerCustomRecipes` object that specifies the layer's custom recipes.
         */
        var customRecipes: aws.sdk.kotlin.services.opsworks.model.Recipes? = null
        /**
         * An array containing the layer's custom security group IDs.
         */
        var customSecurityGroupIds: List<String>? = null
        /**
         * AWS OpsWorks Stacks supports five lifecycle events: **setup**, **configuration**, **deploy**, **undeploy**, and **shutdown**. For each layer, AWS OpsWorks Stacks runs a set of standard recipes for each event. You can also provide custom recipes for any or all layers and events. AWS OpsWorks Stacks runs custom event recipes after the standard recipes. `LayerCustomRecipes` specifies the custom recipes for a particular layer to be run in response to each of the five events.
         *
         * To specify a recipe, use the cookbook's directory name in the repository followed by two colons and the recipe name, which is the recipe's file name without the `.rb` extension. For example: `phpapp2::dbsetup` specifies the `dbsetup.rb` recipe in the repository's `phpapp2` folder.
         */
        var defaultRecipes: aws.sdk.kotlin.services.opsworks.model.Recipes? = null
        /**
         * An array containing the layer's security group names.
         */
        var defaultSecurityGroupNames: List<String>? = null
        /**
         * Whether auto healing is disabled for the layer.
         */
        var enableAutoHealing: kotlin.Boolean? = null
        /**
         * Whether to install operating system and package updates when the instance boots. The default value is `true`. If this value is set to `false`, you must then update your instances manually by using CreateDeployment to run the `update_dependencies` stack command or manually running `yum` (Amazon Linux) or `apt-get` (Ubuntu) on the instances.
         *
         * We strongly recommend using the default value of `true`, to ensure that your instances have the latest security updates.
         */
        var installUpdatesOnBoot: kotlin.Boolean? = null
        /**
         * The layer ID.
         */
        var layerId: kotlin.String? = null
        /**
         * A `LifeCycleEventConfiguration` object that specifies the Shutdown event configuration.
         */
        var lifecycleEventConfiguration: aws.sdk.kotlin.services.opsworks.model.LifecycleEventConfiguration? = null
        /**
         * The layer name.
         */
        var name: kotlin.String? = null
        /**
         * An array of `Package` objects that describe the layer's packages.
         */
        var packages: List<String>? = null
        /**
         * The layer short name.
         */
        var shortname: kotlin.String? = null
        /**
         * The layer stack ID.
         */
        var stackId: kotlin.String? = null
        /**
         * The layer type.
         */
        var type: aws.sdk.kotlin.services.opsworks.model.LayerType? = null
        /**
         * Whether the layer uses Amazon EBS-optimized instances.
         */
        var useEbsOptimizedInstances: kotlin.Boolean? = null
        /**
         * A `VolumeConfigurations` object that describes the layer's Amazon EBS volumes.
         */
        var volumeConfigurations: List<VolumeConfiguration>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.Layer) : this() {
            this.arn = x.arn
            this.attributes = x.attributes
            this.autoAssignElasticIps = x.autoAssignElasticIps
            this.autoAssignPublicIps = x.autoAssignPublicIps
            this.cloudWatchLogsConfiguration = x.cloudWatchLogsConfiguration
            this.createdAt = x.createdAt
            this.customInstanceProfileArn = x.customInstanceProfileArn
            this.customJson = x.customJson
            this.customRecipes = x.customRecipes
            this.customSecurityGroupIds = x.customSecurityGroupIds
            this.defaultRecipes = x.defaultRecipes
            this.defaultSecurityGroupNames = x.defaultSecurityGroupNames
            this.enableAutoHealing = x.enableAutoHealing
            this.installUpdatesOnBoot = x.installUpdatesOnBoot
            this.layerId = x.layerId
            this.lifecycleEventConfiguration = x.lifecycleEventConfiguration
            this.name = x.name
            this.packages = x.packages
            this.shortname = x.shortname
            this.stackId = x.stackId
            this.type = x.type
            this.useEbsOptimizedInstances = x.useEbsOptimizedInstances
            this.volumeConfigurations = x.volumeConfigurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.Layer = Layer(this)

        /**
         * construct an [aws.sdk.kotlin.services.opsworks.model.CloudWatchLogsConfiguration] inside the given [block]
         */
        fun cloudWatchLogsConfiguration(block: aws.sdk.kotlin.services.opsworks.model.CloudWatchLogsConfiguration.Builder.() -> kotlin.Unit) {
            this.cloudWatchLogsConfiguration = aws.sdk.kotlin.services.opsworks.model.CloudWatchLogsConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opsworks.model.Recipes] inside the given [block]
         */
        fun customRecipes(block: aws.sdk.kotlin.services.opsworks.model.Recipes.Builder.() -> kotlin.Unit) {
            this.customRecipes = aws.sdk.kotlin.services.opsworks.model.Recipes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opsworks.model.Recipes] inside the given [block]
         */
        fun defaultRecipes(block: aws.sdk.kotlin.services.opsworks.model.Recipes.Builder.() -> kotlin.Unit) {
            this.defaultRecipes = aws.sdk.kotlin.services.opsworks.model.Recipes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opsworks.model.LifecycleEventConfiguration] inside the given [block]
         */
        fun lifecycleEventConfiguration(block: aws.sdk.kotlin.services.opsworks.model.LifecycleEventConfiguration.Builder.() -> kotlin.Unit) {
            this.lifecycleEventConfiguration = aws.sdk.kotlin.services.opsworks.model.LifecycleEventConfiguration.invoke(block)
        }
    }
}
