// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



/**
 * Describes supported operating systems in AWS OpsWorks Stacks.
 */
class OperatingSystem private constructor(builder: Builder) {
    /**
     * Supported configuration manager name and versions for an AWS OpsWorks Stacks operating system.
     */
    val configurationManagers: List<OperatingSystemConfigurationManager>? = builder.configurationManagers
    /**
     * The ID of a supported operating system, such as `Amazon Linux 2018.03`.
     */
    val id: kotlin.String? = builder.id
    /**
     * The name of the operating system, such as `Amazon Linux 2018.03`.
     */
    val name: kotlin.String? = builder.name
    /**
     * A short name for the operating system manufacturer.
     */
    val reportedName: kotlin.String? = builder.reportedName
    /**
     * The version of the operating system, including the release and edition, if applicable.
     */
    val reportedVersion: kotlin.String? = builder.reportedVersion
    /**
     * Indicates that an operating system is not supported for new instances.
     */
    val supported: kotlin.Boolean? = builder.supported
    /**
     * The type of a supported operating system, either `Linux` or `Windows`.
     */
    val type: kotlin.String? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.OperatingSystem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OperatingSystem(")
        append("configurationManagers=$configurationManagers,")
        append("id=$id,")
        append("name=$name,")
        append("reportedName=$reportedName,")
        append("reportedVersion=$reportedVersion,")
        append("supported=$supported,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationManagers?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (reportedName?.hashCode() ?: 0)
        result = 31 * result + (reportedVersion?.hashCode() ?: 0)
        result = 31 * result + (supported?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OperatingSystem

        if (configurationManagers != other.configurationManagers) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (reportedName != other.reportedName) return false
        if (reportedVersion != other.reportedVersion) return false
        if (supported != other.supported) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.OperatingSystem = Builder(this).apply(block).build()

    class Builder {
        /**
         * Supported configuration manager name and versions for an AWS OpsWorks Stacks operating system.
         */
        var configurationManagers: List<OperatingSystemConfigurationManager>? = null
        /**
         * The ID of a supported operating system, such as `Amazon Linux 2018.03`.
         */
        var id: kotlin.String? = null
        /**
         * The name of the operating system, such as `Amazon Linux 2018.03`.
         */
        var name: kotlin.String? = null
        /**
         * A short name for the operating system manufacturer.
         */
        var reportedName: kotlin.String? = null
        /**
         * The version of the operating system, including the release and edition, if applicable.
         */
        var reportedVersion: kotlin.String? = null
        /**
         * Indicates that an operating system is not supported for new instances.
         */
        var supported: kotlin.Boolean? = null
        /**
         * The type of a supported operating system, either `Linux` or `Windows`.
         */
        var type: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.OperatingSystem) : this() {
            this.configurationManagers = x.configurationManagers
            this.id = x.id
            this.name = x.name
            this.reportedName = x.reportedName
            this.reportedVersion = x.reportedVersion
            this.supported = x.supported
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.OperatingSystem = OperatingSystem(this)
    }
}
