// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



/**
 * Describes an instance's RAID array.
 */
class RaidArray private constructor(builder: Builder) {
    /**
     * The array's Availability Zone. For more information, see [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html).
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * When the RAID array was created.
     */
    val createdAt: kotlin.String? = builder.createdAt
    /**
     * The array's Linux device. For example /dev/mdadm0.
     */
    val device: kotlin.String? = builder.device
    /**
     * The instance ID.
     */
    val instanceId: kotlin.String? = builder.instanceId
    /**
     * For PIOPS volumes, the IOPS per disk.
     */
    val iops: kotlin.Int? = builder.iops
    /**
     * The array's mount point.
     */
    val mountPoint: kotlin.String? = builder.mountPoint
    /**
     * The array name.
     */
    val name: kotlin.String? = builder.name
    /**
     * The number of disks in the array.
     */
    val numberOfDisks: kotlin.Int? = builder.numberOfDisks
    /**
     * The array ID.
     */
    val raidArrayId: kotlin.String? = builder.raidArrayId
    /**
     * The [RAID level](http://en.wikipedia.org/wiki/Standard_RAID_levels).
     */
    val raidLevel: kotlin.Int? = builder.raidLevel
    /**
     * The array's size.
     */
    val size: kotlin.Int? = builder.size
    /**
     * The stack ID.
     */
    val stackId: kotlin.String? = builder.stackId
    /**
     * The volume type, standard or PIOPS.
     */
    val volumeType: kotlin.String? = builder.volumeType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.RaidArray = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RaidArray(")
        append("availabilityZone=$availabilityZone,")
        append("createdAt=$createdAt,")
        append("device=$device,")
        append("instanceId=$instanceId,")
        append("iops=$iops,")
        append("mountPoint=$mountPoint,")
        append("name=$name,")
        append("numberOfDisks=$numberOfDisks,")
        append("raidArrayId=$raidArrayId,")
        append("raidLevel=$raidLevel,")
        append("size=$size,")
        append("stackId=$stackId,")
        append("volumeType=$volumeType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (device?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (mountPoint?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (numberOfDisks ?: 0)
        result = 31 * result + (raidArrayId?.hashCode() ?: 0)
        result = 31 * result + (raidLevel ?: 0)
        result = 31 * result + (size ?: 0)
        result = 31 * result + (stackId?.hashCode() ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RaidArray

        if (availabilityZone != other.availabilityZone) return false
        if (createdAt != other.createdAt) return false
        if (device != other.device) return false
        if (instanceId != other.instanceId) return false
        if (iops != other.iops) return false
        if (mountPoint != other.mountPoint) return false
        if (name != other.name) return false
        if (numberOfDisks != other.numberOfDisks) return false
        if (raidArrayId != other.raidArrayId) return false
        if (raidLevel != other.raidLevel) return false
        if (size != other.size) return false
        if (stackId != other.stackId) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.RaidArray = Builder(this).apply(block).build()

    class Builder {
        /**
         * The array's Availability Zone. For more information, see [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html).
         */
        var availabilityZone: kotlin.String? = null
        /**
         * When the RAID array was created.
         */
        var createdAt: kotlin.String? = null
        /**
         * The array's Linux device. For example /dev/mdadm0.
         */
        var device: kotlin.String? = null
        /**
         * The instance ID.
         */
        var instanceId: kotlin.String? = null
        /**
         * For PIOPS volumes, the IOPS per disk.
         */
        var iops: kotlin.Int? = null
        /**
         * The array's mount point.
         */
        var mountPoint: kotlin.String? = null
        /**
         * The array name.
         */
        var name: kotlin.String? = null
        /**
         * The number of disks in the array.
         */
        var numberOfDisks: kotlin.Int? = null
        /**
         * The array ID.
         */
        var raidArrayId: kotlin.String? = null
        /**
         * The [RAID level](http://en.wikipedia.org/wiki/Standard_RAID_levels).
         */
        var raidLevel: kotlin.Int? = null
        /**
         * The array's size.
         */
        var size: kotlin.Int? = null
        /**
         * The stack ID.
         */
        var stackId: kotlin.String? = null
        /**
         * The volume type, standard or PIOPS.
         */
        var volumeType: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.RaidArray) : this() {
            this.availabilityZone = x.availabilityZone
            this.createdAt = x.createdAt
            this.device = x.device
            this.instanceId = x.instanceId
            this.iops = x.iops
            this.mountPoint = x.mountPoint
            this.name = x.name
            this.numberOfDisks = x.numberOfDisks
            this.raidArrayId = x.raidArrayId
            this.raidLevel = x.raidLevel
            this.size = x.size
            this.stackId = x.stackId
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.RaidArray = RaidArray(this)
    }
}
