// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



/**
 * Describes an Amazon RDS instance.
 */
class RdsDbInstance private constructor(builder: Builder) {
    /**
     * The instance's address.
     */
    val address: kotlin.String? = builder.address
    /**
     * The DB instance identifier.
     */
    val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * AWS OpsWorks Stacks returns `*****FILTERED*****` instead of the actual value.
     */
    val dbPassword: kotlin.String? = builder.dbPassword
    /**
     * The master user name.
     */
    val dbUser: kotlin.String? = builder.dbUser
    /**
     * The instance's database engine.
     */
    val engine: kotlin.String? = builder.engine
    /**
     * Set to `true` if AWS OpsWorks Stacks is unable to discover the Amazon RDS instance. AWS OpsWorks Stacks attempts to discover the instance only once. If this value is set to `true`, you must deregister the instance, and then register it again.
     */
    val missingOnRds: kotlin.Boolean? = builder.missingOnRds
    /**
     * The instance's ARN.
     */
    val rdsDbInstanceArn: kotlin.String? = builder.rdsDbInstanceArn
    /**
     * The instance's AWS region.
     */
    val region: kotlin.String? = builder.region
    /**
     * The ID of the stack with which the instance is registered.
     */
    val stackId: kotlin.String? = builder.stackId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.RdsDbInstance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RdsDbInstance(")
        append("address=$address,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbPassword=$dbPassword,")
        append("dbUser=$dbUser,")
        append("engine=$engine,")
        append("missingOnRds=$missingOnRds,")
        append("rdsDbInstanceArn=$rdsDbInstanceArn,")
        append("region=$region,")
        append("stackId=$stackId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = address?.hashCode() ?: 0
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbPassword?.hashCode() ?: 0)
        result = 31 * result + (dbUser?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (missingOnRds?.hashCode() ?: 0)
        result = 31 * result + (rdsDbInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (stackId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RdsDbInstance

        if (address != other.address) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbPassword != other.dbPassword) return false
        if (dbUser != other.dbUser) return false
        if (engine != other.engine) return false
        if (missingOnRds != other.missingOnRds) return false
        if (rdsDbInstanceArn != other.rdsDbInstanceArn) return false
        if (region != other.region) return false
        if (stackId != other.stackId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.RdsDbInstance = Builder(this).apply(block).build()

    class Builder {
        /**
         * The instance's address.
         */
        var address: kotlin.String? = null
        /**
         * The DB instance identifier.
         */
        var dbInstanceIdentifier: kotlin.String? = null
        /**
         * AWS OpsWorks Stacks returns `*****FILTERED*****` instead of the actual value.
         */
        var dbPassword: kotlin.String? = null
        /**
         * The master user name.
         */
        var dbUser: kotlin.String? = null
        /**
         * The instance's database engine.
         */
        var engine: kotlin.String? = null
        /**
         * Set to `true` if AWS OpsWorks Stacks is unable to discover the Amazon RDS instance. AWS OpsWorks Stacks attempts to discover the instance only once. If this value is set to `true`, you must deregister the instance, and then register it again.
         */
        var missingOnRds: kotlin.Boolean? = null
        /**
         * The instance's ARN.
         */
        var rdsDbInstanceArn: kotlin.String? = null
        /**
         * The instance's AWS region.
         */
        var region: kotlin.String? = null
        /**
         * The ID of the stack with which the instance is registered.
         */
        var stackId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.RdsDbInstance) : this() {
            this.address = x.address
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbPassword = x.dbPassword
            this.dbUser = x.dbUser
            this.engine = x.engine
            this.missingOnRds = x.missingOnRds
            this.rdsDbInstanceArn = x.rdsDbInstanceArn
            this.region = x.region
            this.stackId = x.stackId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.RdsDbInstance = RdsDbInstance(this)
    }
}
