// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



/**
 * AWS OpsWorks Stacks supports five lifecycle events: **setup**, **configuration**, **deploy**, **undeploy**, and **shutdown**. For each layer, AWS OpsWorks Stacks runs a set of standard recipes for each event. In addition, you can provide custom recipes for any or all layers and events. AWS OpsWorks Stacks runs custom event recipes after the standard recipes. `LayerCustomRecipes` specifies the custom recipes for a particular layer to be run in response to each of the five events.
 *
 * To specify a recipe, use the cookbook's directory name in the repository followed by two colons and the recipe name, which is the recipe's file name without the .rb extension. For example: phpapp2::dbsetup specifies the dbsetup.rb recipe in the repository's phpapp2 folder.
 */
class Recipes private constructor(builder: Builder) {
    /**
     * An array of custom recipe names to be run following a `configure` event.
     */
    val configure: List<String>? = builder.configure
    /**
     * An array of custom recipe names to be run following a `deploy` event.
     */
    val deploy: List<String>? = builder.deploy
    /**
     * An array of custom recipe names to be run following a `setup` event.
     */
    val setup: List<String>? = builder.setup
    /**
     * An array of custom recipe names to be run following a `shutdown` event.
     */
    val shutdown: List<String>? = builder.shutdown
    /**
     * An array of custom recipe names to be run following a `undeploy` event.
     */
    val undeploy: List<String>? = builder.undeploy

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.Recipes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Recipes(")
        append("configure=$configure,")
        append("deploy=$deploy,")
        append("setup=$setup,")
        append("shutdown=$shutdown,")
        append("undeploy=$undeploy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = configure?.hashCode() ?: 0
        result = 31 * result + (deploy?.hashCode() ?: 0)
        result = 31 * result + (setup?.hashCode() ?: 0)
        result = 31 * result + (shutdown?.hashCode() ?: 0)
        result = 31 * result + (undeploy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Recipes

        if (configure != other.configure) return false
        if (deploy != other.deploy) return false
        if (setup != other.setup) return false
        if (shutdown != other.shutdown) return false
        if (undeploy != other.undeploy) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.Recipes = Builder(this).apply(block).build()

    class Builder {
        /**
         * An array of custom recipe names to be run following a `configure` event.
         */
        var configure: List<String>? = null
        /**
         * An array of custom recipe names to be run following a `deploy` event.
         */
        var deploy: List<String>? = null
        /**
         * An array of custom recipe names to be run following a `setup` event.
         */
        var setup: List<String>? = null
        /**
         * An array of custom recipe names to be run following a `shutdown` event.
         */
        var shutdown: List<String>? = null
        /**
         * An array of custom recipe names to be run following a `undeploy` event.
         */
        var undeploy: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.Recipes) : this() {
            this.configure = x.configure
            this.deploy = x.deploy
            this.setup = x.setup
            this.shutdown = x.shutdown
            this.undeploy = x.undeploy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.Recipes = Recipes(this)
    }
}
