// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



/**
 * Contains the information required to retrieve an app or cookbook from a repository. For more information, see [Creating Apps](https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html) or [Custom Recipes and Cookbooks](https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html).
 */
class Source private constructor(builder: Builder) {
    /**
     * When included in a request, the parameter depends on the repository type.
     * + For Amazon S3 bundles, set `Password` to the appropriate IAM secret access key.
     * + For HTTP bundles and Subversion repositories, set `Password` to the password.
     *
     * For more information on how to safely handle IAM credentials, see [https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html](https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html).
     *
     * In responses, AWS OpsWorks Stacks returns `*****FILTERED*****` instead of the actual value.
     */
    val password: kotlin.String? = builder.password
    /**
     * The application's version. AWS OpsWorks Stacks enables you to easily deploy new versions of an application. One of the simplest approaches is to have branches or revisions in your repository that represent different versions that can potentially be deployed.
     */
    val revision: kotlin.String? = builder.revision
    /**
     * In requests, the repository's SSH key.
     *
     * In responses, AWS OpsWorks Stacks returns `*****FILTERED*****` instead of the actual value.
     */
    val sshKey: kotlin.String? = builder.sshKey
    /**
     * The repository type.
     */
    val type: aws.sdk.kotlin.services.opsworks.model.SourceType? = builder.type
    /**
     * The source URL. The following is an example of an Amazon S3 source URL: `https://s3.amazonaws.com/opsworks-demo-bucket/opsworks_cookbook_demo.tar.gz`.
     */
    val url: kotlin.String? = builder.url
    /**
     * This parameter depends on the repository type.
     * + For Amazon S3 bundles, set `Username` to the appropriate IAM access key ID.
     * + For HTTP bundles, Git repositories, and Subversion repositories, set `Username` to the user name.
     */
    val username: kotlin.String? = builder.username

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.Source = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Source(")
        append("password=$password,")
        append("revision=$revision,")
        append("sshKey=$sshKey,")
        append("type=$type,")
        append("url=$url,")
        append("username=$username)")
    }

    override fun hashCode(): kotlin.Int {
        var result = password?.hashCode() ?: 0
        result = 31 * result + (revision?.hashCode() ?: 0)
        result = 31 * result + (sshKey?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Source

        if (password != other.password) return false
        if (revision != other.revision) return false
        if (sshKey != other.sshKey) return false
        if (type != other.type) return false
        if (url != other.url) return false
        if (username != other.username) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.Source = Builder(this).apply(block).build()

    class Builder {
        /**
         * When included in a request, the parameter depends on the repository type.
         * + For Amazon S3 bundles, set `Password` to the appropriate IAM secret access key.
         * + For HTTP bundles and Subversion repositories, set `Password` to the password.
         *
         * For more information on how to safely handle IAM credentials, see [https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html](https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html).
         *
         * In responses, AWS OpsWorks Stacks returns `*****FILTERED*****` instead of the actual value.
         */
        var password: kotlin.String? = null
        /**
         * The application's version. AWS OpsWorks Stacks enables you to easily deploy new versions of an application. One of the simplest approaches is to have branches or revisions in your repository that represent different versions that can potentially be deployed.
         */
        var revision: kotlin.String? = null
        /**
         * In requests, the repository's SSH key.
         *
         * In responses, AWS OpsWorks Stacks returns `*****FILTERED*****` instead of the actual value.
         */
        var sshKey: kotlin.String? = null
        /**
         * The repository type.
         */
        var type: aws.sdk.kotlin.services.opsworks.model.SourceType? = null
        /**
         * The source URL. The following is an example of an Amazon S3 source URL: `https://s3.amazonaws.com/opsworks-demo-bucket/opsworks_cookbook_demo.tar.gz`.
         */
        var url: kotlin.String? = null
        /**
         * This parameter depends on the repository type.
         * + For Amazon S3 bundles, set `Username` to the appropriate IAM access key ID.
         * + For HTTP bundles, Git repositories, and Subversion repositories, set `Username` to the user name.
         */
        var username: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.Source) : this() {
            this.password = x.password
            this.revision = x.revision
            this.sshKey = x.sshKey
            this.type = x.type
            this.url = x.url
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.Source = Source(this)
    }
}
