// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



/**
 * Describes a stack.
 */
class Stack private constructor(builder: Builder) {
    /**
     * The agent version. This parameter is set to `LATEST` for auto-update. or a version number for a fixed agent version.
     */
    val agentVersion: kotlin.String? = builder.agentVersion
    /**
     * The stack's ARN.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The stack's attributes.
     */
    val attributes: Map<String, String>? = builder.attributes
    /**
     * A `ChefConfiguration` object that specifies whether to enable Berkshelf and the Berkshelf version. For more information, see [Create a New Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
     */
    val chefConfiguration: aws.sdk.kotlin.services.opsworks.model.ChefConfiguration? = builder.chefConfiguration
    /**
     * The configuration manager.
     */
    val configurationManager: aws.sdk.kotlin.services.opsworks.model.StackConfigurationManager? = builder.configurationManager
    /**
     * The date when the stack was created.
     */
    val createdAt: kotlin.String? = builder.createdAt
    /**
     * Contains the information required to retrieve an app or cookbook from a repository. For more information, see [Adding Apps](https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html) or [Cookbooks and Recipes](https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html).
     */
    val customCookbooksSource: aws.sdk.kotlin.services.opsworks.model.Source? = builder.customCookbooksSource
    /**
     * A JSON object that contains user-defined attributes to be added to the stack configuration and deployment attributes. You can use custom JSON to override the corresponding default stack configuration attribute values or to pass data to recipes. The string should be in the following format:
     *
     * `"{\"key1\": \"value1\", \"key2\": \"value2\",...}"`
     *
     * For more information on custom JSON, see [Use Custom JSON to Modify the Stack Configuration Attributes](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html).
     */
    val customJson: kotlin.String? = builder.customJson
    /**
     * The stack's default Availability Zone. For more information, see [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html).
     */
    val defaultAvailabilityZone: kotlin.String? = builder.defaultAvailabilityZone
    /**
     * The ARN of an IAM profile that is the default profile for all of the stack's EC2 instances. For more information about IAM ARNs, see [Using Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
     */
    val defaultInstanceProfileArn: kotlin.String? = builder.defaultInstanceProfileArn
    /**
     * The stack's default operating system.
     */
    val defaultOs: kotlin.String? = builder.defaultOs
    /**
     * The default root device type. This value is used by default for all instances in the stack, but you can override it when you create an instance. For more information, see [Storage for the Root Device](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
     */
    val defaultRootDeviceType: aws.sdk.kotlin.services.opsworks.model.RootDeviceType? = builder.defaultRootDeviceType
    /**
     * A default Amazon EC2 key pair for the stack's instances. You can override this value when you create or update an instance.
     */
    val defaultSshKeyName: kotlin.String? = builder.defaultSshKeyName
    /**
     * The default subnet ID; applicable only if the stack is running in a VPC.
     */
    val defaultSubnetId: kotlin.String? = builder.defaultSubnetId
    /**
     * The stack host name theme, with spaces replaced by underscores.
     */
    val hostnameTheme: kotlin.String? = builder.hostnameTheme
    /**
     * The stack name.
     */
    val name: kotlin.String? = builder.name
    /**
     * The stack AWS region, such as "ap-northeast-2". For more information about AWS regions, see [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html).
     */
    val region: kotlin.String? = builder.region
    /**
     * The stack AWS Identity and Access Management (IAM) role.
     */
    val serviceRoleArn: kotlin.String? = builder.serviceRoleArn
    /**
     * The stack ID.
     */
    val stackId: kotlin.String? = builder.stackId
    /**
     * Whether the stack uses custom cookbooks.
     */
    val useCustomCookbooks: kotlin.Boolean? = builder.useCustomCookbooks
    /**
     * Whether the stack automatically associates the AWS OpsWorks Stacks built-in security groups with the stack's layers.
     */
    val useOpsworksSecurityGroups: kotlin.Boolean? = builder.useOpsworksSecurityGroups
    /**
     * The VPC ID; applicable only if the stack is running in a VPC.
     */
    val vpcId: kotlin.String? = builder.vpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.Stack = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Stack(")
        append("agentVersion=$agentVersion,")
        append("arn=$arn,")
        append("attributes=$attributes,")
        append("chefConfiguration=$chefConfiguration,")
        append("configurationManager=$configurationManager,")
        append("createdAt=$createdAt,")
        append("customCookbooksSource=$customCookbooksSource,")
        append("customJson=$customJson,")
        append("defaultAvailabilityZone=$defaultAvailabilityZone,")
        append("defaultInstanceProfileArn=$defaultInstanceProfileArn,")
        append("defaultOs=$defaultOs,")
        append("defaultRootDeviceType=$defaultRootDeviceType,")
        append("defaultSshKeyName=$defaultSshKeyName,")
        append("defaultSubnetId=$defaultSubnetId,")
        append("hostnameTheme=$hostnameTheme,")
        append("name=$name,")
        append("region=$region,")
        append("serviceRoleArn=$serviceRoleArn,")
        append("stackId=$stackId,")
        append("useCustomCookbooks=$useCustomCookbooks,")
        append("useOpsworksSecurityGroups=$useOpsworksSecurityGroups,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentVersion?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (chefConfiguration?.hashCode() ?: 0)
        result = 31 * result + (configurationManager?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (customCookbooksSource?.hashCode() ?: 0)
        result = 31 * result + (customJson?.hashCode() ?: 0)
        result = 31 * result + (defaultAvailabilityZone?.hashCode() ?: 0)
        result = 31 * result + (defaultInstanceProfileArn?.hashCode() ?: 0)
        result = 31 * result + (defaultOs?.hashCode() ?: 0)
        result = 31 * result + (defaultRootDeviceType?.hashCode() ?: 0)
        result = 31 * result + (defaultSshKeyName?.hashCode() ?: 0)
        result = 31 * result + (defaultSubnetId?.hashCode() ?: 0)
        result = 31 * result + (hostnameTheme?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (serviceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (stackId?.hashCode() ?: 0)
        result = 31 * result + (useCustomCookbooks?.hashCode() ?: 0)
        result = 31 * result + (useOpsworksSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Stack

        if (agentVersion != other.agentVersion) return false
        if (arn != other.arn) return false
        if (attributes != other.attributes) return false
        if (chefConfiguration != other.chefConfiguration) return false
        if (configurationManager != other.configurationManager) return false
        if (createdAt != other.createdAt) return false
        if (customCookbooksSource != other.customCookbooksSource) return false
        if (customJson != other.customJson) return false
        if (defaultAvailabilityZone != other.defaultAvailabilityZone) return false
        if (defaultInstanceProfileArn != other.defaultInstanceProfileArn) return false
        if (defaultOs != other.defaultOs) return false
        if (defaultRootDeviceType != other.defaultRootDeviceType) return false
        if (defaultSshKeyName != other.defaultSshKeyName) return false
        if (defaultSubnetId != other.defaultSubnetId) return false
        if (hostnameTheme != other.hostnameTheme) return false
        if (name != other.name) return false
        if (region != other.region) return false
        if (serviceRoleArn != other.serviceRoleArn) return false
        if (stackId != other.stackId) return false
        if (useCustomCookbooks != other.useCustomCookbooks) return false
        if (useOpsworksSecurityGroups != other.useOpsworksSecurityGroups) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.Stack = Builder(this).apply(block).build()

    class Builder {
        /**
         * The agent version. This parameter is set to `LATEST` for auto-update. or a version number for a fixed agent version.
         */
        var agentVersion: kotlin.String? = null
        /**
         * The stack's ARN.
         */
        var arn: kotlin.String? = null
        /**
         * The stack's attributes.
         */
        var attributes: Map<String, String>? = null
        /**
         * A `ChefConfiguration` object that specifies whether to enable Berkshelf and the Berkshelf version. For more information, see [Create a New Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
         */
        var chefConfiguration: aws.sdk.kotlin.services.opsworks.model.ChefConfiguration? = null
        /**
         * The configuration manager.
         */
        var configurationManager: aws.sdk.kotlin.services.opsworks.model.StackConfigurationManager? = null
        /**
         * The date when the stack was created.
         */
        var createdAt: kotlin.String? = null
        /**
         * Contains the information required to retrieve an app or cookbook from a repository. For more information, see [Adding Apps](https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html) or [Cookbooks and Recipes](https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html).
         */
        var customCookbooksSource: aws.sdk.kotlin.services.opsworks.model.Source? = null
        /**
         * A JSON object that contains user-defined attributes to be added to the stack configuration and deployment attributes. You can use custom JSON to override the corresponding default stack configuration attribute values or to pass data to recipes. The string should be in the following format:
         *
         * `"{\"key1\": \"value1\", \"key2\": \"value2\",...}"`
         *
         * For more information on custom JSON, see [Use Custom JSON to Modify the Stack Configuration Attributes](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html).
         */
        var customJson: kotlin.String? = null
        /**
         * The stack's default Availability Zone. For more information, see [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html).
         */
        var defaultAvailabilityZone: kotlin.String? = null
        /**
         * The ARN of an IAM profile that is the default profile for all of the stack's EC2 instances. For more information about IAM ARNs, see [Using Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
         */
        var defaultInstanceProfileArn: kotlin.String? = null
        /**
         * The stack's default operating system.
         */
        var defaultOs: kotlin.String? = null
        /**
         * The default root device type. This value is used by default for all instances in the stack, but you can override it when you create an instance. For more information, see [Storage for the Root Device](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
         */
        var defaultRootDeviceType: aws.sdk.kotlin.services.opsworks.model.RootDeviceType? = null
        /**
         * A default Amazon EC2 key pair for the stack's instances. You can override this value when you create or update an instance.
         */
        var defaultSshKeyName: kotlin.String? = null
        /**
         * The default subnet ID; applicable only if the stack is running in a VPC.
         */
        var defaultSubnetId: kotlin.String? = null
        /**
         * The stack host name theme, with spaces replaced by underscores.
         */
        var hostnameTheme: kotlin.String? = null
        /**
         * The stack name.
         */
        var name: kotlin.String? = null
        /**
         * The stack AWS region, such as "ap-northeast-2". For more information about AWS regions, see [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html).
         */
        var region: kotlin.String? = null
        /**
         * The stack AWS Identity and Access Management (IAM) role.
         */
        var serviceRoleArn: kotlin.String? = null
        /**
         * The stack ID.
         */
        var stackId: kotlin.String? = null
        /**
         * Whether the stack uses custom cookbooks.
         */
        var useCustomCookbooks: kotlin.Boolean? = null
        /**
         * Whether the stack automatically associates the AWS OpsWorks Stacks built-in security groups with the stack's layers.
         */
        var useOpsworksSecurityGroups: kotlin.Boolean? = null
        /**
         * The VPC ID; applicable only if the stack is running in a VPC.
         */
        var vpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.Stack) : this() {
            this.agentVersion = x.agentVersion
            this.arn = x.arn
            this.attributes = x.attributes
            this.chefConfiguration = x.chefConfiguration
            this.configurationManager = x.configurationManager
            this.createdAt = x.createdAt
            this.customCookbooksSource = x.customCookbooksSource
            this.customJson = x.customJson
            this.defaultAvailabilityZone = x.defaultAvailabilityZone
            this.defaultInstanceProfileArn = x.defaultInstanceProfileArn
            this.defaultOs = x.defaultOs
            this.defaultRootDeviceType = x.defaultRootDeviceType
            this.defaultSshKeyName = x.defaultSshKeyName
            this.defaultSubnetId = x.defaultSubnetId
            this.hostnameTheme = x.hostnameTheme
            this.name = x.name
            this.region = x.region
            this.serviceRoleArn = x.serviceRoleArn
            this.stackId = x.stackId
            this.useCustomCookbooks = x.useCustomCookbooks
            this.useOpsworksSecurityGroups = x.useOpsworksSecurityGroups
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.Stack = Stack(this)

        /**
         * construct an [aws.sdk.kotlin.services.opsworks.model.ChefConfiguration] inside the given [block]
         */
        fun chefConfiguration(block: aws.sdk.kotlin.services.opsworks.model.ChefConfiguration.Builder.() -> kotlin.Unit) {
            this.chefConfiguration = aws.sdk.kotlin.services.opsworks.model.ChefConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opsworks.model.StackConfigurationManager] inside the given [block]
         */
        fun configurationManager(block: aws.sdk.kotlin.services.opsworks.model.StackConfigurationManager.Builder.() -> kotlin.Unit) {
            this.configurationManager = aws.sdk.kotlin.services.opsworks.model.StackConfigurationManager.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.opsworks.model.Source] inside the given [block]
         */
        fun customCookbooksSource(block: aws.sdk.kotlin.services.opsworks.model.Source.Builder.() -> kotlin.Unit) {
            this.customCookbooksSource = aws.sdk.kotlin.services.opsworks.model.Source.invoke(block)
        }
    }
}
