// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



class TagResourceRequest private constructor(builder: Builder) {
    /**
     * The stack or layer's Amazon Resource Number (ARN).
     */
    val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * A map that contains tag keys and tag values that are attached to a stack or layer.
     * + The key cannot be empty.
     * + The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the following special characters: `+ - = . _ : /`
     * + The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the following special characters: `+ - = . _ : /`
     * + Leading and trailing white spaces are trimmed from both the key and value.
     * + A maximum of 40 tags is allowed for any resource.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.TagResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TagResourceRequest(")
        append("resourceArn=$resourceArn,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArn?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TagResourceRequest

        if (resourceArn != other.resourceArn) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.TagResourceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The stack or layer's Amazon Resource Number (ARN).
         */
        var resourceArn: kotlin.String? = null
        /**
         * A map that contains tag keys and tag values that are attached to a stack or layer.
         * + The key cannot be empty.
         * + The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the following special characters: `+ - = . _ : /`
         * + The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the following special characters: `+ - = . _ : /`
         * + Leading and trailing white spaces are trimmed from both the key and value.
         * + A maximum of 40 tags is allowed for any resource.
         */
        var tags: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.TagResourceRequest) : this() {
            this.resourceArn = x.resourceArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.TagResourceRequest = TagResourceRequest(this)
    }
}
