// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



class UpdateInstanceRequest private constructor(builder: Builder) {
    /**
     * The default AWS OpsWorks Stacks agent version. You have the following options:
     * + `INHERIT` - Use the stack's default agent version setting.
     * + *version_number* - Use the specified agent version. This value overrides the stack's default setting. To update the agent version, you must edit the instance configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the instance.
     *
     * The default setting is `INHERIT`. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call DescribeAgentVersions.
     *
     * AgentVersion cannot be set to Chef 12.2.
     */
    val agentVersion: kotlin.String? = builder.agentVersion
    /**
     * The ID of the AMI that was used to create the instance. The value of this parameter must be the same AMI ID that the instance is already using. You cannot apply a new AMI to an instance by running UpdateInstance. UpdateInstance does not work on instances that are using custom AMIs.
     */
    val amiId: kotlin.String? = builder.amiId
    /**
     * The instance architecture. Instance types do not necessarily support both architectures. For a list of the architectures that are supported by the different instance types, see [Instance Families and Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html).
     */
    val architecture: aws.sdk.kotlin.services.opsworks.model.Architecture? = builder.architecture
    /**
     * For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
     */
    val autoScalingType: aws.sdk.kotlin.services.opsworks.model.AutoScalingType? = builder.autoScalingType
    /**
     * This property cannot be updated.
     */
    val ebsOptimized: kotlin.Boolean? = builder.ebsOptimized
    /**
     * The instance host name.
     */
    val hostname: kotlin.String? = builder.hostname
    /**
     * Whether to install operating system and package updates when the instance boots. The default value is `true`. To control when updates are installed, set this value to `false`. You must then update your instances manually by using CreateDeployment to run the `update_dependencies` stack command or by manually running `yum` (Amazon Linux) or `apt-get` (Ubuntu) on the instances.
     *
     * We strongly recommend using the default value of `true`, to ensure that your instances have the latest security updates.
     */
    val installUpdatesOnBoot: kotlin.Boolean? = builder.installUpdatesOnBoot
    /**
     * The instance ID.
     */
    val instanceId: kotlin.String? = builder.instanceId
    /**
     * The instance type, such as `t2.micro`. For a list of supported instance types, open the stack in the console, choose **Instances**, and choose **+ Instance**. The **Size** list contains the currently supported types. For more information, see [Instance Families and Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html). The parameter values that you use to specify the various types are in the **API Name** column of the **Available Instance Types** table.
     */
    val instanceType: kotlin.String? = builder.instanceType
    /**
     * The instance's layer IDs.
     */
    val layerIds: List<String>? = builder.layerIds
    /**
     * The instance's operating system, which must be set to one of the following. You cannot update an instance that is using a custom AMI.
     * + A supported Linux operating system: An Amazon Linux version, such as `Amazon Linux 2018.03`, `Amazon Linux 2017.09`, `Amazon Linux 2017.03`, `Amazon Linux 2016.09`, `Amazon Linux 2016.03`, `Amazon Linux 2015.09`, or `Amazon Linux 2015.03`.
     * + A supported Ubuntu operating system, such as `Ubuntu 16.04 LTS`, `Ubuntu 14.04 LTS`, or `Ubuntu 12.04 LTS`.
     * + `CentOS Linux 7`
     * + `Red Hat Enterprise Linux 7`
     * + A supported Windows operating system, such as `Microsoft Windows Server 2012 R2 Base`, `Microsoft Windows Server 2012 R2 with SQL Server Express`, `Microsoft Windows Server 2012 R2 with SQL Server Standard`, or `Microsoft Windows Server 2012 R2 with SQL Server Web`.
     *
     * For more information about supported operating systems, see [AWS OpsWorks Stacks Operating Systems](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
     *
     * The default option is the current Amazon Linux version. If you set this parameter to `Custom`, you must use the AmiId parameter to specify the custom AMI that you want to use. For more information about supported operating systems, see [Operating Systems](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html). For more information about how to use custom AMIs with OpsWorks, see [Using Custom AMIs](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
     *
     * You can specify a different Linux operating system for the updated stack, but you cannot change from Linux to Windows or Windows to Linux.
     */
    val os: kotlin.String? = builder.os
    /**
     * The instance's Amazon EC2 key name.
     */
    val sshKeyName: kotlin.String? = builder.sshKeyName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.UpdateInstanceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateInstanceRequest(")
        append("agentVersion=$agentVersion,")
        append("amiId=$amiId,")
        append("architecture=$architecture,")
        append("autoScalingType=$autoScalingType,")
        append("ebsOptimized=$ebsOptimized,")
        append("hostname=$hostname,")
        append("installUpdatesOnBoot=$installUpdatesOnBoot,")
        append("instanceId=$instanceId,")
        append("instanceType=$instanceType,")
        append("layerIds=$layerIds,")
        append("os=$os,")
        append("sshKeyName=$sshKeyName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentVersion?.hashCode() ?: 0
        result = 31 * result + (amiId?.hashCode() ?: 0)
        result = 31 * result + (architecture?.hashCode() ?: 0)
        result = 31 * result + (autoScalingType?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (hostname?.hashCode() ?: 0)
        result = 31 * result + (installUpdatesOnBoot?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (layerIds?.hashCode() ?: 0)
        result = 31 * result + (os?.hashCode() ?: 0)
        result = 31 * result + (sshKeyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateInstanceRequest

        if (agentVersion != other.agentVersion) return false
        if (amiId != other.amiId) return false
        if (architecture != other.architecture) return false
        if (autoScalingType != other.autoScalingType) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (hostname != other.hostname) return false
        if (installUpdatesOnBoot != other.installUpdatesOnBoot) return false
        if (instanceId != other.instanceId) return false
        if (instanceType != other.instanceType) return false
        if (layerIds != other.layerIds) return false
        if (os != other.os) return false
        if (sshKeyName != other.sshKeyName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.UpdateInstanceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The default AWS OpsWorks Stacks agent version. You have the following options:
         * + `INHERIT` - Use the stack's default agent version setting.
         * + *version_number* - Use the specified agent version. This value overrides the stack's default setting. To update the agent version, you must edit the instance configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the instance.
         *
         * The default setting is `INHERIT`. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call DescribeAgentVersions.
         *
         * AgentVersion cannot be set to Chef 12.2.
         */
        var agentVersion: kotlin.String? = null
        /**
         * The ID of the AMI that was used to create the instance. The value of this parameter must be the same AMI ID that the instance is already using. You cannot apply a new AMI to an instance by running UpdateInstance. UpdateInstance does not work on instances that are using custom AMIs.
         */
        var amiId: kotlin.String? = null
        /**
         * The instance architecture. Instance types do not necessarily support both architectures. For a list of the architectures that are supported by the different instance types, see [Instance Families and Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html).
         */
        var architecture: aws.sdk.kotlin.services.opsworks.model.Architecture? = null
        /**
         * For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
         */
        var autoScalingType: aws.sdk.kotlin.services.opsworks.model.AutoScalingType? = null
        /**
         * This property cannot be updated.
         */
        var ebsOptimized: kotlin.Boolean? = null
        /**
         * The instance host name.
         */
        var hostname: kotlin.String? = null
        /**
         * Whether to install operating system and package updates when the instance boots. The default value is `true`. To control when updates are installed, set this value to `false`. You must then update your instances manually by using CreateDeployment to run the `update_dependencies` stack command or by manually running `yum` (Amazon Linux) or `apt-get` (Ubuntu) on the instances.
         *
         * We strongly recommend using the default value of `true`, to ensure that your instances have the latest security updates.
         */
        var installUpdatesOnBoot: kotlin.Boolean? = null
        /**
         * The instance ID.
         */
        var instanceId: kotlin.String? = null
        /**
         * The instance type, such as `t2.micro`. For a list of supported instance types, open the stack in the console, choose **Instances**, and choose **+ Instance**. The **Size** list contains the currently supported types. For more information, see [Instance Families and Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html). The parameter values that you use to specify the various types are in the **API Name** column of the **Available Instance Types** table.
         */
        var instanceType: kotlin.String? = null
        /**
         * The instance's layer IDs.
         */
        var layerIds: List<String>? = null
        /**
         * The instance's operating system, which must be set to one of the following. You cannot update an instance that is using a custom AMI.
         * + A supported Linux operating system: An Amazon Linux version, such as `Amazon Linux 2018.03`, `Amazon Linux 2017.09`, `Amazon Linux 2017.03`, `Amazon Linux 2016.09`, `Amazon Linux 2016.03`, `Amazon Linux 2015.09`, or `Amazon Linux 2015.03`.
         * + A supported Ubuntu operating system, such as `Ubuntu 16.04 LTS`, `Ubuntu 14.04 LTS`, or `Ubuntu 12.04 LTS`.
         * + `CentOS Linux 7`
         * + `Red Hat Enterprise Linux 7`
         * + A supported Windows operating system, such as `Microsoft Windows Server 2012 R2 Base`, `Microsoft Windows Server 2012 R2 with SQL Server Express`, `Microsoft Windows Server 2012 R2 with SQL Server Standard`, or `Microsoft Windows Server 2012 R2 with SQL Server Web`.
         *
         * For more information about supported operating systems, see [AWS OpsWorks Stacks Operating Systems](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
         *
         * The default option is the current Amazon Linux version. If you set this parameter to `Custom`, you must use the AmiId parameter to specify the custom AMI that you want to use. For more information about supported operating systems, see [Operating Systems](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html). For more information about how to use custom AMIs with OpsWorks, see [Using Custom AMIs](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
         *
         * You can specify a different Linux operating system for the updated stack, but you cannot change from Linux to Windows or Windows to Linux.
         */
        var os: kotlin.String? = null
        /**
         * The instance's Amazon EC2 key name.
         */
        var sshKeyName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.UpdateInstanceRequest) : this() {
            this.agentVersion = x.agentVersion
            this.amiId = x.amiId
            this.architecture = x.architecture
            this.autoScalingType = x.autoScalingType
            this.ebsOptimized = x.ebsOptimized
            this.hostname = x.hostname
            this.installUpdatesOnBoot = x.installUpdatesOnBoot
            this.instanceId = x.instanceId
            this.instanceType = x.instanceType
            this.layerIds = x.layerIds
            this.os = x.os
            this.sshKeyName = x.sshKeyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.UpdateInstanceRequest = UpdateInstanceRequest(this)
    }
}
