// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



/**
 * Describes an instance's Amazon EBS volume.
 */
class Volume private constructor(builder: Builder) {
    /**
     * The volume Availability Zone. For more information, see [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html).
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The device name.
     */
    val device: kotlin.String? = builder.device
    /**
     * The Amazon EC2 volume ID.
     */
    val ec2VolumeId: kotlin.String? = builder.ec2VolumeId
    /**
     * Specifies whether an Amazon EBS volume is encrypted. For more information, see [Amazon EBS Encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html).
     */
    val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * The instance ID.
     */
    val instanceId: kotlin.String? = builder.instanceId
    /**
     * For PIOPS volumes, the IOPS per disk.
     */
    val iops: kotlin.Int? = builder.iops
    /**
     * The volume mount point. For example, "/mnt/disk1".
     */
    val mountPoint: kotlin.String? = builder.mountPoint
    /**
     * The volume name.
     */
    val name: kotlin.String? = builder.name
    /**
     * The RAID array ID.
     */
    val raidArrayId: kotlin.String? = builder.raidArrayId
    /**
     * The AWS region. For more information about AWS regions, see [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html).
     */
    val region: kotlin.String? = builder.region
    /**
     * The volume size.
     */
    val size: kotlin.Int? = builder.size
    /**
     * The value returned by [DescribeVolumes](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeVolumes.html).
     */
    val status: kotlin.String? = builder.status
    /**
     * The volume ID.
     */
    val volumeId: kotlin.String? = builder.volumeId
    /**
     * The volume type. For more information, see [ Amazon EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
     * + `standard` - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum size of 1024 GiB.
     * + `io1` - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a maximum size of 16384 GiB.
     * + `gp2` - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB and a maximum size of 16384 GiB.
     * + `st1` - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.
     * + `sc1` - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.
     */
    val volumeType: kotlin.String? = builder.volumeType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.Volume = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Volume(")
        append("availabilityZone=$availabilityZone,")
        append("device=$device,")
        append("ec2VolumeId=$ec2VolumeId,")
        append("encrypted=$encrypted,")
        append("instanceId=$instanceId,")
        append("iops=$iops,")
        append("mountPoint=$mountPoint,")
        append("name=$name,")
        append("raidArrayId=$raidArrayId,")
        append("region=$region,")
        append("size=$size,")
        append("status=$status,")
        append("volumeId=$volumeId,")
        append("volumeType=$volumeType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (device?.hashCode() ?: 0)
        result = 31 * result + (ec2VolumeId?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (mountPoint?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (raidArrayId?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (size ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (volumeId?.hashCode() ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Volume

        if (availabilityZone != other.availabilityZone) return false
        if (device != other.device) return false
        if (ec2VolumeId != other.ec2VolumeId) return false
        if (encrypted != other.encrypted) return false
        if (instanceId != other.instanceId) return false
        if (iops != other.iops) return false
        if (mountPoint != other.mountPoint) return false
        if (name != other.name) return false
        if (raidArrayId != other.raidArrayId) return false
        if (region != other.region) return false
        if (size != other.size) return false
        if (status != other.status) return false
        if (volumeId != other.volumeId) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.Volume = Builder(this).apply(block).build()

    class Builder {
        /**
         * The volume Availability Zone. For more information, see [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html).
         */
        var availabilityZone: kotlin.String? = null
        /**
         * The device name.
         */
        var device: kotlin.String? = null
        /**
         * The Amazon EC2 volume ID.
         */
        var ec2VolumeId: kotlin.String? = null
        /**
         * Specifies whether an Amazon EBS volume is encrypted. For more information, see [Amazon EBS Encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html).
         */
        var encrypted: kotlin.Boolean? = null
        /**
         * The instance ID.
         */
        var instanceId: kotlin.String? = null
        /**
         * For PIOPS volumes, the IOPS per disk.
         */
        var iops: kotlin.Int? = null
        /**
         * The volume mount point. For example, "/mnt/disk1".
         */
        var mountPoint: kotlin.String? = null
        /**
         * The volume name.
         */
        var name: kotlin.String? = null
        /**
         * The RAID array ID.
         */
        var raidArrayId: kotlin.String? = null
        /**
         * The AWS region. For more information about AWS regions, see [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html).
         */
        var region: kotlin.String? = null
        /**
         * The volume size.
         */
        var size: kotlin.Int? = null
        /**
         * The value returned by [DescribeVolumes](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeVolumes.html).
         */
        var status: kotlin.String? = null
        /**
         * The volume ID.
         */
        var volumeId: kotlin.String? = null
        /**
         * The volume type. For more information, see [ Amazon EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
         * + `standard` - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum size of 1024 GiB.
         * + `io1` - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a maximum size of 16384 GiB.
         * + `gp2` - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB and a maximum size of 16384 GiB.
         * + `st1` - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.
         * + `sc1` - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.
         */
        var volumeType: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.Volume) : this() {
            this.availabilityZone = x.availabilityZone
            this.device = x.device
            this.ec2VolumeId = x.ec2VolumeId
            this.encrypted = x.encrypted
            this.instanceId = x.instanceId
            this.iops = x.iops
            this.mountPoint = x.mountPoint
            this.name = x.name
            this.raidArrayId = x.raidArrayId
            this.region = x.region
            this.size = x.size
            this.status = x.status
            this.volumeId = x.volumeId
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.Volume = Volume(this)
    }
}
