// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



/**
 * Describes an Amazon EBS volume configuration.
 */
class VolumeConfiguration private constructor(builder: Builder) {
    /**
     * Specifies whether an Amazon EBS volume is encrypted. For more information, see [Amazon EBS Encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html).
     */
    val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * For PIOPS volumes, the IOPS per disk.
     */
    val iops: kotlin.Int? = builder.iops
    /**
     * The volume mount point. For example "/dev/sdh".
     */
    val mountPoint: kotlin.String? = builder.mountPoint
    /**
     * The number of disks in the volume.
     */
    val numberOfDisks: kotlin.Int? = builder.numberOfDisks
    /**
     * The volume [RAID level](http://en.wikipedia.org/wiki/Standard_RAID_levels).
     */
    val raidLevel: kotlin.Int? = builder.raidLevel
    /**
     * The volume size.
     */
    val size: kotlin.Int? = builder.size
    /**
     * The volume type. For more information, see [ Amazon EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
     * + `standard` - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum size of 1024 GiB.
     * + `io1` - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a maximum size of 16384 GiB.
     * + `gp2` - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB and a maximum size of 16384 GiB.
     * + `st1` - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.
     * + `sc1` - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.
     */
    val volumeType: kotlin.String? = builder.volumeType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.VolumeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VolumeConfiguration(")
        append("encrypted=$encrypted,")
        append("iops=$iops,")
        append("mountPoint=$mountPoint,")
        append("numberOfDisks=$numberOfDisks,")
        append("raidLevel=$raidLevel,")
        append("size=$size,")
        append("volumeType=$volumeType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = encrypted?.hashCode() ?: 0
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (mountPoint?.hashCode() ?: 0)
        result = 31 * result + (numberOfDisks ?: 0)
        result = 31 * result + (raidLevel ?: 0)
        result = 31 * result + (size ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VolumeConfiguration

        if (encrypted != other.encrypted) return false
        if (iops != other.iops) return false
        if (mountPoint != other.mountPoint) return false
        if (numberOfDisks != other.numberOfDisks) return false
        if (raidLevel != other.raidLevel) return false
        if (size != other.size) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.VolumeConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies whether an Amazon EBS volume is encrypted. For more information, see [Amazon EBS Encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html).
         */
        var encrypted: kotlin.Boolean? = null
        /**
         * For PIOPS volumes, the IOPS per disk.
         */
        var iops: kotlin.Int? = null
        /**
         * The volume mount point. For example "/dev/sdh".
         */
        var mountPoint: kotlin.String? = null
        /**
         * The number of disks in the volume.
         */
        var numberOfDisks: kotlin.Int? = null
        /**
         * The volume [RAID level](http://en.wikipedia.org/wiki/Standard_RAID_levels).
         */
        var raidLevel: kotlin.Int? = null
        /**
         * The volume size.
         */
        var size: kotlin.Int? = null
        /**
         * The volume type. For more information, see [ Amazon EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
         * + `standard` - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum size of 1024 GiB.
         * + `io1` - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a maximum size of 16384 GiB.
         * + `gp2` - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB and a maximum size of 16384 GiB.
         * + `st1` - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.
         * + `sc1` - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384 GiB.
         */
        var volumeType: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.VolumeConfiguration) : this() {
            this.encrypted = x.encrypted
            this.iops = x.iops
            this.mountPoint = x.mountPoint
            this.numberOfDisks = x.numberOfDisks
            this.raidLevel = x.raidLevel
            this.size = x.size
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.VolumeConfiguration = VolumeConfiguration(this)
    }
}
