// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.model



/**
 * Describes a time-based instance's auto scaling schedule. The schedule consists of a set of key-value pairs.
 * + The key is the time period (a UTC hour) and must be an integer from 0 - 23.
 * + The value indicates whether the instance should be online or offline for the specified period, and must be set to "on" or "off"
 *
 * The default setting for all time periods is off, so you use the following parameters primarily to specify the online periods. You don't have to explicitly specify offline periods unless you want to change an online period to an offline period.
 *
 * The following example specifies that the instance should be online for four hours, from UTC 1200 - 1600. It will be off for the remainder of the day.
 *
 * ` { "12":"on", "13":"on", "14":"on", "15":"on" } `
 */
class WeeklyAutoScalingSchedule private constructor(builder: Builder) {
    /**
     * The schedule for Friday.
     */
    val friday: Map<String, String>? = builder.friday
    /**
     * The schedule for Monday.
     */
    val monday: Map<String, String>? = builder.monday
    /**
     * The schedule for Saturday.
     */
    val saturday: Map<String, String>? = builder.saturday
    /**
     * The schedule for Sunday.
     */
    val sunday: Map<String, String>? = builder.sunday
    /**
     * The schedule for Thursday.
     */
    val thursday: Map<String, String>? = builder.thursday
    /**
     * The schedule for Tuesday.
     */
    val tuesday: Map<String, String>? = builder.tuesday
    /**
     * The schedule for Wednesday.
     */
    val wednesday: Map<String, String>? = builder.wednesday

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworks.model.WeeklyAutoScalingSchedule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WeeklyAutoScalingSchedule(")
        append("friday=$friday,")
        append("monday=$monday,")
        append("saturday=$saturday,")
        append("sunday=$sunday,")
        append("thursday=$thursday,")
        append("tuesday=$tuesday,")
        append("wednesday=$wednesday)")
    }

    override fun hashCode(): kotlin.Int {
        var result = friday?.hashCode() ?: 0
        result = 31 * result + (monday?.hashCode() ?: 0)
        result = 31 * result + (saturday?.hashCode() ?: 0)
        result = 31 * result + (sunday?.hashCode() ?: 0)
        result = 31 * result + (thursday?.hashCode() ?: 0)
        result = 31 * result + (tuesday?.hashCode() ?: 0)
        result = 31 * result + (wednesday?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WeeklyAutoScalingSchedule

        if (friday != other.friday) return false
        if (monday != other.monday) return false
        if (saturday != other.saturday) return false
        if (sunday != other.sunday) return false
        if (thursday != other.thursday) return false
        if (tuesday != other.tuesday) return false
        if (wednesday != other.wednesday) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworks.model.WeeklyAutoScalingSchedule = Builder(this).apply(block).build()

    class Builder {
        /**
         * The schedule for Friday.
         */
        var friday: Map<String, String>? = null
        /**
         * The schedule for Monday.
         */
        var monday: Map<String, String>? = null
        /**
         * The schedule for Saturday.
         */
        var saturday: Map<String, String>? = null
        /**
         * The schedule for Sunday.
         */
        var sunday: Map<String, String>? = null
        /**
         * The schedule for Thursday.
         */
        var thursday: Map<String, String>? = null
        /**
         * The schedule for Tuesday.
         */
        var tuesday: Map<String, String>? = null
        /**
         * The schedule for Wednesday.
         */
        var wednesday: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworks.model.WeeklyAutoScalingSchedule) : this() {
            this.friday = x.friday
            this.monday = x.monday
            this.saturday = x.saturday
            this.sunday = x.sunday
            this.thursday = x.thursday
            this.tuesday = x.tuesday
            this.wednesday = x.wednesday
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworks.model.WeeklyAutoScalingSchedule = WeeklyAutoScalingSchedule(this)
    }
}
