// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.paginators

import aws.sdk.kotlin.services.opsworks.OpsWorksClient
import aws.sdk.kotlin.services.opsworks.model.DescribeEcsClustersRequest
import aws.sdk.kotlin.services.opsworks.model.DescribeEcsClustersResponse
import aws.sdk.kotlin.services.opsworks.model.EcsCluster
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeEcsClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEcsClustersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEcsClustersResponse]
 */
fun OpsWorksClient.describeEcsClustersPaginated(initialRequest: DescribeEcsClustersRequest): Flow<DescribeEcsClustersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeEcsClustersPaginated.describeEcsClusters(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEcsClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEcsClustersResponse]
 */
fun OpsWorksClient.describeEcsClustersPaginated(block: DescribeEcsClustersRequest.Builder.() -> Unit): Flow<DescribeEcsClustersResponse> =
    describeEcsClustersPaginated(DescribeEcsClustersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeEcsClustersPaginated]
 * to access the nested member [EcsCluster]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EcsCluster]
 */
@JvmName("describeEcsClustersResponseEcsCluster")
fun Flow<DescribeEcsClustersResponse>.ecsClusters(): Flow<EcsCluster> =
    transform() { response ->
        response.ecsClusters?.forEach {
            emit(it)
        }
    }
