// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.transform

import aws.sdk.kotlin.services.opsworks.model.ChefConfiguration
import aws.sdk.kotlin.services.opsworks.model.CloneStackRequest
import aws.sdk.kotlin.services.opsworks.model.RootDeviceType
import aws.sdk.kotlin.services.opsworks.model.Source
import aws.sdk.kotlin.services.opsworks.model.StackConfigurationManager
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CloneStackOperationSerializer: HttpSerialize<CloneStackRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CloneStackRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCloneStackOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCloneStackOperationBody(context: ExecutionContext, input: CloneStackRequest): ByteArray {
    val serializer = JsonSerializer()
    val AGENTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AgentVersion"))
    val ATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Attributes"))
    val CHEFCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ChefConfiguration"))
    val CLONEAPPIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CloneAppIds"))
    val CLONEPERMISSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("ClonePermissions"))
    val CONFIGURATIONMANAGER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ConfigurationManager"))
    val CUSTOMCOOKBOOKSSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CustomCookbooksSource"))
    val CUSTOMJSON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CustomJson"))
    val DEFAULTAVAILABILITYZONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DefaultAvailabilityZone"))
    val DEFAULTINSTANCEPROFILEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DefaultInstanceProfileArn"))
    val DEFAULTOS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DefaultOs"))
    val DEFAULTROOTDEVICETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DefaultRootDeviceType"))
    val DEFAULTSSHKEYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DefaultSshKeyName"))
    val DEFAULTSUBNETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DefaultSubnetId"))
    val HOSTNAMETHEME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HostnameTheme"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val REGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Region"))
    val SERVICEROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ServiceRoleArn"))
    val SOURCESTACKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceStackId"))
    val USECUSTOMCOOKBOOKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("UseCustomCookbooks"))
    val USEOPSWORKSSECURITYGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("UseOpsworksSecurityGroups"))
    val VPCID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VpcId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGENTVERSION_DESCRIPTOR)
        field(ATTRIBUTES_DESCRIPTOR)
        field(CHEFCONFIGURATION_DESCRIPTOR)
        field(CLONEAPPIDS_DESCRIPTOR)
        field(CLONEPERMISSIONS_DESCRIPTOR)
        field(CONFIGURATIONMANAGER_DESCRIPTOR)
        field(CUSTOMCOOKBOOKSSOURCE_DESCRIPTOR)
        field(CUSTOMJSON_DESCRIPTOR)
        field(DEFAULTAVAILABILITYZONE_DESCRIPTOR)
        field(DEFAULTINSTANCEPROFILEARN_DESCRIPTOR)
        field(DEFAULTOS_DESCRIPTOR)
        field(DEFAULTROOTDEVICETYPE_DESCRIPTOR)
        field(DEFAULTSSHKEYNAME_DESCRIPTOR)
        field(DEFAULTSUBNETID_DESCRIPTOR)
        field(HOSTNAMETHEME_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(REGION_DESCRIPTOR)
        field(SERVICEROLEARN_DESCRIPTOR)
        field(SOURCESTACKID_DESCRIPTOR)
        field(USECUSTOMCOOKBOOKS_DESCRIPTOR)
        field(USEOPSWORKSSECURITYGROUPS_DESCRIPTOR)
        field(VPCID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.agentVersion?.let { field(AGENTVERSION_DESCRIPTOR, it) }
        if (input.attributes != null) {
            mapField(ATTRIBUTES_DESCRIPTOR) {
                input.attributes.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.chefConfiguration?.let { field(CHEFCONFIGURATION_DESCRIPTOR, it, ::serializeChefConfigurationDocument) }
        if (input.cloneAppIds != null) {
            listField(CLONEAPPIDS_DESCRIPTOR) {
                for (el0 in input.cloneAppIds) {
                    serializeString(el0)
                }
            }
        }
        input.clonePermissions?.let { field(CLONEPERMISSIONS_DESCRIPTOR, it) }
        input.configurationManager?.let { field(CONFIGURATIONMANAGER_DESCRIPTOR, it, ::serializeStackConfigurationManagerDocument) }
        input.customCookbooksSource?.let { field(CUSTOMCOOKBOOKSSOURCE_DESCRIPTOR, it, ::serializeSourceDocument) }
        input.customJson?.let { field(CUSTOMJSON_DESCRIPTOR, it) }
        input.defaultAvailabilityZone?.let { field(DEFAULTAVAILABILITYZONE_DESCRIPTOR, it) }
        input.defaultInstanceProfileArn?.let { field(DEFAULTINSTANCEPROFILEARN_DESCRIPTOR, it) }
        input.defaultOs?.let { field(DEFAULTOS_DESCRIPTOR, it) }
        input.defaultRootDeviceType?.let { field(DEFAULTROOTDEVICETYPE_DESCRIPTOR, it.value) }
        input.defaultSshKeyName?.let { field(DEFAULTSSHKEYNAME_DESCRIPTOR, it) }
        input.defaultSubnetId?.let { field(DEFAULTSUBNETID_DESCRIPTOR, it) }
        input.hostnameTheme?.let { field(HOSTNAMETHEME_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.region?.let { field(REGION_DESCRIPTOR, it) }
        input.serviceRoleArn?.let { field(SERVICEROLEARN_DESCRIPTOR, it) }
        input.sourceStackId?.let { field(SOURCESTACKID_DESCRIPTOR, it) }
        input.useCustomCookbooks?.let { field(USECUSTOMCOOKBOOKS_DESCRIPTOR, it) }
        input.useOpsworksSecurityGroups?.let { field(USEOPSWORKSSECURITYGROUPS_DESCRIPTOR, it) }
        input.vpcId?.let { field(VPCID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
