// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.transform

import aws.sdk.kotlin.services.opsworks.model.Architecture
import aws.sdk.kotlin.services.opsworks.model.AutoScalingType
import aws.sdk.kotlin.services.opsworks.model.BlockDeviceMapping
import aws.sdk.kotlin.services.opsworks.model.CreateInstanceRequest
import aws.sdk.kotlin.services.opsworks.model.RootDeviceType
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateInstanceOperationSerializer: HttpSerialize<CreateInstanceRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateInstanceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCreateInstanceOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCreateInstanceOperationBody(context: ExecutionContext, input: CreateInstanceRequest): ByteArray {
    val serializer = JsonSerializer()
    val AGENTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AgentVersion"))
    val AMIID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AmiId"))
    val ARCHITECTURE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Architecture"))
    val AUTOSCALINGTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AutoScalingType"))
    val AVAILABILITYZONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AvailabilityZone"))
    val BLOCKDEVICEMAPPINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("BlockDeviceMappings"))
    val EBSOPTIMIZED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("EbsOptimized"))
    val HOSTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Hostname"))
    val INSTALLUPDATESONBOOT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("InstallUpdatesOnBoot"))
    val INSTANCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InstanceType"))
    val LAYERIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("LayerIds"))
    val OS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Os"))
    val ROOTDEVICETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RootDeviceType"))
    val SSHKEYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SshKeyName"))
    val STACKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StackId"))
    val SUBNETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SubnetId"))
    val TENANCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Tenancy"))
    val VIRTUALIZATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VirtualizationType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGENTVERSION_DESCRIPTOR)
        field(AMIID_DESCRIPTOR)
        field(ARCHITECTURE_DESCRIPTOR)
        field(AUTOSCALINGTYPE_DESCRIPTOR)
        field(AVAILABILITYZONE_DESCRIPTOR)
        field(BLOCKDEVICEMAPPINGS_DESCRIPTOR)
        field(EBSOPTIMIZED_DESCRIPTOR)
        field(HOSTNAME_DESCRIPTOR)
        field(INSTALLUPDATESONBOOT_DESCRIPTOR)
        field(INSTANCETYPE_DESCRIPTOR)
        field(LAYERIDS_DESCRIPTOR)
        field(OS_DESCRIPTOR)
        field(ROOTDEVICETYPE_DESCRIPTOR)
        field(SSHKEYNAME_DESCRIPTOR)
        field(STACKID_DESCRIPTOR)
        field(SUBNETID_DESCRIPTOR)
        field(TENANCY_DESCRIPTOR)
        field(VIRTUALIZATIONTYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.agentVersion?.let { field(AGENTVERSION_DESCRIPTOR, it) }
        input.amiId?.let { field(AMIID_DESCRIPTOR, it) }
        input.architecture?.let { field(ARCHITECTURE_DESCRIPTOR, it.value) }
        input.autoScalingType?.let { field(AUTOSCALINGTYPE_DESCRIPTOR, it.value) }
        input.availabilityZone?.let { field(AVAILABILITYZONE_DESCRIPTOR, it) }
        if (input.blockDeviceMappings != null) {
            listField(BLOCKDEVICEMAPPINGS_DESCRIPTOR) {
                for (el0 in input.blockDeviceMappings) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeBlockDeviceMappingDocument))
                }
            }
        }
        input.ebsOptimized?.let { field(EBSOPTIMIZED_DESCRIPTOR, it) }
        input.hostname?.let { field(HOSTNAME_DESCRIPTOR, it) }
        input.installUpdatesOnBoot?.let { field(INSTALLUPDATESONBOOT_DESCRIPTOR, it) }
        input.instanceType?.let { field(INSTANCETYPE_DESCRIPTOR, it) }
        if (input.layerIds != null) {
            listField(LAYERIDS_DESCRIPTOR) {
                for (el0 in input.layerIds) {
                    serializeString(el0)
                }
            }
        }
        input.os?.let { field(OS_DESCRIPTOR, it) }
        input.rootDeviceType?.let { field(ROOTDEVICETYPE_DESCRIPTOR, it.value) }
        input.sshKeyName?.let { field(SSHKEYNAME_DESCRIPTOR, it) }
        input.stackId?.let { field(STACKID_DESCRIPTOR, it) }
        input.subnetId?.let { field(SUBNETID_DESCRIPTOR, it) }
        input.tenancy?.let { field(TENANCY_DESCRIPTOR, it) }
        input.virtualizationType?.let { field(VIRTUALIZATIONTYPE_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
