// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.opsworks.model.DescribeEcsClustersResponse
import aws.sdk.kotlin.services.opsworks.model.EcsCluster
import aws.sdk.kotlin.services.opsworks.model.OpsWorksException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeEcsClustersOperationDeserializer: HttpDeserialize<DescribeEcsClustersResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeEcsClustersResponse {
        if (!response.status.isSuccess()) {
            throwDescribeEcsClustersError(context, response)
        }
        val builder = DescribeEcsClustersResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeEcsClustersOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeEcsClustersError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw OpsWorksException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> OpsWorksException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeEcsClustersOperationBody(builder: DescribeEcsClustersResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ECSCLUSTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("EcsClusters"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ECSCLUSTERS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ECSCLUSTERS_DESCRIPTOR.index -> builder.ecsClusters =
                    deserializer.deserializeList(ECSCLUSTERS_DESCRIPTOR) {
                        val col0 = mutableListOf<EcsCluster>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEcsClusterDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
