// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.opsworks.model.DescribeElasticLoadBalancersResponse
import aws.sdk.kotlin.services.opsworks.model.ElasticLoadBalancer
import aws.sdk.kotlin.services.opsworks.model.OpsWorksException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeElasticLoadBalancersOperationDeserializer: HttpDeserialize<DescribeElasticLoadBalancersResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeElasticLoadBalancersResponse {
        if (!response.status.isSuccess()) {
            throwDescribeElasticLoadBalancersError(context, response)
        }
        val builder = DescribeElasticLoadBalancersResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeElasticLoadBalancersOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeElasticLoadBalancersError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw OpsWorksException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> OpsWorksException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeElasticLoadBalancersOperationBody(builder: DescribeElasticLoadBalancersResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ELASTICLOADBALANCERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ElasticLoadBalancers"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ELASTICLOADBALANCERS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ELASTICLOADBALANCERS_DESCRIPTOR.index -> builder.elasticLoadBalancers =
                    deserializer.deserializeList(ELASTICLOADBALANCERS_DESCRIPTOR) {
                        val col0 = mutableListOf<ElasticLoadBalancer>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeElasticLoadBalancerDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
