// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.opsworks.model.GrantAccessResponse
import aws.sdk.kotlin.services.opsworks.model.OpsWorksException
import aws.sdk.kotlin.services.opsworks.model.TemporaryCredential
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GrantAccessOperationDeserializer: HttpDeserialize<GrantAccessResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GrantAccessResponse {
        if (!response.status.isSuccess()) {
            throwGrantAccessError(context, response)
        }
        val builder = GrantAccessResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGrantAccessOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGrantAccessError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw OpsWorksException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> OpsWorksException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGrantAccessOperationBody(builder: GrantAccessResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val TEMPORARYCREDENTIAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TemporaryCredential"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TEMPORARYCREDENTIAL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TEMPORARYCREDENTIAL_DESCRIPTOR.index -> builder.temporaryCredential = deserializeTemporaryCredentialDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
