// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.transform

import aws.sdk.kotlin.services.opsworks.model.AppType
import aws.sdk.kotlin.services.opsworks.model.DataSource
import aws.sdk.kotlin.services.opsworks.model.EnvironmentVariable
import aws.sdk.kotlin.services.opsworks.model.Source
import aws.sdk.kotlin.services.opsworks.model.SslConfiguration
import aws.sdk.kotlin.services.opsworks.model.UpdateAppRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateAppOperationSerializer: HttpSerialize<UpdateAppRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateAppRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeUpdateAppOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeUpdateAppOperationBody(context: ExecutionContext, input: UpdateAppRequest): ByteArray {
    val serializer = JsonSerializer()
    val APPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AppId"))
    val APPSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AppSource"))
    val ATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Attributes"))
    val DATASOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DataSources"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DOMAINS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Domains"))
    val ENABLESSL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("EnableSsl"))
    val ENVIRONMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Environment"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val SSLCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SslConfiguration"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPID_DESCRIPTOR)
        field(APPSOURCE_DESCRIPTOR)
        field(ATTRIBUTES_DESCRIPTOR)
        field(DATASOURCES_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DOMAINS_DESCRIPTOR)
        field(ENABLESSL_DESCRIPTOR)
        field(ENVIRONMENT_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SSLCONFIGURATION_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.appId?.let { field(APPID_DESCRIPTOR, it) }
        input.appSource?.let { field(APPSOURCE_DESCRIPTOR, it, ::serializeSourceDocument) }
        if (input.attributes != null) {
            mapField(ATTRIBUTES_DESCRIPTOR) {
                input.attributes.forEach { (key, value) -> entry(key, value) }
            }
        }
        if (input.dataSources != null) {
            listField(DATASOURCES_DESCRIPTOR) {
                for (el0 in input.dataSources) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeDataSourceDocument))
                }
            }
        }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        if (input.domains != null) {
            listField(DOMAINS_DESCRIPTOR) {
                for (el0 in input.domains) {
                    serializeString(el0)
                }
            }
        }
        input.enableSsl?.let { field(ENABLESSL_DESCRIPTOR, it) }
        if (input.environment != null) {
            listField(ENVIRONMENT_DESCRIPTOR) {
                for (el0 in input.environment) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeEnvironmentVariableDocument))
                }
            }
        }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.sslConfiguration?.let { field(SSLCONFIGURATION_DESCRIPTOR, it, ::serializeSslConfigurationDocument) }
        input.type?.let { field(TYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
