// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworks.waiters

import aws.sdk.kotlin.services.opsworks.OpsWorksClient
import aws.sdk.kotlin.services.opsworks.model.DescribeAppsRequest
import aws.sdk.kotlin.services.opsworks.model.DescribeAppsResponse
import aws.sdk.kotlin.services.opsworks.model.DescribeDeploymentsRequest
import aws.sdk.kotlin.services.opsworks.model.DescribeDeploymentsResponse
import aws.sdk.kotlin.services.opsworks.model.DescribeInstancesRequest
import aws.sdk.kotlin.services.opsworks.model.DescribeInstancesResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.SuccessAcceptor
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import kotlin.time.Duration.Companion.milliseconds


suspend fun OpsWorksClient.waitUntilAppExists(request: DescribeAppsRequest): Outcome<DescribeAppsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 1_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeAppsRequest, DescribeAppsResponse>>(
        SuccessAcceptor(RetryDirective.TerminateAndSucceed, true),
        SuccessAcceptor(RetryDirective.TerminateAndFail, false),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeApps(request) }
}

suspend fun OpsWorksClient.waitUntilAppExists(block: DescribeAppsRequest.Builder.() -> Unit): Outcome<DescribeAppsResponse> =
    waitUntilAppExists(DescribeAppsRequest.Builder().apply(block).build())

/**
 * Wait until a deployment has completed successfully.
 */
suspend fun OpsWorksClient.waitUntilDeploymentSuccessful(request: DescribeDeploymentsRequest): Outcome<DescribeDeploymentsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeDeploymentsRequest, DescribeDeploymentsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val deployments = it?.deployments
            val deploymentsOrEmpty = deployments?.flattenIfPossible() ?: listOf()
            val projection = deploymentsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection?.size ?: 0) > 1 && projection?.all { it?.toString() == "successful" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val deployments = it?.deployments
            val deploymentsOrEmpty = deployments?.flattenIfPossible() ?: listOf()
            val projection = deploymentsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "failed" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeDeployments(request) }
}

/**
 * Wait until a deployment has completed successfully.
 */
suspend fun OpsWorksClient.waitUntilDeploymentSuccessful(block: DescribeDeploymentsRequest.Builder.() -> Unit): Outcome<DescribeDeploymentsResponse> =
    waitUntilDeploymentSuccessful(DescribeDeploymentsRequest.Builder().apply(block).build())

/**
 * Wait until OpsWorks instance is online.
 */
suspend fun OpsWorksClient.waitUntilInstanceOnline(request: DescribeInstancesRequest): Outcome<DescribeInstancesResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeInstancesRequest, DescribeInstancesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection?.size ?: 0) > 1 && projection?.all { it?.toString() == "online" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "setup_failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "shutting_down" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "start_failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "stopped" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "stopping" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "terminating" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "terminated" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "stop_failed" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeInstances(request) }
}

/**
 * Wait until OpsWorks instance is online.
 */
suspend fun OpsWorksClient.waitUntilInstanceOnline(block: DescribeInstancesRequest.Builder.() -> Unit): Outcome<DescribeInstancesResponse> =
    waitUntilInstanceOnline(DescribeInstancesRequest.Builder().apply(block).build())

/**
 * Wait until OpsWorks instance is registered.
 */
suspend fun OpsWorksClient.waitUntilInstanceRegistered(request: DescribeInstancesRequest): Outcome<DescribeInstancesResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeInstancesRequest, DescribeInstancesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection?.size ?: 0) > 1 && projection?.all { it?.toString() == "registered" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "setup_failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "shutting_down" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "stopped" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "stopping" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "terminating" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "terminated" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "stop_failed" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeInstances(request) }
}

/**
 * Wait until OpsWorks instance is registered.
 */
suspend fun OpsWorksClient.waitUntilInstanceRegistered(block: DescribeInstancesRequest.Builder.() -> Unit): Outcome<DescribeInstancesResponse> =
    waitUntilInstanceRegistered(DescribeInstancesRequest.Builder().apply(block).build())

/**
 * Wait until OpsWorks instance is stopped.
 */
suspend fun OpsWorksClient.waitUntilInstanceStopped(request: DescribeInstancesRequest): Outcome<DescribeInstancesResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeInstancesRequest, DescribeInstancesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection?.size ?: 0) > 1 && projection?.all { it?.toString() == "stopped" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "booting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "pending" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "rebooting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "requested" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "running_setup" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "setup_failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "start_failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "stop_failed" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeInstances(request) }
}

/**
 * Wait until OpsWorks instance is stopped.
 */
suspend fun OpsWorksClient.waitUntilInstanceStopped(block: DescribeInstancesRequest.Builder.() -> Unit): Outcome<DescribeInstancesResponse> =
    waitUntilInstanceStopped(DescribeInstancesRequest.Builder().apply(block).build())

/**
 * Wait until OpsWorks instance is terminated.
 */
suspend fun OpsWorksClient.waitUntilInstanceTerminated(request: DescribeInstancesRequest): Outcome<DescribeInstancesResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeInstancesRequest, DescribeInstancesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection?.size ?: 0) > 1 && projection?.all { it?.toString() == "terminated" }
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ResourceNotFoundException"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "booting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "online" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "pending" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "rebooting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "requested" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "running_setup" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "setup_failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val instances = it?.instances
            val instancesOrEmpty = instances?.flattenIfPossible() ?: listOf()
            val projection = instancesOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "start_failed" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeInstances(request) }
}

/**
 * Wait until OpsWorks instance is terminated.
 */
suspend fun OpsWorksClient.waitUntilInstanceTerminated(block: DescribeInstancesRequest.Builder.() -> Unit): Outcome<DescribeInstancesResponse> =
    waitUntilInstanceTerminated(DescribeInstancesRequest.Builder().apply(block).build())
