// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.opsworkscm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a single backup.
 */
class Backup private constructor(builder: Builder) {
    /**
     * The ARN of the backup.
     */
    val backupArn: kotlin.String? = builder.backupArn
    /**
     * The generated ID of the backup. Example: `myServerName-yyyyMMddHHmmssSSS`
     */
    val backupId: kotlin.String? = builder.backupId
    /**
     * The backup type. Valid values are `automated` or `manual`.
     */
    val backupType: aws.sdk.kotlin.services.opsworkscm.model.BackupType? = builder.backupType
    /**
     * The time stamp when the backup was created in the database. Example: `2016-07-29T13:38:47.520Z`
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * A user-provided description for a manual backup. This field is empty for automated backups.
     */
    val description: kotlin.String? = builder.description
    /**
     * The engine type that is obtained from the server when the backup is created.
     */
    val engine: kotlin.String? = builder.engine
    /**
     * The engine model that is obtained from the server when the backup is created.
     */
    val engineModel: kotlin.String? = builder.engineModel
    /**
     * The engine version that is obtained from the server when the backup is created.
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The EC2 instance profile ARN that is obtained from the server when the backup is created. Because this value is stored, you are not required to provide the InstanceProfileArn again if you restore a backup.
     */
    val instanceProfileArn: kotlin.String? = builder.instanceProfileArn
    /**
     * The instance type that is obtained from the server when the backup is created.
     */
    val instanceType: kotlin.String? = builder.instanceType
    /**
     * The key pair that is obtained from the server when the backup is created.
     */
    val keyPair: kotlin.String? = builder.keyPair
    /**
     * The preferred backup period that is obtained from the server when the backup is created.
     */
    val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The preferred maintenance period that is obtained from the server when the backup is created.
     */
    val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * This field is deprecated and is no longer used.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    val s3DataSize: kotlin.Int? = builder.s3DataSize
    /**
     * This field is deprecated and is no longer used.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    val s3DataUrl: kotlin.String? = builder.s3DataUrl
    /**
     * The Amazon S3 URL of the backup's log file.
     */
    val s3LogUrl: kotlin.String? = builder.s3LogUrl
    /**
     * The security group IDs that are obtained from the server when the backup is created.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The name of the server from which the backup was made.
     */
    val serverName: kotlin.String? = builder.serverName
    /**
     * The service role ARN that is obtained from the server when the backup is created.
     */
    val serviceRoleArn: kotlin.String? = builder.serviceRoleArn
    /**
     * The status of a backup while in progress.
     */
    val status: aws.sdk.kotlin.services.opsworkscm.model.BackupStatus? = builder.status
    /**
     * An informational message about backup status.
     */
    val statusDescription: kotlin.String? = builder.statusDescription
    /**
     * The subnet IDs that are obtained from the server when the backup is created.
     */
    val subnetIds: List<String>? = builder.subnetIds
    /**
     * The version of AWS OpsWorks CM-specific tools that is obtained from the server when the backup is created.
     */
    val toolsVersion: kotlin.String? = builder.toolsVersion
    /**
     * The IAM user ARN of the requester for manual backups. This field is empty for automated backups.
     */
    val userArn: kotlin.String? = builder.userArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.opsworkscm.model.Backup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Backup(")
        append("backupArn=$backupArn,")
        append("backupId=$backupId,")
        append("backupType=$backupType,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("engine=$engine,")
        append("engineModel=$engineModel,")
        append("engineVersion=$engineVersion,")
        append("instanceProfileArn=$instanceProfileArn,")
        append("instanceType=$instanceType,")
        append("keyPair=$keyPair,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("s3DataSize=$s3DataSize,")
        append("s3DataUrl=$s3DataUrl,")
        append("s3LogUrl=$s3LogUrl,")
        append("securityGroupIds=$securityGroupIds,")
        append("serverName=$serverName,")
        append("serviceRoleArn=$serviceRoleArn,")
        append("status=$status,")
        append("statusDescription=$statusDescription,")
        append("subnetIds=$subnetIds,")
        append("toolsVersion=$toolsVersion,")
        append("userArn=$userArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupArn?.hashCode() ?: 0
        result = 31 * result + (backupId?.hashCode() ?: 0)
        result = 31 * result + (backupType?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineModel?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (instanceProfileArn?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (keyPair?.hashCode() ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (s3DataSize ?: 0)
        result = 31 * result + (s3DataUrl?.hashCode() ?: 0)
        result = 31 * result + (s3LogUrl?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (serverName?.hashCode() ?: 0)
        result = 31 * result + (serviceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusDescription?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (toolsVersion?.hashCode() ?: 0)
        result = 31 * result + (userArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Backup

        if (backupArn != other.backupArn) return false
        if (backupId != other.backupId) return false
        if (backupType != other.backupType) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (engine != other.engine) return false
        if (engineModel != other.engineModel) return false
        if (engineVersion != other.engineVersion) return false
        if (instanceProfileArn != other.instanceProfileArn) return false
        if (instanceType != other.instanceType) return false
        if (keyPair != other.keyPair) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (s3DataSize != other.s3DataSize) return false
        if (s3DataUrl != other.s3DataUrl) return false
        if (s3LogUrl != other.s3LogUrl) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (serverName != other.serverName) return false
        if (serviceRoleArn != other.serviceRoleArn) return false
        if (status != other.status) return false
        if (statusDescription != other.statusDescription) return false
        if (subnetIds != other.subnetIds) return false
        if (toolsVersion != other.toolsVersion) return false
        if (userArn != other.userArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.opsworkscm.model.Backup = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ARN of the backup.
         */
        var backupArn: kotlin.String? = null
        /**
         * The generated ID of the backup. Example: `myServerName-yyyyMMddHHmmssSSS`
         */
        var backupId: kotlin.String? = null
        /**
         * The backup type. Valid values are `automated` or `manual`.
         */
        var backupType: aws.sdk.kotlin.services.opsworkscm.model.BackupType? = null
        /**
         * The time stamp when the backup was created in the database. Example: `2016-07-29T13:38:47.520Z`
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A user-provided description for a manual backup. This field is empty for automated backups.
         */
        var description: kotlin.String? = null
        /**
         * The engine type that is obtained from the server when the backup is created.
         */
        var engine: kotlin.String? = null
        /**
         * The engine model that is obtained from the server when the backup is created.
         */
        var engineModel: kotlin.String? = null
        /**
         * The engine version that is obtained from the server when the backup is created.
         */
        var engineVersion: kotlin.String? = null
        /**
         * The EC2 instance profile ARN that is obtained from the server when the backup is created. Because this value is stored, you are not required to provide the InstanceProfileArn again if you restore a backup.
         */
        var instanceProfileArn: kotlin.String? = null
        /**
         * The instance type that is obtained from the server when the backup is created.
         */
        var instanceType: kotlin.String? = null
        /**
         * The key pair that is obtained from the server when the backup is created.
         */
        var keyPair: kotlin.String? = null
        /**
         * The preferred backup period that is obtained from the server when the backup is created.
         */
        var preferredBackupWindow: kotlin.String? = null
        /**
         * The preferred maintenance period that is obtained from the server when the backup is created.
         */
        var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * This field is deprecated and is no longer used.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        var s3DataSize: kotlin.Int? = null
        /**
         * This field is deprecated and is no longer used.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        var s3DataUrl: kotlin.String? = null
        /**
         * The Amazon S3 URL of the backup's log file.
         */
        var s3LogUrl: kotlin.String? = null
        /**
         * The security group IDs that are obtained from the server when the backup is created.
         */
        var securityGroupIds: List<String>? = null
        /**
         * The name of the server from which the backup was made.
         */
        var serverName: kotlin.String? = null
        /**
         * The service role ARN that is obtained from the server when the backup is created.
         */
        var serviceRoleArn: kotlin.String? = null
        /**
         * The status of a backup while in progress.
         */
        var status: aws.sdk.kotlin.services.opsworkscm.model.BackupStatus? = null
        /**
         * An informational message about backup status.
         */
        var statusDescription: kotlin.String? = null
        /**
         * The subnet IDs that are obtained from the server when the backup is created.
         */
        var subnetIds: List<String>? = null
        /**
         * The version of AWS OpsWorks CM-specific tools that is obtained from the server when the backup is created.
         */
        var toolsVersion: kotlin.String? = null
        /**
         * The IAM user ARN of the requester for manual backups. This field is empty for automated backups.
         */
        var userArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.opsworkscm.model.Backup) : this() {
            this.backupArn = x.backupArn
            this.backupId = x.backupId
            this.backupType = x.backupType
            this.createdAt = x.createdAt
            this.description = x.description
            this.engine = x.engine
            this.engineModel = x.engineModel
            this.engineVersion = x.engineVersion
            this.instanceProfileArn = x.instanceProfileArn
            this.instanceType = x.instanceType
            this.keyPair = x.keyPair
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.s3DataSize = x.s3DataSize
            this.s3DataUrl = x.s3DataUrl
            this.s3LogUrl = x.s3LogUrl
            this.securityGroupIds = x.securityGroupIds
            this.serverName = x.serverName
            this.serviceRoleArn = x.serviceRoleArn
            this.status = x.status
            this.statusDescription = x.statusDescription
            this.subnetIds = x.subnetIds
            this.toolsVersion = x.toolsVersion
            this.userArn = x.userArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.opsworkscm.model.Backup = Backup(this)
    }
}
